<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjMemberModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'members';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'uuid', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'group_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'first_name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'last_name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'email', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'password', 'type' => 'blob', 'default' => ':NULL', 'encrypt' => 'AES'),
		array('name' => 'phone', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'website', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'gender', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'age', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'birthday', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'address', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'city', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'state', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'country_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'zip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'company_name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'ip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'membership_expire', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'modified', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'last_login', 'type' => 'datetime', 'default' => ':NULL'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'T'),
		array('name' => 'is_reg_fee_paid', 'type' => 'tinyint', 'default' => 0)
	);
	
	public $i18n = array('name');

	public $validate = array(
		'rules' => array(
			'group_id' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			)
		)
	);

	public static function factory($attr=array())
	{
		return new pjMemberModel($attr);
	}

	public function beforeValidate($options, $type = 'register')
	{
		if (empty($options)) {
			return $this;
		}

		if (!in_array($type, array('register', 'profile'))) {
			return $this;
		}

		$t = 'pf';
		if ($type == 'register') {
			$t = 'rf';
		}

		$rules = array();
		if ($options[sprintf('o_%s_include_address', $t)] == 3) {
			$rules = array_merge($rules, array('address' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_age', $t)] == 3) {
			$rules = array_merge($rules, array('age' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_birthday', $t)] == 3) {
			$rules = array_merge($rules, array('birthday' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_city', $t)] == 3) {
			$rules = array_merge($rules, array('city' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_company', $t)] == 3) {
			$rules = array_merge($rules, array('company' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_country', $t)] == 3) {
			$rules = array_merge($rules, array('country' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_email', $t)] == 3) {
			$rules = array_merge($rules, array('email' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_fname', $t)] == 3) {
			$rules = array_merge($rules, array('first_name' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_gender', $t)] == 3) {
			$rules = array_merge($rules, array('gender' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_lname', $t)] == 3) {
			$rules = array_merge($rules, array('last_name' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_password', $t)] == 3) {
			$rules = array_merge($rules, array('password' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_phone', $t)] == 3) {
			$rules = array_merge($rules, array('phone' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_state', $t)] == 3) {
			$rules = array_merge($rules, array('state' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_website', $t)] == 3) {
			$rules = array_merge($rules, array('website' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}
		if ($options[sprintf('o_%s_include_zip', $t)] == 3) {
			$rules = array_merge($rules, array('zip' => array('pjActionRequired' => true, 'pjActionNotEmpty' => true)));
		}

		if (!empty($rules)) {
			$this->validate['rules'] = array_merge($this->validate['rules'], $rules);
		}

		return $this;
	}
}
?>