<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMembers&amp;action=pjActionIndex"><?php __('menuMembers'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMembers&amp;action=pjActionImport"><?php __('lblImport'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjInvoice&amp;action=pjActionInvoices"><?php __('plugin_invoice_menu_invoices'); ?></a></li>
		</ul>
	</div>
	<div id="tabs">
		<ul>
			<li><a href="#tabs-1"><?php __('tabDetails'); ?></a></li>
			<?php if (pjObject::getPlugin('pjInvoice') !== NULL) : ?>
			<li><a href="#tabs-2"><?php __('plugin_invoice_menu_invoices'); ?></a></li>
			<?php endif; ?>
		</ul>
		<div id="tabs-1">
			<?php
			pjUtil::printNotice(__('infoUpdateMemberTitle', true), __('infoUpdateMemberBody', true));
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMembers&amp;action=pjActionUpdate" method="post" id="frmUpdateMember" class="form pj-form" autocomplete="off">
				<input type="hidden" name="member_update" value="1" />
				<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
				<input type="hidden" name="uuid" value="<?php echo $tpl['arr']['uuid']; ?>" />
				<p>
					<label class="title"><?php __('lblCreatedDateTime'); ?></label>
					<span class="inline_block">
						<label class="content"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblModifiedDateTime'); ?></label>
					<span class="inline_block">
						<label class="content"><?php echo !empty($tpl['arr']['modified']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['modified'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['modified'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : __('lblNA', true); ?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblLastLogin'); ?></label>
					<span class="inline_block">
						<label class="content"><?php echo !empty($tpl['arr']['last_login']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : __('lblNA', true); ?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblIp'); ?></label>
					<span class="inline_block">
						<label class="content"><?php echo $tpl['arr']['ip']; ?></label>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblTotalInvoices'); ?></label>
					<span class="inline_block">
						<label class="content"><a href="#" class="totalInvoices"><?php echo $tpl['total_invoices']; ?></a></label>
					</span>
				</p>
				<?php
				if($tpl['total_invoices'] > 0)
				{ 
					?>
					<p>
						<label class="title"><?php __('lblLastInvoice'); ?></label>
						<span class="inline_block">
							<label class="content"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjInvoice&action=pjActionUpdate&id=<?php echo $tpl['last_invoice']['id'];?>"><?php echo !empty($tpl['last_invoice']['created']) ? pjUtil::formatDate(date('Y-m-d', strtotime($tpl['last_invoice']['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['last_invoice']['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']) : ''; ?></a></label>
						</span>
					</p>
					<?php
				} 
				?>
				<p>
					<label class="title"><?php __('lblGroup'); ?></label>
					<span class="inline_block">
						<select id="group_id" name="group_id" class="pj-form-field w300 required pjMLChosen">
							<option value=""><?php __('lblChoose'); ?></option>
							<?php
							foreach ($tpl['group_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['group_id'] ? 'selected="selected"' : null; ?>><?php echo $v['group_title']; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<?php
				$generated_expired_date = null;
				if(empty($tpl['arr']['membership_expire']))
				{
					switch ($tpl['group']['subscription_period']) {
						case 'week':
							$generated_expired_date = date($tpl['option_arr']['o_date_format'], time() + 7 * 86400);
							break;
								
						case 'month':
							$generated_expired_date = date($tpl['option_arr']['o_date_format'], time() + 30 * 86400);
							break;
						case 'year':
							$generated_expired_date = date($tpl['option_arr']['o_date_format'], time() + 365 * 86400);
							break;
					}
				} 
				?>
				<p>
					<label class="title"><?php __('lblExpiration'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="membership_expire" id="membership_expire" class="pj-form-field pointer w100 datepick" value="<?php echo !empty($tpl['arr']['membership_expire']) ? pjUtil::formatDate($tpl['arr']['membership_expire'], "Y-m-d", $tpl['option_arr']['o_date_format']) : $generated_expired_date; ?>"  readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblFirstName'); ?></label>
					<span class="inline_block">
						<input type="text" name="first_name" id="first_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['first_name'])); ?>" class="pj-form-field w200 required" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblLastName'); ?></label>
					<span class="inline_block">
						<input type="text" name="last_name" id="last_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['last_name'])); ?>" class="pj-form-field w200" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblEmail'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="email" id="email" class="pj-form-field w300 email required" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['email'])); ?>" placeholder="info@domain.com" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('pass'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
						<input type="text" name="password" id="password" class="pj-form-field required w200" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['password'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPhone'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="phone" id="phone" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['phone'])); ?>" class="pj-form-field w150" placeholder="(123) 456-7890" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblWebsite'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
						<input type="text" name="website" id="website" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['website'])); ?>" class="pj-form-field w300 url" placeholder="http://www.domain.com"  />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblGender'); ?></label>
					<span class="inline_block">
						<select name="gender" id="gender" class="pj-form-field">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('genderarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $k == $tpl['arr']['gender'] ? 'selected="selected"' : null; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblAge'); ?></label>
					<span class="inline_block">
						<input type="text" name="age" id="age" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['age'])); ?>" class="pj-form-field field-int w60" value="" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblBirthday'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="birthday" id="birthday" class="pj-form-field pointer w100 datepick-birthday" value="<?php echo !empty($tpl['arr']['birthday']) ? pjUtil::formatDate($tpl['arr']['birthday'], "Y-m-d", $tpl['option_arr']['o_date_format']) : null; ?>"  readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblAddress'); ?></label>
					<span class="inline_block">
						<textarea id="address" name="address" class="textarea h80 w450"><?php echo htmlspecialchars(stripslashes($tpl['arr']['address'])); ?></textarea>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblCity'); ?></label>
					<span class="inline_block">
						<input type="text" name="city" id="city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['city'])); ?>" class="pj-form-field w200" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblState'); ?></label>
					<span class="inline_block">
						<input type="text" name="state" id="state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['state'])); ?>" class="pj-form-field w200" />
					</span>
				</p>
				
				<p>
					<label class="title"><?php __('lblCountry'); ?></label>
					<span class="inline_block">
						<select id="country_id" name="country_id" class="pj-form-field w350 pjMLChosen">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['country_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>" <?php echo $v['id'] == $tpl['arr']['country_id'] ? 'selected="selected"' : null; ?>><?php echo $v['country_title']; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				
				<p>
					<label class="title"><?php __('lblZip'); ?></label>
					<span class="inline_block">
						<input type="text" name="zip" id="zip" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['zip'])); ?>" class="pj-form-field w150" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblCompanyName'); ?></label>
					<span class="inline_block">
						<input type="text" name="company_name" id="company_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['company_name'])); ?>" class="pj-form-field w350" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $k == $tpl['arr']['status'] ? 'selected="selected"' : null; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminMembers&action=pjActionIndex';" />
				</p>
			</form>
		</div>
		<?php
		if (pjObject::getPlugin('pjInvoice') !== NULL)
		{
			$map = array(
				'completed' => 'paid',
				'pending' => 'not_paid',
				'new' => 'not_paid',
				'cancelled' => 'cancelled'
			);
			?>
			<div id="tabs-2">
				<fieldset class="fieldset white" style="position: static">
					<legend><?php __('member_invoice_details'); ?></legend>
					
					<div id="grid_invoices" class="t10 b10"></div>
				</fieldset>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	$statuses = __('plugin_invoice_statuses', true);
	?>
	<script type="text/javascript">
		var pjGrid = pjGrid || {};
		pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
		pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
		var myLabel = myLabel || {};
		myLabel.email_taken = "<?php __('pj_email_taken'); ?>";
		
		myLabel.num = "<?php __('plugin_invoice_i_num', false, true); ?>";
		myLabel.order_id = "<?php __('plugin_invoice_i_order_id', false, true); ?>";
		myLabel.issue_date = "<?php __('plugin_invoice_i_issue_date', false, true); ?>";
		myLabel.due_date = "<?php __('plugin_invoice_i_due_date', false, true); ?>";
		myLabel.created = "<?php __('plugin_invoice_i_created', false, true); ?>";
		myLabel.status = "<?php __('plugin_invoice_i_status', false, true); ?>";
		myLabel.total = "<?php __('plugin_invoice_i_total', false, true); ?>";
		myLabel.delete_title = "<?php __('plugin_invoice_i_delete_title', false, true); ?>";
		myLabel.delete_body = "<?php __('plugin_invoice_i_delete_body', false, true); ?>";
		myLabel.paid = "<?php echo $statuses['paid']; ?>";
		myLabel.not_paid = "<?php echo $statuses['not_paid']; ?>";
		myLabel.cancelled = "<?php echo $statuses['cancelled']; ?>";
		myLabel.empty_date = "<?php __('gridEmptyDate', false, true); ?>";
		myLabel.invalid_date = "<?php __('gridInvalidDate', false, true); ?>";
		myLabel.empty_datetime = "<?php __('gridEmptyDatetime', false, true); ?>";
		myLabel.invalid_datetime = "<?php __('gridInvalidDatetime', false, true); ?>";
		myLabel.select_slots = "<?php __('lblSelectSlotToBook', false, true); ?>";
	</script>
	<?php
}
?>