var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmUpdateOptions = $("#frmUpdateOptions"),
			$frmNotification = $("#frmNotification"),
			tabs = ($.fn.tabs !== undefined),
			chosen = ($.fn.chosen !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			validate = ($.fn.validate !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		if (chosen) {
			$("#group_id").chosen();
			$("#protected_group_id").chosen();
		}
		$(".field-int").spinner({
			min: 0
		});
		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
		if ($frmUpdateOptions.length > 0 && validate) {
			$frmUpdateOptions.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ''
			});
		}
		
		function setInstallRegister()
		{
			var clone_text = $('#install_register_clone').text(),
				group_id = $('#group_id').val(),
				member_select = 'No';
			if ($("input[name='member_select']").is(':checked')) 
			{
				member_select = 'Yes';
			}
			clone_text = clone_text.replace('{MemberSelect}', '&pjSelect=' + member_select);
			if(group_id == '' || group_id == null)
			{
				clone_text = clone_text.replace('{GroupID}', '');
			}else{
				clone_text = clone_text.replace('{GroupID}', '&group_id=' + group_id);
			}
			if(member_select == 'Yes' || group_id != '')
			{
				$('#install_register').val(clone_text);
			}else{
				$('#install_register').val('');
			}
		}
		function setInstallProtected()
		{
			var clone_text = $('#install_protected_clone').text(),
				group_id = $('#protected_group_id').val();
				
			clone_text = clone_text.replace('{GroupID}', '$pjGroup = "' + group_id + '";\n');
			
			$('#install_protected').val(clone_text);
		}
		
		setInstallRegister();
		setInstallProtected();
		
		if($frmNotification.length > 0)
		{
			changeNotifyBox();
			
			tinymce.init({
				relative_urls : false,
				remove_script_host : false,
			    selector: ".mceEditor",
			    theme: "modern",
			    width: 560,
			    height: 400,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
		
		function changeNotifyBox()
		{
			var notify_id = $('#notify_id').val();
			$('.pjMLNotifyBox').hide();
			$('#pjMLNotifyBox_' + notify_id).show();
		}
		
		$("#content").on("focus", ".textarea_install", function (e) {
			var $this = $(this);
			$this.select();
			$this.mouseup(function() {
				$this.unbind("mouseup");
				return false;
			});
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_facebook_allow']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::Yes':
				$(".boxFacebook").show();
				break;
			case 'Yes|No::No':
				$(".boxFacebook").hide();
				break;
			}
		}).on("change", "select[name='value-enum-o_google_allow']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::Yes':
				$(".boxGoogle").show();
				break;
			case 'Yes|No::No':
				$(".boxGoogle").hide();
				break;
			}
		}).on("change", "#group_id", function (e) {
			setInstallRegister();
		}).on("click", "input[name='member_select']", function (e) {
			setInstallRegister();
		}).on("change", "#protected_group_id", function (e) {
			setInstallProtected();
		}).on("click", ".pj-checkbox", function () {
			var $this = $(this);
			if ($this.find("input[type='checkbox']").is(":checked")) {
				$this.addClass("pj-checkbox-checked");
			} else {
				$this.removeClass("pj-checkbox-checked");
			}
			
			var reg_field_str = $('.registration-fields:checked').map(function(e){
				 return $(this).val();
			}).get();
			var pro_field_str = $('.profile-fields:checked').map(function(e){
				 return $(this).val();
			}).get();
			$('#o_registration_form').val(reg_field_str);
			$('#o_profile_form').val(pro_field_str);
		}).on("change", "#notify_id", function (e) {
			changeNotifyBox();
		});
	});
})(jQuery_1_8_2);