DROP TABLE IF EXISTS `product_comparison_products`;
CREATE TABLE IF NOT EXISTS `product_comparison_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_models`;
CREATE TABLE IF NOT EXISTS `product_comparison_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_products_categories`;
CREATE TABLE IF NOT EXISTS `product_comparison_products_categories` (
  `product_id` int(10) NOT NULL,
  `category_id` int(10) NOT NULL,
  PRIMARY KEY (`product_id`, `category_id`),
  KEY `product_id` (`product_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_features_models`;
CREATE TABLE IF NOT EXISTS `product_comparison_features_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feature_id` int(10) DEFAULT NULL,
  `model_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feature_id` (`feature_id`),
  KEY `model_id` (`model_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_product_features`;
CREATE TABLE IF NOT EXISTS `product_comparison_product_features` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  `order` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_categories`;
CREATE TABLE IF NOT EXISTS `product_comparison_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_fields`;
CREATE TABLE IF NOT EXISTS `product_comparison_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_multi_lang`;
CREATE TABLE IF NOT EXISTS `product_comparison_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_options`;
CREATE TABLE IF NOT EXISTS `product_comparison_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_roles`;
CREATE TABLE IF NOT EXISTS `product_comparison_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `product_comparison_users`;
CREATE TABLE IF NOT EXISTS `product_comparison_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `product_comparison_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 0, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 0, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `product_comparison_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `product_comparison_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(104, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(105, 'url', 'backend', 'URL', 'script', NULL),
(106, 'user', 'backend', 'Username', 'script', NULL),
(107, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(108, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(109, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(110, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(111, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(112, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(113, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(114, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(115, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(116, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(117, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(118, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(119, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(120, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(121, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(122, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(123, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(124, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(125, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(126, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(127, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(128, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(129, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(130, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(131, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(132, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(133, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(134, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(135, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(136, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(137, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(138, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(139, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(140, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(141, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(142, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(143, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(144, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(145, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(146, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(147, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(148, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(149, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(150, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(151, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(152, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(153, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(154, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(155, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(156, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(157, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(158, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(159, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(160, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(161, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(162, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(163, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(164, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(165, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(166, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(167, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(168, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(169, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(170, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(171, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(172, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(173, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(174, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(175, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(176, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(177, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(178, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(179, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(180, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(181, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(182, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(183, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(184, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(185, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(186, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(187, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(188, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(189, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(190, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(191, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(192, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(193, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(194, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(195, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(196, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(197, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(198, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(199, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(200, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(201, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(202, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(203, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(204, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(205, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(206, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(207, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(208, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(209, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(210, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(211, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(212, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(213, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(214, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(215, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(216, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(217, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(218, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(219, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(220, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(221, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(222, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(223, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(224, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(225, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(226, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(227, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(228, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(229, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(230, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(231, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(232, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(233, 'menuInstall', 'backend', 'Menu / Preview & Install', 'script', NULL),
(234, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(235, 'menuProductFeatures', 'backend', 'Menu / Product Features', 'script', NULL),
(236, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(237, 'menuProducts', 'backend', 'Menu / Products', 'script', NULL),
(238, 'category_name', 'backend', 'Label / Category name', 'script', NULL),
(239, 'infoCategoriesTitle', 'backend', 'Infobox / Categories list', 'script', NULL),
(240, 'infoCategoriesDesc', 'backend', 'Infobox / Categories list', 'script', NULL),
(241, 'category_add', 'backend', 'Label / Add Category', 'script', NULL),
(242, 'infoAddCategoryTitle', 'backend', 'Infobox / Add new category', 'script', NULL),
(243, 'infoAddCategoryDesc', 'backend', 'Infobox / Add new category', 'script', NULL),
(244, 'description', 'backend', 'Label / Description', 'script', NULL),
(245, 'pc_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(246, 'pc_same_category', 'backend', 'Label / Category name was already used.', 'script', NULL),
(247, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(248, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(249, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(250, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(251, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(252, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(253, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(254, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(255, 'category_update', 'backend', 'Label / Update Category', 'script', NULL),
(256, 'infoUpdateCategoryTitle', 'backend', 'Infobox / Update category', 'script', NULL),
(257, 'infoUpdateCategoryDesc', 'backend', 'Infobox / Update category', 'script', NULL),
(258, 'title', 'backend', 'Label / Title', 'script', NULL),
(259, 'product_feature_add', 'backend', 'Label / Add Product Feature', 'script', NULL),
(260, 'product_feature_update', 'backend', 'Label / Update Product Feature', 'script', NULL),
(261, 'infoProductFeaturesDesc', 'backend', 'Infobox / Product Features', 'script', NULL),
(262, 'infoProductFeaturesTitle', 'backend', 'Infobox / Product Features', 'script', NULL),
(263, 'infoAddProductFeatureTitle', 'backend', 'Infobox / Add new product feature', 'script', NULL),
(264, 'infoAddProductFeatureDesc', 'backend', 'Infobox / Add new product feature', 'script', NULL),
(265, 'infoUpdateProductFeatureTitle', 'backend', 'Infobox / Update product feature', 'script', NULL),
(266, 'infoUpdateProductFeatureDesc', 'backend', 'Infobox / Update product feature', 'script', NULL),
(267, 'error_titles_ARRAY_APF01', 'arrays', 'error_titles_ARRAY_APF01', 'script', NULL),
(268, 'error_bodies_ARRAY_APF01', 'arrays', 'error_bodies_ARRAY_APF01', 'script', NULL),
(269, 'error_titles_ARRAY_APF03', 'arrays', 'error_titles_ARRAY_APF03', 'script', NULL),
(270, 'error_bodies_ARRAY_APF03', 'arrays', 'error_bodies_ARRAY_APF03', 'script', NULL),
(271, 'error_titles_ARRAY_APF04', 'arrays', 'error_titles_ARRAY_APF04', 'script', NULL),
(272, 'error_bodies_ARRAY_APF04', 'arrays', 'error_bodies_ARRAY_APF04', 'script', NULL),
(273, 'error_titles_ARRAY_APF08', 'arrays', 'error_titles_ARRAY_APF08', 'script', NULL),
(274, 'error_bodies_ARRAY_APF08', 'arrays', 'error_bodies_ARRAY_APF08', 'script', NULL),
(275, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(276, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(277, 'image', 'backend', 'Label / Image', 'script', NULL),
(278, 'category', 'backend', 'Label / Category', 'script', NULL),
(279, 'delete_image', 'backend', 'Label / Delete image', 'script', NULL),
(280, 'delete_image_confirmation', 'backend', 'Label / Delete image', 'script', NULL),
(281, 'delete', 'backend', 'Label / Delete', 'script', NULL),
(282, 'product_add', 'backend', 'Label / Add Product', 'script', NULL),
(283, 'product_name', 'backend', 'Label / Product name', 'script', NULL),
(284, 'infoProductsTitle', 'backend', 'Infobox / Products list', 'script', NULL),
(285, 'infoProductsDesc', 'backend', 'Infobox / Products list', 'script', NULL),
(286, 'product_models', 'backend', 'Label / Product models', 'script', NULL),
(287, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(288, 'categories', 'backend', 'Label / Categories', 'script', NULL),
(289, 'infoAddProductTitle', 'backend', 'Infobox / Add new product', 'script', NULL),
(290, 'infoAddProductDesc', 'backend', 'Infobox / Add new product', 'script', NULL),
(291, 'product_udpate', 'backend', 'Label / Update Product', 'script', NULL),
(292, 'details', 'backend', 'Label / Details', 'script', NULL),
(293, 'features', 'backend', 'Label / Features', 'script', NULL),
(294, 'infoUpdateProductTitle', 'backend', 'Infobox / Product details', 'script', NULL),
(295, 'infoUpdateProductDesc', 'backend', 'Infobox / Product details', 'script', NULL),
(296, 'infoUpdateFeaturesTitle', 'backend', 'Infobox / Product features', 'script', NULL),
(297, 'infoUpdateFeaturesDesc', 'backend', 'Infobox / Product features', 'script', NULL),
(298, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(299, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(300, 'error_titles_ARRAY_AP02', 'arrays', 'error_titles_ARRAY_AP02', 'script', NULL),
(301, 'error_bodies_ARRAY_AP02', 'arrays', 'error_bodies_ARRAY_AP02', 'script', NULL),
(302, 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', NULL),
(303, 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', NULL),
(304, 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', NULL),
(305, 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', NULL),
(306, 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', NULL),
(307, 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', NULL),
(308, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(309, 'lblInstallJs1_title', 'backend', 'Label / Installation', 'script', NULL),
(310, 'lblInstallJs1_body', 'backend', 'Label / Installation body', 'script', NULL),
(311, 'lblInstallConfig', 'backend', 'Label / Installation configuration', 'script', NULL),
(312, 'lblInstallConfigLocale', 'backend', 'Label / Select language', 'script', NULL),
(313, 'lblInstallConfigProduct', 'backend', 'Label / Select product', 'script', NULL),
(314, 'front_filter_by', 'frontend', 'Label / Filter by', 'script', NULL),
(315, 'front_select_models', 'frontend', 'Label / Select models to compare', 'script', NULL),
(316, 'lblOrder', 'frontend', 'Label / Order', 'script', NULL),
(317, 'front_backto_top', 'frontend', 'Label / back to top', 'script', NULL),
(318, 'btnAddModel', 'backend', 'Button / Add model', 'script', NULL),
(319, 'lblSelectCategories', 'backend', 'Label / Select categories', 'script', NULL),
(320, 'lblFeatures', 'backend', 'Label / Features Assigned', 'script', NULL),
(321, 'lblDeleteModel', 'backend', 'Label / Delete model', 'script', NULL),
(322, 'lblDeleteModelConfirmation', 'backend', 'Label / Delete model', 'script', NULL),
(323, 'lblFilterByCategory', 'backend', 'Label / Filter by category', 'script', NULL),
(324, 'lblModels', 'backend', 'Label / Models', 'script', NULL),
(325, 'lblCategories', 'backend', 'Label / Categories', 'script', NULL),
(326, 'error_titles_ARRAY_APF05', 'arrays', 'error_titles_ARRAY_APF05', 'script', NULL),
(327, 'error_bodies_ARRAY_APF05', 'arrays', 'error_bodies_ARRAY_APF05', 'script', NULL),
(328, 'error_titles_ARRAY_APF06', 'arrays', 'error_titles_ARRAY_APF06', 'script', NULL),
(329, 'error_bodies_ARRAY_APF06', 'arrays', 'error_bodies_ARRAY_APF06', 'script', NULL),
(330, 'error_titles_ARRAY_APF09', 'arrays', 'error_titles_ARRAY_APF09', 'script', NULL),
(331, 'error_bodies_ARRAY_APF09', 'arrays', 'error_bodies_ARRAY_APF09', 'script', NULL),
(332, 'error_titles_ARRAY_APF10', 'arrays', 'error_titles_ARRAY_APF10', 'script', NULL),
(333, 'error_bodies_ARRAY_APF10', 'arrays', 'error_bodies_ARRAY_APF10', 'script', NULL),
(334, 'error_titles_ARRAY_APF11', 'arrays', 'error_titles_ARRAY_APF11', 'script', NULL),
(335, 'error_bodies_ARRAY_APF11', 'arrays', 'error_bodies_ARRAY_APF11', 'script', NULL),
(336, 'error_titles_ARRAY_APF12', 'arrays', 'error_titles_ARRAY_APF12', 'script', NULL),
(337, 'error_bodies_ARRAY_APF12', 'arrays', 'error_bodies_ARRAY_APF12', 'script', NULL);

INSERT INTO `product_comparison_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Product Features', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Category name', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Categories list', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Below is the list of categories. Each category contains name and description. In order to view or edit a specific category, please click on the edit icon. Let click on the Add Category tab to add new category.', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Add Category', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Add new category', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Please fill in the form below and click Save button to add new category.', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Category name was already used.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Category updated', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'All changes made to the category have been saved.', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Category added', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'A new category has been added into the list.', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Category failed to add', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'We are sorry that new category could not be added successfully.', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Category not found', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'We are sorry that category you are looking for is missing.', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Update Category', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Let make any change as you want on the form below and click Save button to update category information.', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Add Product Feature', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Update Product Feature', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'You can find here the list of product features. Each product feature will include title, description, image, and a category that it''s belong to.', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'List of product features', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Add new product feature', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Please fill in the form below and click Save button to add new product feature.', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Update product feature', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'You can make any change on the form below and click on Save button to update the information of the selected product feature.', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Product feature updated', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'All changes made on the product feature have been saved successfully.', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Product feature added', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'A new product feature has been added to the list.', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Failed to add product feature', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'We are sorry that the new product feature could not be added successfully.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Product feature not found', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'We are sorry that the product feature you are looking is missing in the system.', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Add Product', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Product name', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Products list', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Here you can find the list of products. Each product will have one or many categories and models as well. In order to see more details of product, let click on the the Edit icon.  ', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Product models', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Add new product', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Each product can has many models and belong to one or many categories. Please fill in the form below and click on Save button to add new product and then you can set more information for that product. ', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Update Product', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Features', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Product details', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'You can make any change on the form below to update the details of the product and click on Save button to commit the changes. In order to define features for the product, let click on the tab Features.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Product features', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Please fill out the form below and click Save button to define features for the product.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Product updated', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'All changes made on the product have been saved successfully.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Product updated', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'All features of the product have been saved successfully.', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Product added', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'A new product has been added to the list.', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Product failed to add', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'We are sorry that the product could not be saved correctly.', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Product not found', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'We are sorry that the product you are looking for is missing.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Installation', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Please follow the steps below to install the comparison table on your web page. You can select which product to make the comparison between its models. It''s optional you can select which language to make the installation. Then you must copy code in the text area and paste it into where you want the comparison table to be appeared.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Installation configuration', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Select language', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Select product', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Select models to compare', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'back to top', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Add model', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Select categories', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Features Assigned', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Delete model', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Are you sure you wish to delete the selected model?', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Filter by category', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Models', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'New product feature could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'The product feature could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Image size exceeded', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'A new product feature has been added to the list but image was not uploaded as its size exceeds the maximum allowed file upload size.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Image size exceeded', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'The product feature has been updated but image was not uploaded as its size exceeds the maximum allowed file upload size.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'File type not allowed', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'The product feature has been updated but image was not uploaded as the file type is not allowed to upload. Please check the mime content type of the file.', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'File type not allowed', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'The product feature has been added but image was not uploaded as the file type is not allowed to upload. Please check the mime content type of the file.', 'script');