<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="b10 fs13"><?php __('lblProduct');?>: <b><?php echo pjSanitize::html($tpl['arr']['product_name']);?></b></div>
	
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['id']?>"><?php __('details'); ?></a></li>
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionFeature&amp;id=<?php echo $tpl['arr']['id']?>"><?php __('features'); ?></a></li>
		</ul>
	</div>
	<?php
	pjUtil::printNotice(__('infoUpdateFeaturesTitle', true, false), __('infoUpdateFeaturesDesc', true, false));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionFeature" method="post" id="frmUpdateFeature" class="pj-form form">
		<input type="hidden" name="feature_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']?>" />
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif;?>
		<div class="clear_both">
			<br/>
			<div class="pj-feature-grid">
				<?php
				$col_width = 250;
				$number_of_models = count($tpl['model_arr']);
				$number_of_categories = count($tpl['category_arr']);
				if($number_of_models > 0 && $number_of_categories > 0)
				{
					?>
					<div class="pj-first-column">
						<table cellpadding="0" cellspacing="0" border="0" class="display">
							<thead>
								<tr class="title-head-row">
									<th>&nbsp;</th>
								</tr>
							</thead>
							<tbody>
								<?php
								foreach($tpl['category_arr'] as $k => $category)
								{
									?>
									<tr class="title-row category-row" lang="cat_<?php echo $category['id']; ?>">
										<td><?php echo pjSanitize::clean($category['name'])?></td>
									</tr>
									<?php
									if(isset($category['features']) && !empty($category['features']))
									{
										$feature_arr = $category['features'];
										foreach($feature_arr as $feature)
										{
											?>
											<tr class="title-row" lang="fea_<?php echo $feature['id']; ?>">
												<td><?php echo pjSanitize::clean($feature['title'])?></td>
											</tr>
											<?php
										}
									}
								} 
								?>
							</tbody>
						</table>
					</div>
					<div class="pj-feature-column">
						<div class="wrapper1">
					    	<div class="div1-compare" style="width: <?php echo $col_width * $number_of_models; ?>px;"></div>
						</div>
						<div class="wrapper2">
							<div class="div2-compare" style="width: <?php echo $col_width * $number_of_models; ?>px;">
								<table cellpadding="0" cellspacing="0" border="0" class="display" id="compare_table" width="<?php echo $col_width * $number_of_models; ?>px">
									<thead>
										<tr class="content-head-row">
											<?php
											$j = 1;
											foreach($tpl['model_arr'] as $model)
											{
												?>
												<th class="<?php echo $j == 1 ? 'first-col' : null;?>" width="<?php echo $col_width;?>px">
													<?php echo pjSanitize::clean($model['name'])?>
												</th>
												<?php
												$j++;
											} 
											?>
										</tr>
									</thead>
									<tbody>
										<?php
										foreach($tpl['category_arr'] as $k => $category)
										{
											?>
											<tr id="content_row_cat_<?php echo $category['id']; ?>" class="category-row">
												<td colspan="<?php echo $number_of_models; ?>" class="first-col" >
													&nbsp;
												</td>
											</tr>
											<?php
											if(isset($category['features']) && !empty($category['features']))
											{
												$feature_arr = $category['features'];
												foreach($feature_arr as $feature)
												{
													?>
													<tr id="content_row_fea_<?php echo $feature['id']; ?>" class="">
														<?php
														$j = 1;
														foreach($tpl['model_arr'] as $model)
														{
															?>
															<td class="<?php echo $j == 1 ? 'first-col' : null;?>" >
																<?php
																foreach ($tpl['lp_arr'] as $v)
																{
																	$value = null;
																	if(isset($tpl['grid_arr'][$feature['id'] . '_' . $model['id']]))
																	{
																		$cell = $tpl['grid_arr'][$feature['id'] . '_' . $model['id']];
																		if(isset($cell['i18n'][$v['id']]['title']) && $cell['i18n'][$v['id']]['title'] != '')
																		{
																			$value = htmlspecialchars(stripslashes($cell['i18n'][$v['id']]['title']));
																		}
																	}	
																	?>
																	<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
																		<span class="inline_block">
																			<input type="text" name="i18n[<?php echo $v['id']; ?>][title][<?php echo $feature['id'] . '_' . $model['id'];?>]" class="pj-form-field float_left r3 w180" value="<?php echo $value;?>"/>
																			<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
																			<span class="pj-multilang-input float_left r10"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
																			<?php endif;?>
																		</span>
																	</p>
																	<?php
																} 
																?>
															</td>
															<?php
															$j++;
														} 
														?>
													</tr>
													<?php
												}
											}
										} 
										?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<?php
				}  
				?>
			</div>
			
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminProducts&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script type="text/javascript">
	var locale_array = new Array(); 
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('pc_field_required'); ?>";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	myLabel.localeId = "<?php echo $controller->getLocaleId(); ?>";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					// Callback, e.g. ajax requests or whatever
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>