var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateProductFeature = $("#frmCreateProductFeature"),
			$frmUpdateProductFeature = $("#frmUpdateProductFeature"),
			chosen = ($.fn.chosen !== undefined),
			$dialogDelete = $("#dialogDeleteImage"),
			dialog = ($.fn.dialog !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			spinner = ($.fn.spinner !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if (chosen) {
			$("#category_id").chosen();
		}
		
		if ($frmCreateProductFeature.length > 0) {
			$frmCreateProductFeature.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				},
				messages: {
			    	required: myLabel.field_required
			    }
			});
		}
		if ($frmUpdateProductFeature.length > 0) {
			$frmUpdateProductFeature.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				},
				messages: {
			    	required: myLabel.field_required
			    }
			});
		}
		
		if ($dialogDelete.length > 0 && dialog) 
		{
			$dialogDelete.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[pcApp.locale.button.yes] = function () {
						$.ajax({
							type: "GET",
							dataType: "json",
							url: $dialogDelete.data('href'),
							success: function (res) {
								if(res.code == 200){
									$('#image_container').remove();
									$dialogDelete.dialog('close');
								}
							}
						});
					};
					buttons[pcApp.locale.button.no] = function () {
						$dialogDelete.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var gridOpts = {
				buttons: [{type: "edit", url: "index.php?controller=pjAdminProductFeatures&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminProductFeatures&action=pjActionDeleteProductFeature&id={:id}"}
				          ],
				columns: [{text: myLabel.title, type: "text", sortable: true, width: 310, editable: true, editableWidth: 290},
				          {text: myLabel.category, type: "text", sortable: true, width: 170, editable: false},
				          {text: myLabel.status, type: "select", sortable: true, width: 100, editable: true, editableWidth: 90,options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminProductFeatures&action=pjActionGetProductFeature" + pjGrid.queryString,
				dataType: "json",
				fields: ['title', 'category', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminProductFeatures&action=pjActionDeleteProductFeatureBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.revert_status, url: "index.php?controller=pjAdminProductFeatures&action=pjActionStatusProductFeature", render: true},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminProductFeatures&action=pjActionExportProductFeature", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				sortable: false,
				
				saveUrl: "index.php?controller=pjAdminProductFeatures&action=pjActionSaveProductFeature&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			};
			if(pjGrid.queryString != "")
			{
				gridOpts.columns = [
				                   {text: myLabel.title, type: "text", sortable: true, width: 230, editable: true, editableWidth: 210},
				                   {text: myLabel.category, type: "text", sortable: true, width: 170, editable: false},
				                   {text: myLabel.order, type: "text", sortable: true, editable: false, width: 80, align: "center", css: {cursor: "move"}},
				                   {text: myLabel.status, type: "select", sortable: true, width: 100, editable: true, editableWidth: 90,options: [
						                                                                                     {label: myLabel.active, value: "T"}, 
						                                                                                     {label: myLabel.inactive, value: "F"}
						                                                                                     ], applyClass: "pj-status"}
				                   ];
				gridOpts.fields = ['title', 'category', 'order', 'status'];
				gridOpts.sortable = true;
				gridOpts.sortableUrl = "index.php?controller=pjAdminProductFeatures&action=pjActionSortFeature";
			}
			
			var $grid = $("#grid").datagrid(gridOpts);
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminProductFeatures&action=pjActionGetProductFeature", "order", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminProductFeatures&action=pjActionGetProductFeature", "order", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminProductFeatures&action=pjActionGetProductFeature", "order", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-delete-image", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogDelete.data('href', $(this).data('href')).dialog("open");
		}).on("change", "#filter_category_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			window.location.href = "index.php?controller=pjAdminProductFeatures&action=pjActionIndex&category_id="+$(this).val();
			return false;
		});
	});
})(jQuery_1_8_2);