DROP TABLE IF EXISTS `stivagallery_galleries`;
CREATE TABLE IF NOT EXISTS `stivagallery_galleries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `layout` int(10) unsigned DEFAULT '1',
  `target` enum('_blank','_self') DEFAULT '_self',
  `width` smallint(5) unsigned DEFAULT '320',
  `height` smallint(5) unsigned DEFAULT '240',
  `preview_width` smallint(5) unsigned DEFAULT '320',
  `preview_height` smallint(5) unsigned DEFAULT '240',
  `thumb_width` smallint(5) unsigned DEFAULT '100',
  `thumb_height` smallint(5) unsigned DEFAULT '75',
  `created` datetime NOT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `layout` (`layout`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_galleries_users`;
CREATE TABLE IF NOT EXISTS `stivagallery_galleries_users` (
  `user_id` int(10) unsigned NOT NULL,
  `gallery_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`, `gallery_id`),
  KEY `user_id` (`user_id`),
  KEY `gallery_id` (`gallery_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_images`;
CREATE TABLE IF NOT EXISTS `stivagallery_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `small_path` varchar(255) DEFAULT NULL,
  `small_size` int(10) unsigned DEFAULT NULL,
  `small_width` smallint(5) unsigned DEFAULT NULL,
  `small_height` smallint(5) unsigned DEFAULT NULL,
  `medium_path` varchar(255) DEFAULT NULL,
  `medium_size` int(10) unsigned DEFAULT NULL,
  `medium_width` smallint(5) unsigned DEFAULT NULL,
  `medium_height` smallint(5) unsigned DEFAULT NULL,
  `large_path` varchar(255) DEFAULT NULL,
  `large_size` int(10) unsigned DEFAULT NULL,
  `large_width` smallint(5) unsigned DEFAULT NULL,
  `large_height` smallint(5) unsigned DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `source_size` int(10) unsigned DEFAULT NULL,
  `source_width` smallint(5) unsigned DEFAULT NULL,
  `source_height` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `alt` varchar(255) DEFAULT NULL,
  `watermark` varchar(255) DEFAULT NULL,
  `sort` int(10) unsigned DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `foreign_id` (`foreign_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_fields`;
CREATE TABLE IF NOT EXISTS `stivagallery_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_multi_lang`;
CREATE TABLE IF NOT EXISTS `stivagallery_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_options`;
CREATE TABLE IF NOT EXISTS `stivagallery_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_roles`;
CREATE TABLE IF NOT EXISTS `stivagallery_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stivagallery_users`;
CREATE TABLE IF NOT EXISTS `stivagallery_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `stivagallery_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(282, 'menuGalleries', 'backend', 'Menu / Galleries', 'script', NULL),
(283, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(284, 'lblInActive', 'backend', 'Label / Inactive', 'script', NULL),
(285, 'lblAddGallery', 'backend', 'Label / Add gallery', 'script', NULL),
(286, 'lblSameGallery', 'backend', 'Label / Same gallery', 'script', NULL),
(287, 'error_titles_ARRAY_AG01', 'arrays', 'error_titles_ARRAY_AG01', 'script', NULL),
(288, 'error_titles_ARRAY_AG03', 'arrays', 'error_titles_ARRAY_AG03', 'script', NULL),
(289, 'error_titles_ARRAY_AG04', 'arrays', 'error_titles_ARRAY_AG04', 'script', NULL),
(290, 'error_titles_ARRAY_AG08', 'arrays', 'error_titles_ARRAY_AG08', 'script', NULL),
(291, 'error_bodies_ARRAY_AG01', 'arrays', 'error_bodies_ARRAY_AG01', 'script', NULL),
(292, 'error_bodies_ARRAY_AG03', 'arrays', 'error_bodies_ARRAY_AG03', 'script', NULL),
(293, 'error_bodies_ARRAY_AG04', 'arrays', 'error_bodies_ARRAY_AG04', 'script', NULL),
(294, 'error_bodies_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
(295, 'infoAddGalleryTitle', 'backend', 'Infobox / Add gallery title', 'script', NULL),
(296, 'infoAddGalleryBody', 'backend', 'Infobox / Add gallery body', 'script', NULL),
(297, 'lblOptions', 'backend', 'Label / Options', 'script', NULL),
(298, 'lblImages', 'backend', 'Label / Images', 'script', NULL),
(299, 'lblInstall', 'backend', 'Label / Install', 'script', NULL),
(300, 'target_ARRAY_blank', 'arrays', 'target_ARRAY_blank', 'script', NULL),
(301, 'target_ARRAY_self', 'arrays', 'target_ARRAY_self', 'script', NULL),
(302, 'lblOpenImageLink', 'backend', 'Label / Open image link', 'script', NULL),
(303, 'layout_ARRAY_1', 'arrays', 'layout_ARRAY_1', 'script', NULL),
(304, 'layout_ARRAY_2', 'arrays', 'layout_ARRAY_2', 'script', NULL),
(305, 'layout_ARRAY_3', 'arrays', 'layout_ARRAY_3', 'script', NULL),
(306, 'layout_ARRAY_4', 'arrays', 'layout_ARRAY_4', 'script', NULL),
(307, 'layout_ARRAY_5', 'arrays', 'layout_ARRAY_5', 'script', NULL),
(308, 'layout_ARRAY_6', 'arrays', 'layout_ARRAY_6', 'script', NULL),
(309, 'lblLayout', 'backend', 'Label / Layout', 'script', NULL),
(310, 'lblWidth', 'backend', 'Label / Width', 'script', NULL),
(311, 'lblWidthTip', 'backend', 'Label / Width tip', 'script', NULL),
(312, 'lblHeightTip', 'backend', 'Label / Height tip', 'script', NULL),
(313, 'lblHeight', 'backend', 'Label / Height', 'script', NULL),
(314, 'lblPreviewWidth', 'backend', 'Label / Preview width', 'script', NULL),
(315, 'lblPreviewHeight', 'backend', 'Label / Preview height', 'script', NULL),
(316, 'lblPreviewWidthTip', 'backend', 'Label / Preview width tip', 'script', NULL),
(317, 'lblPreviewHeightTip', 'backend', 'Label / Preview height tip', 'script', NULL),
(318, 'lblThumbWidth', 'backend', 'Label / Thumb width', 'script', NULL),
(319, 'lblThumbHeight', 'backend', 'Label / Thumb height', 'script', NULL),
(320, 'lblThumbWidthTip', 'backend', 'Label / Thumb width tip', 'script', NULL),
(321, 'lblThumbHeightTip', 'backend', 'Label / Thumb height tip', 'script', NULL),
(322, 'galleryAlt', 'backend', 'Gallery / ALT', 'script', NULL),
(323, 'galleryBtnDelete', 'backend', 'Gallery / Delete', 'script', NULL),
(324, 'galleryBtnCancel', 'backend', 'Gallery / Cancel', 'script', NULL),
(325, 'galleryBtnSave', 'backend', 'Gallery / Save', 'script', NULL),
(326, 'galleryBtnSetWatermark', 'backend', 'Gallery / Set watermark', 'script', NULL),
(327, 'galleryBtnClearCurrent', 'backend', 'Gallery / Clear current one', 'script', NULL),
(328, 'galleryBtnCompress', 'backend', 'Gallery / Compress', 'script', NULL),
(329, 'galleryBtnRecreate', 'backend', 'Gallery / Re-create thumbs', 'script', NULL),
(330, 'galleryCompressionNote', 'backend', 'Gallery / Compression Note', 'script', NULL),
(331, 'galleryCompression', 'backend', 'Gallery / Compression', 'script', NULL),
(332, 'galleryDeleteAll', 'backend', 'Gallery / Delete all', 'script', NULL),
(333, 'galleryDeleteConfirmation', 'backend', 'Gallery / Delete confirmation', 'script', NULL),
(334, 'galleryConfirmationSingle', 'backend', 'Gallery / confirmation single', 'script', NULL),
(335, 'galleryConfirmationMulti', 'backend', 'Gallery / Confirmation Multi', 'script', NULL),
(336, 'galleryEdit', 'backend', 'Gallery / Edit', 'script', NULL),
(337, 'galleryEmptyResult', 'backend', 'Gallery / No images uploaded yet.', 'script', NULL),
(338, 'galleryDelete', 'backend', 'Gallery / Delete', 'script', NULL),
(339, 'galleryImageSettings', 'backend', 'Gallery / Image settings', 'script', NULL),
(340, 'galleryMove', 'backend', 'Gallery / Move', 'script', NULL),
(341, 'galleryOriginals', 'backend', 'Gallery / Originals', 'script', NULL),
(342, 'galleryPhotos', 'backend', 'Gallery / photos', 'script', NULL),
(343, 'galleryPosition', 'backend', 'Galler / Position', 'script', NULL),
(344, 'galleryResize', 'backend', 'Gallery / Resize/Crop', 'script', NULL),
(345, 'galleryRotate', 'backend', 'Gallery / Rotate', 'script', NULL),
(346, 'galleryThumbs', 'backend', 'Gallery / Thumbs', 'script', NULL),
(347, 'galleryUpload', 'backend', 'Gallery / Upload', 'script', NULL),
(348, 'galleryWatermark', 'backend', 'Gallery / Watermark', 'script', NULL),
(349, 'galleryWatermarkPosition', 'backend', 'Gallery / Watermark position', 'script', NULL),
(350, 'galleryTopLeft', 'backend', 'Gallery / Top Left', 'script', NULL),
(351, 'galleryTopRight', 'backend', 'Gallery / Top Right', 'script', NULL),
(352, 'galleryTopCenter', 'backend', 'Gallery / Top Center', 'script', NULL),
(353, 'galleryBottomLeft', 'backend', 'Gallery / Bottom Left', 'script', NULL),
(354, 'galleryBottomRight', 'backend', 'Gallery / Bottom Right', 'script', NULL),
(355, 'galleryBottomCenter', 'backend', 'Gallery / Bottom Center', 'script', NULL),
(356, 'galleryCenterLeft', 'backend', 'Gallery / Center Left', 'script', NULL),
(357, 'galleryCenterRight', 'backend', 'Gallery / Center Right', 'script', NULL),
(358, 'galleryCenterCenter', 'backend', 'Gallery / Center Center', 'script', NULL),
(359, 'gallery_resize_title', 'backend', 'Gallery / Crop image', 'script', NULL),
(360, 'gallery_resize_body', 'backend', 'Gallery / Crop image text', 'script', NULL),
(361, 'gallery_original', 'backend', 'Gallery / Original', 'script', NULL),
(362, 'gallery_thumb', 'backend', 'Gallery / Thumb', 'script', NULL),
(363, 'gallery_preview', 'backend', 'Gallery / Preview', 'script', NULL),
(364, 'gallery_recreate', 'backend', 'Gallery / re-create from original', 'script', NULL),
(365, 'gallery_btn_back', 'backend', 'Gallery / Button Back', 'script', NULL),
(366, 'gallery_btn_save', 'backend', 'Gallery / Save', 'script', NULL),
(367, 'galleryName', 'backend', 'Gallery / Name', 'script', NULL),
(368, 'galleryDescription', 'backend', 'Label / Description', 'script', NULL),
(369, 'galleryUrl', 'backend', 'Gallery / Url', 'script', NULL),
(370, 'lblInstallTitle', 'backend', 'Label / Install title', 'script', NULL),
(410, 'lblPreview', 'backend', 'Label / Preview', 'script', NULL),
(411, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(412, 'lblPhotos', 'backend', 'Label / Photos', 'script', NULL),
(413, 'lblEditors', 'backend', 'Label / Editors', 'script', NULL),
(453, 'lblPhoto', 'backend', 'Label / Photo', 'script', NULL),
(454, 'lblGallery', 'backend', 'Label / Gallery', 'script', NULL),
(455, 'lblGalleries', 'backend', 'Label / Galleries', 'script', NULL),
(456, 'lblUsers', 'backend', 'Label / Users', 'script', NULL),
(457, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(458, 'lblGalleriesMost', 'backend', 'Label / Galleries with most images', 'script', NULL),
(459, 'lblLatestPhotos', 'backend', 'Label / Latest uploaded photos', 'script', NULL),
(460, 'lblLastLoggedUsers', 'backend', 'Label / Last Logged in Users', 'script', NULL),
(461, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(462, 'lblGalleryNotFound', 'backend', 'Label / Gallery not found', 'script', NULL),
(463, 'lblPhotoNotFound', 'backend', 'Label / Photo not found', 'script', NULL),
(464, 'infoImagesTitle', 'backend', 'Infobox / Image list title', 'script', NULL),
(465, 'infoImagesBody', 'backend', 'Infobox / Gallery images body', 'script', NULL),
(466, 'infoOptionsTitle', 'backend', 'Infobox / Gallery options title', 'script', NULL),
(467, 'infoOptionsBody', 'backend', 'Infobox / Gallery options body', 'script', NULL),
(468, 'infoGalleriesTitle', 'backend', 'Infobox / Gallery list title', 'script', NULL),
(469, 'infoGalleriesBody', 'backend', 'Infobox / Gallery list body', 'script', NULL),
(470, 'lblLayoutTip', 'backend', 'Tip / Layout', 'script', NULL),
(471, 'lblOpenImageLinkTip', 'backend', 'Tip / Open image link', 'script', NULL),
(472, 'label_close', 'frontend', 'Label / Close', 'script', NULL),
(473, 'label_no_gallery', 'frontend', 'Label / No gallery', 'script', NULL),
(474, 'layout_ARRAY_7', 'arrays', 'layout_ARRAY_7', 'script', NULL),
(475, 'layout_ARRAY_8', 'arrays', 'layout_ARRAY_8', 'script', NULL),
(476, 'layout_ARRAY_9', 'arrays', 'layout_ARRAY_9', 'script', NULL),
(477, 'layout_ARRAY_10', 'arrays', 'layout_ARRAY_10', 'script', NULL),
(478, 'front_no_uploaded_image', 'frontend', 'Label / No images uploaded for this gallery.', 'script', NULL);

INSERT INTO `stivagallery_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Email address was already in use.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Email address was already in use.', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Galleries', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Galleries', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Galleries', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Add gallery', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Add gallery', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Add gallery', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'The gallery name was already used.', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'The gallery name was already used.', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'The gallery name was already used.', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Gallery updated', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Gallery updated', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Gallery updated', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Gallery added', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Gallery added', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Gallery added', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Gallery failed to add', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'Gallery failed to add', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'Gallery failed to add', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Gallery not found', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'Gallery not found', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'Gallery not found', 'script');
INSERT INTO `stivagallery_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 291, 'pjField', 1, 'title', 'All changes made to the gallery have been saved.', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'All changes made to the gallery have been saved.', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'All changes made to the gallery have been saved.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'A new gallery has been added to the list.', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'A new gallery has been added to the list.', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'A new gallery has been added to the list.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'We are sorry that the gallery could not be added.', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'We are sorry that the gallery could not be added.', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'We are sorry that the gallery could not be added.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'We are sorry that the gallery you are looking for is missing.', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'We are sorry that the gallery you are looking for is missing.', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'We are sorry that the gallery you are looking for is missing.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Add new gallery', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Add new gallery', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Add new gallery', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Please enter gallery name and click Save button, then you can upload images and set more options for the gallery.', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Please enter gallery name and click Save button, then you can upload images and set more options for the gallery.', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Please enter gallery name and click Save button, then you can upload images and set more options for the gallery.', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Images', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'Images', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'Images', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'In new window', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'In new window', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'In new window', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'In current window', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'In current window', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'In current window', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Open image link', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'Open image link', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'Open image link', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Preview and scrolling thumbs', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'Preview and scrolling thumbs', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'Preview and scrolling thumbs', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Preview and thumbs', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'Preview and thumbs', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'Preview and thumbs', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Thumbs grid', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'Thumbs grid', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'Thumbs grid', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Thumbs grid and fancybox', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'Thumbs grid and fancybox', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'Thumbs grid and fancybox', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Slideshow', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'Slideshow', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'Slideshow', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Scrolling thumbs', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Scrolling thumbs', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Scrolling thumbs', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Width', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'Width', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'Width', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Set width for gallery', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'Set width for gallery', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'Set width for gallery', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Set height for gallery', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'Set height for gallery', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'Set height for gallery', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Height', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'Height', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'Height', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Preview width', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'Preview width', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'Preview width', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Preview height', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Preview height', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Preview height', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Set width for preview image', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'Set width for preview image', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'Set width for preview image', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Set height for preview image', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'Set height for preview image', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'Set height for preview image', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Thumb width', 'script'),
(NULL, 318, 'pjField', 2, 'title', 'Thumb width', 'script'),
(NULL, 318, 'pjField', 3, 'title', 'Thumb width', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Thumb height', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'Thumb height', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'Thumb height', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Set width for thumb', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'Set width for thumb', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'Set width for thumb', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Set height for thumb', 'script'),
(NULL, 321, 'pjField', 2, 'title', 'Set height for thumb', 'script'),
(NULL, 321, 'pjField', 3, 'title', 'Set height for thumb', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'ALT', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'ALT', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'ALT', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 323, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 323, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Set watermark', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Set watermark', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Set watermark', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Clear current one', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Clear current one', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Clear current one', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Compress', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Compress', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Compress', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Re-create thumbs', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Re-create thumbs', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'Re-create thumbs', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur id consectetur magna. Nulla facilisi. Sed id dolor ante.', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur id consectetur magna. Nulla facilisi. Sed id dolor ante.', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur id consectetur magna. Nulla facilisi. Sed id dolor ante.', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Compression', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Compression', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Compression', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Delete All', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Delete All', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Delete All', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Are you sure you want to delete selected image?', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Are you sure you want to delete selected image?', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Are you sure you want to delete selected image?', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Are you sure you want to delete all images?', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'Are you sure you want to delete all images?', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'Are you sure you want to delete all images?', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Edit', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Edit', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'No images uploaded yet.', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'No images uploaded yet.', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'No images uploaded yet.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Image settings', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'Image settings', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'Image settings', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Move', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Move', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Move', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Originals', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'Originals', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'Originals', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'images', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'images', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'images', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Position', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Position', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Position', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Resize/Crop', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Resize/Crop', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Resize/Crop', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Rotate', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'Rotate', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'Rotate', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Thumbs', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'Thumbs', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'Thumbs', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'Upload', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'Upload', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Watermark', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Watermark', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Watermark', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Watermark position', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Watermark position', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Watermark position', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Top Left', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'Top Left', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'Top Left', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Top Right', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'Top Right', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'Top Right', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Top Center', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Top Center', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Top Center', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Bottom Left', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'Bottom Left', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'Bottom Left', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Bottom Right', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'Bottom Right', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'Bottom Right', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Bottom Center', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'Bottom Center', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'Bottom Center', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Center Left', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Center Left', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Center Left', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Center Right', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'Center Right', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'Center Right', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Center Center', 'script'),
(NULL, 358, 'pjField', 2, 'title', 'Center Center', 'script'),
(NULL, 358, 'pjField', 3, 'title', 'Center Center', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Crop image', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'Crop image', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'Crop image', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Move the outer parts of the rectangular and/or position it over the image to change framing, aspect ratio or accentuate an object.', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Move the outer parts of the rectangular and/or position it over the image to change framing, aspect ratio or accentuate an object.', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Move the outer parts of the rectangular and/or position it over the image to change framing, aspect ratio or accentuate an object.', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Original', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Original', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Original', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Thumb', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Thumb', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 363, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 363, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 364, 'pjField', 1, 'title', 're-create from original', 'script'),
(NULL, 364, 'pjField', 2, 'title', 're-create from original', 'script'),
(NULL, 364, 'pjField', 3, 'title', 're-create from original', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 365, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 365, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 366, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 366, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Url', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'Url', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'Url', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Copy the HTML code below and put it on your web page where the gallery widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'Copy the HTML code below and put it on your web page where the gallery widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'Copy the HTML code below and put it on your web page where the gallery widget should be loaded. Please, note that you should put the code on a web page from the same domain where script is installed.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 410, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 410, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 411, 'pjField', 2, 'title', 'Thumb', 'script'),
(NULL, 411, 'pjField', 3, 'title', 'Thumb', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 412, 'pjField', 2, 'title', 'Photos', 'script'),
(NULL, 412, 'pjField', 3, 'title', 'Photos', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Editors', 'script'),
(NULL, 413, 'pjField', 2, 'title', 'Editors', 'script'),
(NULL, 413, 'pjField', 3, 'title', 'Editors', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Photo', 'script'),
(NULL, 453, 'pjField', 2, 'title', 'Photo', 'script'),
(NULL, 453, 'pjField', 3, 'title', 'Photo', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Gallery', 'script'),
(NULL, 454, 'pjField', 2, 'title', 'Gallery', 'script'),
(NULL, 454, 'pjField', 3, 'title', 'Gallery', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Galleries', 'script'),
(NULL, 455, 'pjField', 2, 'title', 'Galleries', 'script'),
(NULL, 455, 'pjField', 3, 'title', 'Galleries', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 456, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 456, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 457, 'pjField', 2, 'title', 'User', 'script'),
(NULL, 457, 'pjField', 3, 'title', 'User', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Galleries with most images', 'script'),
(NULL, 458, 'pjField', 2, 'title', 'Galleries with most images', 'script'),
(NULL, 458, 'pjField', 3, 'title', 'Galleries with most images', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Latest uploaded photos', 'script'),
(NULL, 459, 'pjField', 2, 'title', 'Latest uploaded photos', 'script'),
(NULL, 459, 'pjField', 3, 'title', 'Latest uploaded photos', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Last Logged in Users', 'script'),
(NULL, 460, 'pjField', 2, 'title', 'Last Logged in Users', 'script'),
(NULL, 460, 'pjField', 3, 'title', 'Last Logged in Users', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'There is no gallery found.', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'There is no gallery found.', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'There is no gallery found.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'There is no photo found.', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'There is no photo found.', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'There is no photo found.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Gallery images', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'Gallery images', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'Gallery images', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Upload as many images as you want for the gallery. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Upload as many images as you want for the gallery. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Upload as many images as you want for the gallery. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Gallery options', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Gallery options', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Gallery options', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Please make any change as you want on the below form to set the options for the gallery.', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Please make any change as you want on the below form to set the options for the gallery.', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Please make any change as you want on the below form to set the options for the gallery.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Gallery list', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'Gallery list', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'Gallery list', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Below is the list of galleries. You can click on the Edit icon to edit any gallery you want or click on the Eye icon to preview the gallery.', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'Below is the list of galleries. You can click on the Edit icon to edit any gallery you want or click on the Eye icon to preview the gallery.', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'Below is the list of galleries. You can click on the Edit icon to edit any gallery you want or click on the Eye icon to preview the gallery.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'There are 6 available layouts. You can select a desired one to display to your gallery.', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'There are 6 available layouts. You can select a desired one to display to your gallery.', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'There are 6 available layouts. You can select a desired one to display to your gallery.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'If any image of the gallery has url, you can select the way to open that url (on current window or new window). ', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'If any image of the gallery has url, you can select the way to open that url (on current window or new window). ', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'If any image of the gallery has url, you can select the way to open that url (on current window or new window). ', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'Close', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'Close', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'The gallery is not available anymore.', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'The gallery is not available anymore.', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'The gallery is not available anymore.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Vertical slider', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Vertical slider', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Vertical slider', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Image slider', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Image slider', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Image slider', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Image wall', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'Image wall', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'Image wall', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Showcase', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Showcase', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Showcase', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'No images uploaded for this gallery.', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'No images uploaded for this gallery.', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'No images uploaded for this gallery.', 'script');

INSERT INTO `stivagallery_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 0, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `stivagallery_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');