<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminGalleries extends pjAdmin
{
	
	public function pjActionCheckName()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['name']) || empty($_GET['name']))
			{
				echo 'false';
				exit;
			}
			$pjGalleryMainModel = pjGalleryMainModel::factory()->where('t1.name', $_GET['name']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjGalleryMainModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjGalleryMainModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['gallery_create']))
			{
				require PJ_CONFIG_PATH . 'ratio.inc.php';
				
				list($ratio_width, $ratio_height) = explode(":", $recommended_sizes['layout_1']['1']['ratio']);
				$ratio = $ratio_height / $ratio_width;
				
				$preview_width = (int) $recommended_sizes['layout_1']['1']['max_width'];
				$preview_height = ceil($preview_width * $ratio);
				
				$data = array();
				$data['layout'] = 1;
				$data['ratio'] = 1;
				$data['max_width'] = $preview_width;
				$data['preview_width'] = $preview_width;
				$data['preview_height'] = $preview_width;
				$data['custom_width'] = $ratio_width;
				$data['custom_height'] = $ratio_height;
								
				$id = pjGalleryMainModel::factory(array_merge($_POST, $data))->insert()->getInsertId();

				if ($id !== false && (int) $id > 0)
				{
					$err = 'AG03';
				} else {
					$err = 'AG04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminGalleries&action=pjActionUpdate&id=" . $id . "&err=$err");
			} else {
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminGalleries.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetGallery()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjGalleryMainModel = pjGalleryMainModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjGalleryMainModel->orWhere('t1.name LIKE', "%$q%");
			}
			if($this->isEditor()){
				$pjGalleryMainModel->where("(t1.id IN(SELECT TGU.gallery_id FROM `".pjGalleryUserModel::factory()->getTable()."` AS TGU WHERE TGU.user_id = ".$this->getUserId()."))");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjGalleryMainModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjGalleryMainModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjGalleryMainModel->select("t1.id, t1.name, t1.status, 
					(SELECT GROUP_CONCAT(`small_path` SEPARATOR '~:~') FROM `".pjGalleryModel::factory()->getTable()."` WHERE foreign_id = t1.id ORDER BY `sort` ASC LIMIT 8) AS `images`,
					(SELECT COUNT(*) FROM `".pjGalleryModel::factory()->getTable()."` WHERE foreign_id = t1.id) as photos")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->toArray('images', '~:~')
				->getData();
			
			foreach($data as $k => $v)
			{
				$v['image'] = '';
				$image_arr = array();
				if(!empty($v['images']))
				{
					foreach($v['images'] as $image_path)
					{
						if(count($image_arr) < 8)
						{
							$image_arr[] = '<img src="'.PJ_INSTALL_URL . $image_path .'" class="pjPgThumbs"/>';
						}
					}
					$v['image'] = join("", $image_arr);
				}
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminGalleries.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteGallery()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			if (pjGalleryMainModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$pjGalleryModel = pjGalleryModel::factory();
				$image_arr = $pjGalleryModel->where('t1.foreign_id', $_GET['id'])->findAll()->getData();
				foreach($image_arr as $v){
					@unlink($v['small_path']);
					@unlink($v['medium_path']);
					@unlink($v['large_path']);
					@unlink($v['source_path']);
				}
				$pjGalleryModel->reset()->where('foreign_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteGalleryBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjGalleryMainModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				$pjGalleryModel = pjGalleryModel::factory();
				$image_arr = $pjGalleryModel->whereIn('t1.foreign_id', $_POST['record'])->findAll()->getData();
				foreach($image_arr as $v){
					@unlink($v['small_path']);
					@unlink($v['medium_path']);
					@unlink($v['large_path']);
					@unlink($v['source_path']);
				}
				$pjGalleryModel->reset()->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportGallery()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjGalleryMainModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Galleries-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionSetActive()
	{
		$this->setAjax(true);

		if ($this->isXHR())
		{
			$pjGalleryMainModel = pjGalleryMainModel::factory();
			
			$arr = $pjGalleryMainModel->find($_POST['id'])->getData();
			
			if (count($arr) > 0)
			{
				switch ($arr['is_active'])
				{
					case 'T':
						$sql_status = 'F';
						break;
					case 'F':
						$sql_status = 'T';
						break;
					default:
						return;
				}
				$pjGalleryMainModel->reset()->setAttributes(array('id' => $_POST['id']))->modify(array('is_active' => $sql_status));
			}
		}
		exit;
	}
	
	public function pjActionSaveGallery()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['column'] == 'name')
			{
				if($_POST['value'] != '')
				{
					$pjGalleryMainModel = pjGalleryMainModel::factory();
					
					$check = $pjGalleryMainModel->where('t1.name', $_POST['value'])->findCount()->getData() == 0 ? true : false;
					if($check == true)
					{
						$pjGalleryMainModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
					}
				}
			}else{
				pjGalleryMainModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionStatusGallery()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjGalleryMainModel::factory()->whereIn('id', $_POST['record'])->modifyAll(array(
					'status' => ":IF(`status`='F','T','F')"
				));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['gallery_update']))
			{
				$pjGalleryMainModel = pjGalleryMainModel::factory();
				
				$arr = $pjGalleryMainModel->find($_POST['id'])->getData();
				
				$pjGalleryMainModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				$pjGalleryUserModel = pjGalleryUserModel::factory();
				$pjGalleryUserModel->where('gallery_id', $_POST['id'])->eraseAll();
				if(isset($_POST['user_id']))
				{
					$pjGalleryUserModel->reset()->begin();
					foreach ($_POST['user_id'] as $user_id){
						$data = array();
						$data['gallery_id'] = $_POST['id'];
						$data['user_id'] = $user_id;
						$pjGalleryUserModel->reset()->setAttributes($data)->insert();
					}
					$pjGalleryUserModel->commit();
				}
				
				$rebuid = false;
				if($arr['preview_width'] != $_POST['preview_width'] || $arr['preview_height'] != $_POST['preview_height'])
				{
					$rebuid = true;
				}
				
				if($rebuid == true)
				{
					$image_arr = pjGalleryModel::factory()->where('foreign_id', $_POST['id'])->findAll()->getData();
					
					foreach($image_arr as $v){
						ini_set('memory_limit', '256M');
						$Image = new pjImage();
						$Image->loadImage($v['source_path']);
						$resp = $Image->isConvertPossible();
						if ($resp['status'] === true)
						{
							$Image->resizeSmart($_POST['preview_width'], $_POST['preview_height']);
							$Image->saveImage($v['medium_path']);
						}
					}
				}
			 	
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminGalleries&action=pjActionUpdate&id=".$_POST['id']."&err=AG01". "&tab_id=" . $_POST['tab_id']);
				
			} else {
				$arr = pjGalleryMainModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminGalleries&action=pjActionIndex&err=AG08");
				}
				
				$user_gallery_arr = pjGalleryUserModel::factory()->where('gallery_id', $_GET['id'])->findAll()->getData();
				$user_id_arr = array();
				if(!empty($user_gallery_arr)){
					foreach($user_gallery_arr as $v)
					{
						$user_id_arr[] = $v['user_id'];
					}
				}
				
				if($this->isEditor() && !in_array($this->getUserId(), $user_id_arr))
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminGalleries&action=pjActionIndex&err=AG09");
				}
				
				$user_arr = pjUserModel::factory()->where('role_id', 2)->where('status', 'T')->orderBy("name ASC")->findAll()->getData();
				
				$pjGalleryModel = pjGalleryModel::factory();
				$cnt_null_models = $pjGalleryModel->where('t1.foreign_id', $arr['id'])->where('t1.model IS NULL')->findCount()->getData();
				if($cnt_null_models > 0)
				{
					$pjGalleryModel->reset()->where('foreign_id', $arr['id'])->modifyAll(array('model' => 'pjGalleryMain'));
				}
				
				require PJ_CONFIG_PATH . 'ratio.inc.php';
				
				$_SESSION['PJ_GALLERY_MEDIUM']['width'] = $arr['preview_width'];
				$_SESSION['PJ_GALLERY_MEDIUM']['height'] = $arr['preview_height'];
				
				$this->set('arr', $arr);
				$this->set('user_id_arr', $user_id_arr);
				$this->set('user_arr', $user_arr);
				$this->set('recommended_sizes', $recommended_sizes['layout_' . $arr['layout']]);
								
				# Gallery plugin
				$this->appendCss('pj-gallery.css', pjObject::getConstant('pjGallery', 'PLUGIN_CSS_PATH'));
				$this->appendJsFromPlugin('ajaxupload.js', 'ajaxupload', 'pjGallery');
				$this->appendJs('jquery.gallery.js', pjObject::getConstant('pjGallery', 'PLUGIN_JS_PATH'));
				
				$this->appendJs('js/jquery.ui.slider.min.js', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
				$this->appendCss('css/smoothness/jquery.ui.slider.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/');
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminGalleries.js');
				$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdateLayout()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjGalleryMainModel = pjGalleryMainModel::factory();
			
			$pjGalleryMainModel->where('id', $_GET['id'])->limit(1)->modifyAll(array('layout' => $_GET['layout']));

			$this->set('arr', $pjGalleryMainModel->reset()->find($_GET['id'])->getData());
		}
	}
	public function pjActionGetSizes()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			
			require PJ_CONFIG_PATH . 'ratio.inc.php';
			$this->set('recommended_sizes', $recommended_sizes['layout_' . $_GET['layout']]);
		}
	}
}
?>