<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'StivaSoftCaptcha';
	
	public $defaultLocale = 'front_locale_id';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		self::allowCORS();
		ob_start();
	}

	public function afterFilter()
	{		
		
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			$this->loadSetFields();
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionSetLocale()
	{
		$this->setLocaleId(@$_GET['locale']);
		pjUtil::redirect($_SERVER['HTTP_REFERER']);
	}
	
	public function pjActionLoadCss()
	{
		header("Content-type: text/css");
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$arr = pjGalleryMainModel::factory()->find($_GET['id'])->getData();
		$layout = 1;
		if(!empty($arr['layout'])){
			$layout = $arr['layout'];
		}
		if(isset($_GET['layout']) && in_array($_GET['layout'], array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)))
		{
			$layout = $_GET['layout'];
		}
		$arr = array(
			array('file' => 'owl.carousel.min.css', 'path' => $dm->getPath('pj_owlcarousel')),
			array('file' => 'style.css', 'path' => PJ_CSS_PATH),
			array('file' => 'animate.css', 'path' => PJ_CSS_PATH),
			array('file' => 'front_layout_' . $layout . '.css', 'path' => PJ_CSS_PATH),
		);
		foreach ($arr as $item)
		{
			echo str_replace(
					array("pjWrapper"),
					array("pjWrapperGallery_" . $_GET['id']),
					@file_get_contents($item['path'] . $item['file'])) . "\n";			
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		$arr = pjGalleryMainModel::factory()->find($_GET['id'])->getData();
		$image_arr = pjGalleryModel::factory()->where('t1.foreign_id', $_GET['id'])->orderBy('t1.sort ASC')->findAll()->getData();
		$this->set('arr', $arr);
		$this->set('image_arr', $image_arr);
	}
	
	public function pjActionGetImages()
	{
		$this->setAjax(true);
		
		$arr = pjGalleryMainModel::factory()->find($_GET['id'])->getData();
		$this->set('arr', $arr);
		
		$pjGalleryModel = pjGalleryModel::factory();
		
		$pjGalleryModel->where('t1.foreign_id', $_GET['id']);
		
	
		$total = $pjGalleryModel->findCount()->getData();
		$rowCount = 6;
		$pages = ceil($total / $rowCount);
		$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
		$pjGalleryModel->limit($rowCount, $offset);
		
		$image_arr = $pjGalleryModel->orderBy("t1.sort ASC")->findAll()->getData();
		
		$this->set('pages', $pages);
		$this->set('page', $page);
		$this->set('image_arr', $image_arr);
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>