<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat galleries">
				<div class="info">
					<abbr><?php echo $tpl['cnt_galleries'];?></abbr>
					<?php echo (int) $tpl['cnt_galleries'] !== 1 ? strtolower(__('lblGalleries', true)) : strtolower(__('lblGallery', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat photos">
				<div class="info">
					<abbr><?php echo $tpl['cnt_photos'];?></abbr>
					<?php echo (int) $tpl['cnt_photos'] !== 1 ? strtolower(__('lblPhotos', true)) : strtolower(__('lblPhoto', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat users">
				<div class="info">
					<abbr><?php echo $tpl['cnt_users'];?></abbr>
					<?php echo (int) $tpl['cnt_users'] !== 1 ? strtolower(__('lblUsers', true)) : strtolower(__('lblUser', true)); ?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblGalleriesMost');?></div>
			<div class="dashboard_column_top"><?php __('lblLatestPhotos');?></div>
			<div class="dashboard_column_top"><?php __('lblLastLoggedUsers');?></div>
		</div>
		
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['gallery_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblGalleryNotFound'); ?></p><?php
				}else{
					foreach ($tpl['gallery_arr'] as $k => $v)
					{
						$image_url = PJ_INSTALL_URL . PJ_IMG_PATH . 'no_image.png';
						if(!empty($v['image'])){
							$image_url = PJ_INSTALL_URL . $v['image'];
						}
						?>
						<div class="dashboard_gallery_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminGalleries&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><img src="<?php echo $image_url; ?>" /></a>
							<div class="gallery-detail">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminGalleries&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::clean($v['name']);?></a></label>
								<span><?php echo $v['photos'];?>&nbsp;<?php echo (int) $v['photos'] !== 1 ? strtolower(__('lblPhotos', true)) : strtolower(__('lblPhoto', true)); ?></span>
							</div>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['photo_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblPhotoNotFound'); ?></p><?php
				}else{
					foreach ($tpl['photo_arr'] as $k => $v)
					{
						$image_url = PJ_INSTALL_URL . $v['small_path'];
						?>
						<div class="dashboard_photo_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<img src="<?php echo $image_url; ?>" />
							<div class="photo-detail">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminGalleries&amp;action=pjActionUpdate&id=<?php echo $v['foreign_id'];?>"><?php echo pjSanitize::clean($v['gallery_name']);?></a></label>
								<label><?php echo pjSanitize::clean($v['name']);?></label>
								<?php
								if(isset($v['title']) && !empty($v['title']))
								{ 
									?>
									<label><?php echo pjSanitize::clean($v['title']);?></label>
									<?php
								}
								if(isset($v['created']) && !empty($v['created']))
								{ 
									?>
									<span><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($v['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></span>
									<?php
								} 
								?>
							</div>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['user_arr']);
				if ($cnt === 0)
				{
					?><p class="m10"><?php __('lblUserNotFound'); ?></p><?php
				}else{
					foreach ($tpl['user_arr'] as $k => $v)
					{
						?>
						<div class="dashboard_user_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<?php
							if($controller->isAdmin()){
								?><label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo $v['name'];?></a></label><?php
							}else{
								?><label><?php echo $v['name'];?></label><?php
							} 
							?>
							<label><?php echo $v['email'];?></label>
							<label><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($v['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></label>
						</div>
						<?php
					}
				} 
				?>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s'), 'H:i:s', $tpl['option_arr']['o_time_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo $hour; ?></div>
		</div>
	</div>
	<?php
}
?>