<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="b10 fs14"><?php __('lblGallery');?>: <span class="bold"><?php echo pjSanitize::html($tpl['arr']['name']);?></span> <span class="fs12"><?php __('lblCreatedOn')?></span> <span class="bold fs12"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created'])); ?></span></div>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminGalleries&amp;action=pjActionUpdate" method="post" id="frmUpdateGallery" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="gallery_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('lblImages'); ?></a></li>
				<?php
				if($controller->isAdmin())
				{ 
					?>
					<li><a href="#tabs-2"><?php __('lblOptions'); ?></a></li>
					<li><a href="#tabs-3"><?php __('lblInstall'); ?></a></li>
					<?php
				} 
				?>
			</ul>
			<div id="tabs-1">
				<?php
				pjUtil::printNotice(__('infoImagesTitle', true, false), __('infoImagesBody', true, false)); 
				?>
				<div id="gallery"></div>
			</div>
			<?php
			if($controller->isAdmin())
			{ 
				?>
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoOptionsTitle', true, false), __('infoOptionsBody', true, false)); 
				?>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $k == $tpl['arr']['status'] ? 'selected="selected"' : null; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblName', false, true); ?></label>
					<span class="inline_block">
						<input type="text" name="name" id="name" value="<?php echo pjSanitize::html($tpl['arr']['name'], array('remove' => true));?>" class="pj-form-field w350 required" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblEditors'); ?></label>
					<?php
					if(!empty($tpl['user_arr']))
					{ 
						?>
						<span class="inline_block">
							<select id="user_id" name="user_id[]" class="pj-form-field w400" data-placeholder="--<?php __('lblChoose'); ?>--" multiple="multiple">
								<?php
								foreach ($tpl['user_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>" <?php echo in_array($v['id'], $tpl['user_id_arr']) ? 'selected="selected"' : null; ?>><?php echo pjSanitize::html($v['name'], array('remove' => true)); ?></option><?php
								}
								?>
							</select>
						</span>
						<?php
					}else{
						$message = __('lblNoEditorsMessage', true);
						$message = str_replace("{STAG}", '<a href="index.php?controller=pjAdminUsers&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?><span class="inline_block t5"><?php echo $message;?></span><?php
					} 
					?>
				</p>
				<p>
					<label class="title"><?php __('lblLayout', false, true); ?></label>
					<span class="inline_block">
						<select name="layout" id="layout" class="pj-form-field w150 block float_left r10">
							<?php
							$layout = __('layout', true, false);
							ksort($layout);
							foreach ($layout as $k => $v)
							{
								?><option value="<?php echo $k; ?>" <?php echo $k == $tpl['arr']['layout'] ? 'selected="selected"' : null; ?>><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblRecommendedSizes', false, true); ?></label>
					<span id="pjPgRecommendedSizes" class="block overflow float_left t6">
						<?php
						include_once PJ_VIEWS_PATH . 'pjAdminGalleries/pjActionGetSizes.php';
						?>
					</span>
				</p>
				
				<input type="hidden" id="preview_width" name="preview_width" value="<?php echo $tpl['arr']['preview_width']?>"/>
				<input type="hidden" id="preview_height" name="preview_height" value="<?php echo $tpl['arr']['preview_height']?>"/>
				
				<p class="pjPgCustomWrapper" style="display: <?php echo $tpl['arr']['ratio'] == 'advanced' ? 'block' : 'none';?>">
					<label class="title"><?php __('lblCustomRatio', false, true); ?></label>
					<span class="inline_block">
						<span class="block float_left r5">
							<input type="text" name="custom_width" id="custom_width" value="<?php echo pjSanitize::clean($tpl['arr']['custom_width']);?>" class="pj-form-field w50 field-int pjPgDigits pjPgRatioCustom" />
						</span>
						<span class="block float_left r10 t6"><?php echo strtolower(__('lblWidth', true));?></span><span class="block float_left r5 t6">:</span>
						<span class="block float_left r5">
							<input type="text" name="custom_height" id="custom_height" value="<?php echo pjSanitize::clean($tpl['arr']['custom_height']);?>" class="pj-form-field w50 field-int pjPgDigits pjPgRatioCustom" />
						</span>
						<span class="block float_left r10 t6"><?php echo strtolower(__('lblHeight', true));?></span>
					</span>
				</p>
				<p class="pjPgCustomWrapper" style="display: <?php echo $tpl['arr']['ratio'] == 'advanced' ? 'block' : 'none';?>">
					<label class="title"><?php __('lblMaximumImageWidth', false, true); ?></label>
					<span class="inline_block">
						<input type="text" name="max_width" id="max_width" value="<?php echo pjSanitize::clean($tpl['arr']['max_width']);?>" class="pj-form-field field-int pjPgDigits w80 required pjPgRatioCustom" /><label>&nbsp;<?php __('lblPixels');?></label>
					</span>
				</p>
				
				<div class="p pjPgSlider" style="display:<?php echo (int) $tpl['arr']['layout'] == 9 ? 'none' : 'block';?>">
					<label class="title"><?php __('lblSlideshowSpeed', false, true); ?></label>
					<span class="block float_left  t5">
						<span class="block float_left w300 r20" style="margin-top: 1px;">
							<div id="slider"></div>
						</span>
						<span id="slideshow_speed_label"><?php echo number_format((int) $tpl['arr']['slideshow_speed'] / 1000, 1);?></span>&nbsp;<?php __('lblSeconds');?>
					</span>
					<input type="hidden" name="slideshow_speed" id="slideshow_speed" value="<?php echo pjSanitize::clean($tpl['arr']['slideshow_speed']);?>"/>
				</div>
				
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button pjPgBtnSubmit" data-save="<?php __('btnSave', false, true); ?>" data-saving="<?php __('btnSaving');?>"/>
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminGalleries&action=pjActionIndex';" />
					<input type="button" id="pjPgPreviewButton" value="<?php __('btnPreviewGallery', false, true); ?>" class="pj-button" onclick="window.open('preview.php?id=<?php echo $tpl['arr']['id']; ?>&layout=<?php echo $tpl['arr']['layout']; ?>', '_blank');" />
					<span id="pjPgPreviewHint" style="display: none;"><?php __('lblPreviewHint');?></span>
				</p>
			</div>
			<div id="tabs-3">
				<?php pjUtil::printNotice(NULL, __('lblInstallTitle', true), false, false); ?>
			
			<textarea id="install_step_1" class="pj-form-field w700 textarea_install" style="overflow: auto; height:120px">&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionLoadCss&amp;id=<?php echo $tpl['arr']['id']?>" type="text/css" rel="stylesheet" /&gt;
&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionLoad&amp;id=<?php echo $tpl['arr']['id']?>"&gt;&lt;/script&gt;</textarea>
			</div>
			
			<?php
			} 
			?>
		</div> <!-- #tabs -->
	</form>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var myLabel = myLabel || {};
	myLabel.same_gallery = "<?php __('lblSameGallery', false, true); ?>";
	myLabel.seconds = "<?php __('lblSeconds', false, true); ?>";
	myLabel.slider_value = <?php echo $tpl['arr']['slideshow_speed']; ?>;
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>