(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
					
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) {
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $slides = $slider.find('.pjGalSlides');
				var allAnimationCombinations = [[false, false], ['zoomOut', 'zoomIn'], ['zoomOutLeft', false], ['zoomOutLeft', 'zoomInRight'], ['zoomOutRight', false], ['zoomOutRight', 'zoomInLeft'], ['zoomOutDown', false], ['zoomOutDown', 'zoomInUp'], ['slideOutUp', 'slideInUp'], ['slideOutDown', 'slideInDown'], ['slideOutRight', 'slideInLeft'], ['slideOutLeft', 'slideInRight'], ['hinge', false], ['rotateOut', 'rotateIn'], ['lightSpeedOut', 'lightSpeedIn'], ['flipOutX', false], ['flipOutY', false], ['fadeOut', 'fadeIn'], ['fadeOutUp', false], ['fadeOutRight', false], ['fadeOutDown', false], ['fadeOutLeft', false], ['bounceOut', false], ['fadeOut', 'wobble'], ['fadeOut', 'swing'], ['fadeOut', 'rubberBand']];
				var animationSpeed = 1500;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;
				function setAnimation() {
					var newAnimationNumber = Math.floor(Math.random() * allAnimationCombinations.length);
					return allAnimationCombinations[newAnimationNumber];
				};
				var animationCombination = setAnimation();

				$slides.owlCarousel({
					items: 1,
					margin: 0,
					loop: true,
					nav: false,
					dots: false,
					autoHeight: true,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					animateOut: animationCombination[0],
					animateIn: animationCombination[1],
					onChange: function() {
						$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;

						animationCombination = setAnimation();
						
						$slides.data('owl.carousel').options.animateOut = animationCombination[0];
						$slides.data('owl.carousel').settings.animateOut = animationCombination[0];
						$slides.data('owl.carousel').options.animateIn = animationCombination[1];
						$slides.data('owl.carousel').settings.animateIn = animationCombination[1];
					}
				});
			};
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);