(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document;
	var $win = pjQ.$(window);
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			
			return this;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) {
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $slides = $slider.find('.pjGalSlides');
				var $sliderClip = $slider.find('.pjGalSliderClip');
				var $sliderFilters = $slider.find('.pjGalSliderNav');
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;

				$slides.owlCarousel({
					margin: 10,
					items: 5,
					loop: true,
					dots: false,
					nav: true,
					autoHeight: false,
					autoplay: true,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					onChange: function() {
						$slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});
			};
		}
	};
	var fnDoVisibleItemsCount = function(itemsWrapper, itemWidth) {
		var $itemsWrapperWidth = itemsWrapper.width();
		var visibleItemsNumber = parseInt(parseInt($itemsWrapperWidth) / parseInt(itemWidth));
		
		if (visibleItemsNumber <= 1) {
			return 1;
		} else {
			return visibleItemsNumber;
		};
	};
	// expose
	window.StivaGallery = StivaGallery;
})(window);