(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document;
	var $win = pjQ.$(window);
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			
			return this;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			var container_str = 'pjWrapperGallery_' + self.opts.gid;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) 
			{
				var $sliderPrimary = pjQ.$('#'+container_str+' .pjGalSliderPrimary');
				var $sliderPrimarySlides = $sliderPrimary.find('.pjGalSlides');
				var $sliderPrimaryControls = $sliderPrimary.find('.pjGalSliderControls');
				var $sliderSecondary = pjQ.$('#'+container_str+' .pjGalSliderSecondary');
				var $sliderSecondarySlides = $sliderSecondary.find('.pjGalSlides');
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;

				$sliderPrimarySlides.owlCarousel({
					items: 1,
					margin: 0,
					loop: true,
					dots: false,
					nav: false,
					autoHeight: true,
					autoplay: true,
					mouseDrag: false,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: animationSpeed,
					autoplayHoverPause: true,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					dragEndSpeed: animationSpeed,
					onChange: function() {
						$sliderPrimarySlides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$sliderPrimarySlides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});

				$sliderSecondarySlides.owlCarousel({
					items: 2,
					startPosition: 1,
					margin: 0,
					loop: true,
					dots: false,
					nav: false,
					autoHeight: true,
					autoplay: false,
					mouseDrag: false,
					autoplayTimeout: self.opts.slide_speed,
					autoplaySpeed: 1000,
					autoplayHoverPause: false,
					navSpeed: animationSpeed,
					dotsSpeed: animationSpeed,
					dragEndSpeed: animationSpeed,
					onChange: function() {
						$sliderSecondarySlides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
						$sliderSecondarySlides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
					}
				});

				$sliderPrimarySlides.on('change.owl.carousel', function(e) {
					var prevItemIndex = e.relatedTarget.relative(e.relatedTarget.normalize(e.relatedTarget.current(), false));
					var nextItemIndex = e.relatedTarget.relative(e.relatedTarget.normalize(e.property.value, false));
					if ((prevItemIndex > nextItemIndex) && (prevItemIndex !== 0) && (nextItemIndex !== 0)) {
						$sliderSecondarySlides.trigger('prev.owl.carousel', [animationSpeed]);
					} else if ((prevItemIndex < nextItemIndex) && (prevItemIndex !== 0) && (nextItemIndex !== 0)) {
						$sliderSecondarySlides.trigger('next.owl.carousel', [animationSpeed]);
					} else if ((prevItemIndex === 0) && (nextItemIndex === e.item.count - 1)) {
						$sliderSecondarySlides.trigger('prev.owl.carousel', [animationSpeed]);
					} else if ((nextItemIndex === 0) && (prevItemIndex === e.item.count - 1)) {
						$sliderSecondarySlides.trigger('next.owl.carousel', [animationSpeed]);
					} else if ((nextItemIndex === 0) && (prevItemIndex === 1)) {
						$sliderSecondarySlides.trigger('prev.owl.carousel', [animationSpeed]);
					} else if ((prevItemIndex === 0) && (nextItemIndex === 1)) {
						$sliderSecondarySlides.trigger('next.owl.carousel', [animationSpeed]);
					};
				});

				$sliderPrimaryControls.on('click', '.pjGalBtn', function(e) {
					var $currentBtn = pjQ.$(this);

					if ($currentBtn.hasClass('pjGalBtnNext')) {
						$sliderPrimarySlides.trigger('next.owl.carousel', [animationSpeed]);
					} else if ($currentBtn.hasClass('pjGalBtnNextPlusOne')) {
						$sliderPrimarySlides.trigger('next.owl.carousel', [animationSpeed]);
						$sliderPrimarySlides.trigger('next.owl.carousel', [animationSpeed]);
					};

					e.preventDefault();
				});
			};
		}
		
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);