(function (window, undefined){
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document;
	var $win = pjQ.$(window);
	var gallery_id = null;
	
	function StivaGallery(opts) {
		if (!(this instanceof StivaGallery)) {
			return new StivaGallery(opts);
		}
		this.reset.call(this);
		this.init.call(this, opts);
		return this;
	}
	function LoadResize() {
		
    }
	StivaGallery.prototype = {
		reset: function () {
			this.opts = null;
			this.$container = null;
			this.container = null;
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			
			gallery_id = self.opts.gid;
			var container_str = 'pjWrapperGallery_' + gallery_id;
			
			if (pjQ.$('#'+container_str+' .pjGalSlider').length) {
				var $slider = pjQ.$('#'+container_str+' .pjGalSlider');
				var $sliderControls = $slider.find('.pjGalSliderControls');
				var $initialSlider = $slider.find('.pjGalSlides');
				var $initialSliderHTML = $initialSlider.parent().html();
				var $sliderClip = $slider.find('.pjGalSliderClip');
				var $sliderClipInner = $slider.find('.pjGalSliderClipInner');
				var $possibleItems = parseInt($sliderClip.height()/140);
				var $mainImageImg = $slider.find('.pjGalSliderMainImage img');
				var $mainTitle = $slider.find('.pjGalSliderMainTitle');
				var $mainParagraph = $slider.find('.pjGalSliderMainParagraph');
				var $sliderInMotion;
				var directionOutUpClass = 'slideOutUp';
				var directionInUpClass = 'slideInUp';
				var directionOutDownClass = 'slideOutDown';
				var directionInDownClass = 'slideInDown';
				var animationSpeed = 3000;
				var animationTimeOut = animationSpeed + self.opts.slide_speed;
				var fnDoCarousel = function(slides) {
					slides.each(function() {
						var currentIndex = pjQ.$(this).index();
						pjQ.$(this).owlCarousel({
							items: 1,
							startPosition: currentIndex,
							margin: 0,
							loop: true,
							dots: false,
							nav: false,
							autoHeight: false,
							autoplay: false,
							mouseDrag: false,
							touchDrag: false,
							pullDrag: false,
							freeDrag: false,
							autoplayTimeout: self.opts.slide_speed,
							autoplaySpeed: animationSpeed,
							autoplayHoverPause: false,
							navSpeed: animationSpeed,
							dotsSpeed: animationSpeed,
							animateOut: directionOutDownClass,
							animateIn: directionInDownClass,
							onTranslate: function(e) {
								$sliderInMotion = true;
							},
							onTranslated: function(e) {
								$sliderInMotion = false;
							},
							onChange: function() {
								slides.data('owl.carousel').options.autoplayTimeout = animationTimeOut;
								slides.data('owl.carousel').settings.autoplayTimeout = animationTimeOut;
							}
						});
					});
				};
				var fnDoThumbClick = function(slide) {
					slide.on('click', 'a', function(e) {
						var $currentThumb = pjQ.$(this);
						var $currentImageLargeSrc = $currentThumb.attr('data-imageLg');
						var $currentImageTitle = $currentThumb.attr('data-title');
						var $currentImageContent = $currentThumb.attr('data-paragraph');

						$mainImageImg.attr('src', $currentImageLargeSrc);
						$mainTitle.text($currentImageTitle);
						$mainParagraph.text($currentImageContent);

						e.preventDefault();
					});
				};
				
				for (var i = 1; i < $possibleItems; i++) {
					$sliderClipInner.append($initialSlider.clone());
				};

				var $allSlides = $slider.find('.pjGalSlides');
				fnDoCarousel($allSlides);

				$win.on('resize', function() {
					var $currentPossibleItems = parseInt($sliderClip.height()/140);
					
					if ($possibleItems >= $currentPossibleItems) {
						var $currentAllSlides = $slider.find('.pjGalSlides');
						var $itemToRemove = $currentAllSlides.eq($possibleItems - (parseInt($possibleItems - $currentPossibleItems)));

						$itemToRemove.remove();
					} else if ($possibleItems < $currentPossibleItems) {
						$sliderClipInner.empty().append($initialSliderHTML);
						var $currentInitialSlider = $slider.find('.pjGalSlides');

						for (var i = 1; i < $currentPossibleItems; i++) {
							$sliderClipInner.append($currentInitialSlider.clone());
						};

						var $currentAllSlides = $slider.find('.pjGalSlides');
						fnDoCarousel($currentAllSlides);

					};
					$possibleItems = $currentPossibleItems;

					fnDoThumbClick($slider.find('.pjGalSlide'));
				});

				$sliderControls.on('click', '.pjGalBtn', function(e) {
					var $currentBtn = pjQ.$(this);
					var $currentSlides = $currentBtn.parents('.pjGalSlider').find('.pjGalSlides');

					if ($sliderInMotion === true) {
						return false;
					} else {
						if ($currentBtn.hasClass('pjGalBtnPrev')) {
							$currentSlides.each(function() {
								pjQ.$(this).data('owl.carousel').options.animateOut = directionOutUpClass;
								pjQ.$(this).data('owl.carousel').settings.animateOut = directionOutUpClass;
								pjQ.$(this).data('owl.carousel').options.animateIn = directionInUpClass;
								pjQ.$(this).data('owl.carousel').settings.animateIn = directionInUpClass;
							});
							
							$currentSlides.trigger('next.owl.carousel', [animationSpeed]);
						} else if ($currentBtn.hasClass('pjGalBtnNext')) {
							$currentSlides.each(function() {
								pjQ.$(this).data('owl.carousel').options.animateOut = directionOutDownClass;
								pjQ.$(this).data('owl.carousel').settings.animateOut = directionOutDownClass;
								pjQ.$(this).data('owl.carousel').options.animateIn = directionInDownClass;
								pjQ.$(this).data('owl.carousel').settings.animateIn = directionInDownClass;
							});

							$currentSlides.trigger('prev.owl.carousel', [animationSpeed]);
						};
					};

					e.preventDefault();
				});

				fnDoThumbClick($slider.find('.pjGalSlide'));
			};
		}
	};
	
	// expose
	window.StivaGallery = StivaGallery;
})(window);