DROP TABLE IF EXISTS `ticketsupport_departments`;
CREATE TABLE IF NOT EXISTS `ticketsupport_departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_fields`;
CREATE TABLE IF NOT EXISTS `ticketsupport_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_multi_lang`;
CREATE TABLE IF NOT EXISTS `ticketsupport_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_options`;
CREATE TABLE IF NOT EXISTS `ticketsupport_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_payments`;
CREATE TABLE IF NOT EXISTS `ticketsupport_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_roles`;
CREATE TABLE IF NOT EXISTS `ticketsupport_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_users`;
CREATE TABLE IF NOT EXISTS `ticketsupport_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_users_departments`;
CREATE TABLE IF NOT EXISTS `ticketsupport_users_departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `department_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`, `department_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_clients`;
CREATE TABLE IF NOT EXISTS `ticketsupport_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `client_since` date DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `cell_phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_tickets`;
CREATE TABLE IF NOT EXISTS `ticketsupport_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` varchar(50) NOT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `message` text DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('New','RepliedByClient','RepliedBySupport','InProgress','Closed') NOT NULL DEFAULT 'New',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_categories`;
CREATE TABLE IF NOT EXISTS `ticketsupport_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_messages`;
CREATE TABLE IF NOT EXISTS `ticketsupport_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_messages_categories`;
CREATE TABLE IF NOT EXISTS `ticketsupport_messages_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `message_id` (`message_id`,`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_replies`;
CREATE TABLE IF NOT EXISTS `ticketsupport_replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT NULL,
  `reply_text` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_files`;
CREATE TABLE IF NOT EXISTS `ticketsupport_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT NULL,
  `reply_id` int(11) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `type` enum('ticket','reply') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_notifications`;
CREATE TABLE IF NOT EXISTS `ticketsupport_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `recipient_client` enum('T','F') DEFAULT NULL,
  `type` enum('NewClient','NewTicket','NewClientReply','NewSupportReply') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_notifications_departments`;
CREATE TABLE IF NOT EXISTS `ticketsupport_notifications_departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `notification_id` (`notification_id`,`department_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ticketsupport_notifications_users`;
CREATE TABLE IF NOT EXISTS `ticketsupport_notifications_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `notification_id` (`notification_id`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `ticketsupport_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(2, 'menuTickets', 'backend', 'Menu Tickets', 'script', NULL),
(3, 'menuClients', 'backend', 'Menu Clients', 'script', NULL),
(4, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(5, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(6, 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
(7, 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
(8, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(9, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(10, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(11, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(12, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(13, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(14, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(15, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(16, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(17, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(18, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(19, 'error_titles_ARRAY_ACL01', 'arrays', 'error_titles_ARRAY_ACL01', 'script', NULL),
(20, 'error_titles_ARRAY_ACL03', 'arrays', 'error_titles_ARRAY_ACL03', 'script', NULL),
(21, 'error_titles_ARRAY_ACL04', 'arrays', 'error_titles_ARRAY_ACL04', 'script', NULL),
(22, 'error_titles_ARRAY_ACL08', 'arrays', 'error_titles_ARRAY_ACL08', 'script', NULL),
(23, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(24, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(25, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(26, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(27, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(28, 'error_titles_ARRAY_AD03', 'arrays', 'error_titles_ARRAY_AD03', 'script', NULL),
(29, 'error_titles_ARRAY_AD04', 'arrays', 'error_titles_ARRAY_AD04', 'script', NULL),
(30, 'error_titles_ARRAY_AD08', 'arrays', 'error_titles_ARRAY_AD08', 'script', NULL),
(31, 'error_titles_ARRAY_ALC01', 'arrays', 'error_titles_ARRAY_ALC01', 'script', NULL),
(32, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(33, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(34, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(35, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(36, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(37, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(38, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(39, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(40, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(41, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(42, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(43, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(44, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(45, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(46, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(47, 'error_bodies_ARRAY_ACL01', 'arrays', 'error_bodies_ARRAY_ACL01', 'script', NULL),
(48, 'error_bodies_ARRAY_ACL03', 'arrays', 'error_bodies_ARRAY_ACL03', 'script', NULL),
(49, 'error_bodies_ARRAY_ACL04', 'arrays', 'error_bodies_ARRAY_ACL04', 'script', NULL),
(50, 'error_bodies_ARRAY_ACL08', 'arrays', 'error_bodies_ARRAY_ACL08', 'script', NULL),
(51, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(52, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(53, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(54, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(55, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(56, 'error_bodies_ARRAY_AD03', 'arrays', 'error_bodies_ARRAY_AD03', 'script', NULL),
(57, 'error_bodies_ARRAY_AD04', 'arrays', 'error_bodies_ARRAY_AD04', 'script', NULL),
(58, 'error_bodies_ARRAY_AD08', 'arrays', 'error_bodies_ARRAY_AD08', 'script', NULL),
(59, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(60, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(61, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(62, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(63, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(64, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(65, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(66, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(67, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(68, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(69, 'lblDashLastLogin', 'backend', 'Dashboard / Last login', 'script', NULL),
(70, 'lblDashMostPopular', 'backend', 'Dashboard / Most Popular', 'script', NULL),
(71, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(72, 'lblAddClient', 'backend', 'Add client', 'script', NULL),
(73, 'lblName', 'backend', 'Name', 'script', NULL),
(74, 'lblClientWebsite', 'backend', 'Client Website', 'script', NULL),
(75, 'lblClientSince', 'backend', 'Client Since', 'script', NULL),
(76, 'lblClientCountry', 'backend', 'Client Country', 'script', NULL),
(77, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(78, 'lblClientState', 'backend', 'Client State', 'script', NULL),
(79, 'lblClientCity', 'backend', 'Client City', 'script', NULL),
(80, 'lblClientAddress', 'backend', 'Client Address', 'script', NULL),
(81, 'lblClientPhone', 'backend', 'Client Phone', 'script', NULL),
(82, 'lblClientMobile', 'backend', 'Client Mobile', 'script', NULL),
(83, 'lblClientFax', 'backend', 'Client Fax', 'script', NULL),
(84, 'lblClientNotes', 'backend', 'Client Notes', 'script', NULL),
(85, 'lblStatus', 'backend', 'Status', 'script', NULL),
(86, 'lblExport', 'backend', 'Export', 'script', NULL),
(87, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(88, 'lblActive', 'backend', 'Active', 'script', NULL),
(89, 'lblInactive', 'backend', 'Inactive', 'script', NULL),
(90, 'lblDeleteSelected', 'backend', 'Delete Selected', 'script', NULL),
(91, 'lblDeleteConfirmation', 'backend', 'Delete Confirmation', 'script', NULL),
(92, 'lblUpdateClient', 'backend', 'Update Client', 'script', NULL),
(93, 'lblCountry', 'backend', 'Country', 'script', NULL),
(94, 'lblDepartment', 'backend', 'Department', 'script', NULL),
(95, 'lblValue', 'backend', 'Value', 'script', NULL),
(96, 'lblOption', 'backend', 'Option', 'script', NULL),
(97, 'opt_o_post_ticket', 'backend', 'Options / Post Ticket', 'script', NULL),
(98, 'opt_o_select_departments', 'backend', 'Options / Select Departments', 'script', NULL),
(99, 'opt_o_upload_files', 'backend', 'Options / Upload files', 'script', NULL),
(100, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(101, 'opt_o_week_start', 'backend', 'Options / Week start', 'script', NULL),
(102, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(103, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(104, 'lblRole', 'backend', 'Role', 'script', NULL),
(105, 'lblEmail', 'backend', 'Email', 'script', NULL),
(106, 'lblPass', 'backend', 'Password', 'script', NULL),
(107, 'lblDepartments', 'backend', 'Departments', 'script', NULL),
(108, 'lblRevertStatus', 'backend', 'Revert status', 'script', NULL),
(109, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(110, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(111, 'lblIp', 'backend', 'IP address', 'script', NULL),
(112, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(113, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(114, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(115, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(116, 'gridPrevPage', 'backend', 'Prev page', 'script', NULL),
(117, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(118, 'gridNextPage', 'backend', 'Next Page', 'script', NULL),
(119, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(120, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(121, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(122, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(123, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(124, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(125, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(126, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(127, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(128, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(129, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(130, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(131, 'btnLogin', 'backend', 'Button Login', 'script', NULL),
(132, 'btnSave', 'backend', 'Button Save', 'script', NULL),
(133, 'btnSearch', 'backend', 'Button Search', 'script', NULL),
(134, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(135, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(136, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(137, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(138, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(139, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(140, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(141, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(142, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(143, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(144, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(145, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(146, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(147, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(148, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(149, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(150, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(151, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(152, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(153, 'ts_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(155, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(156, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(157, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(158, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(159, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(160, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(161, 'locales', 'backend', 'Languages', 'script', NULL),
(162, 'backend', 'backend', 'Backend titles', 'script', NULL),
(163, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(164, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(167, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(168, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(169, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(170, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(171, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(172, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(173, 'addLocale', 'backend', 'Add language', 'script', NULL),
(174, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(175, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(176, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(177, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(178, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(179, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(180, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(181, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(182, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(183, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(184, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(185, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(186, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(187, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(188, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(189, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(190, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(191, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(192, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(193, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(194, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(195, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(196, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(197, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(198, 'menuCountries', 'backend', 'Menu  Countries', 'script', NULL),
(199, 'menuLocales', 'backend', 'Menu Locales', 'script', NULL),
(200, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(205, 'error_titles_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(206, 'error_titles_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(207, 'error_titles_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(208, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(209, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(210, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(211, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(212, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(213, 'lblAddTiket', 'backend', 'Add ticket', 'script', NULL),
(214, 'lblTicketID', 'backend', 'Ticket ID', 'script', NULL),
(215, 'lblClient', 'backend', 'Client', 'script', NULL),
(216, 'lblAssignedTo', 'backend', 'Assigned to', 'script', NULL),
(217, 'client_types_ARRAY_new', 'arrays', 'client_types_ARRAY_new', 'script', NULL),
(218, 'client_types_ARRAY_existing', 'arrays', 'client_types_ARRAY_existing', 'script', NULL),
(219, 'ticket_statarr_ARRAY_New', 'arrays', 'ticket_statarr_ARRAY_New', 'script', NULL),
(220, 'ticket_statarr_ARRAY_RepliedByClient', 'arrays', 'ticket_statarr_ARRAY_RepliedByClient', 'script', NULL),
(221, 'ticket_statarr_ARRAY_RepliedBySupport', 'arrays', 'ticket_statarr_ARRAY_RepliedBySupport', 'script', NULL),
(222, 'ticket_statarr_ARRAY_InProgress', 'arrays', 'ticket_statarr_ARRAY_InProgress', 'script', NULL),
(223, 'ticket_statarr_ARRAY_Closed', 'arrays', 'ticket_statarr_ARRAY_Closed', 'script', NULL),
(224, 'lblTicketMessage', 'backend', 'Ticket Message', 'script', NULL),
(225, 'lblTicketNotes', 'backend', 'Ticket Notes', 'script', NULL),
(226, 'lblAddTicket', 'backend', 'Add ticket', 'script', NULL),
(227, 'lblUpdateTicket', 'backend', 'Update ticket', 'script', NULL),
(228, 'menuCannedMessages', 'backend', 'Menu Canned Messages', 'script', NULL),
(229, 'categories', 'backend', 'SubMenu Categories', 'script', NULL),
(230, 'messages', 'backend', 'SubMenu Messages', 'script', NULL),
(231, 'lblCategory', 'backend', 'Category', 'script', NULL),
(232, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(233, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(234, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(235, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(236, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(237, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(238, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(239, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(240, 'lblMessage', 'backend', 'Message', 'script', NULL),
(241, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(242, 'error_titles_ARRAY_AM03', 'arrays', 'error_titles_ARRAY_AM03', 'script', NULL),
(243, 'error_titles_ARRAY_AM04', 'arrays', 'error_titles_ARRAY_AM04', 'script', NULL),
(244, 'error_titles_ARRAY_AM08', 'arrays', 'error_titles_ARRAY_AM08', 'script', NULL),
(245, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(246, 'error_bodies_ARRAY_AM03', 'arrays', 'error_bodies_ARRAY_AM03', 'script', NULL),
(247, 'error_bodies_ARRAY_AM04', 'arrays', 'error_bodies_ARRAY_AM04', 'script', NULL),
(248, 'error_bodies_ARRAY_AM08', 'arrays', 'error_bodies_ARRAY_AM08', 'script', NULL),
(249, 'lblDateTime', 'backend', 'Date / Time', 'script', NULL),
(251, 'lblAllReplies', 'backend', 'All Replies', 'script', NULL),
(252, 'lblReplyToTicket', 'backend', 'Reply To Ticket', 'script', NULL),
(253, 'btnReply', 'backend', 'Button Reply', 'script', NULL),
(254, 'lblReplyMessage', 'backend', 'Reply Message', 'script', NULL),
(255, 'lblReplyFiles', 'backend', 'File(s)', 'script', NULL),
(256, 'error_titles_ARRAY_AT09', 'arrays', 'error_bodies_ARRAY_AT09', 'script', NULL),
(257, 'error_titles_ARRAY_AT10', 'arrays', 'error_titles_ARRAY_AT10', 'script', NULL),
(258, 'error_bodies_ARRAY_AT09', 'arrays', 'error_bodies_ARRAY_AT09', 'script', NULL),
(259, 'error_bodies_ARRAY_AT10', 'arrays', 'error_bodies_ARRAY_AT10', 'script', NULL),
(260, 'lblPostedOn', 'backend', 'Reply Posted On', 'script', NULL),
(261, 'lblPostedBy', 'backend', 'Reply Posted By', 'script', NULL),
(262, 'lblSubject', 'backend', 'Options / Subject', 'script', NULL),
(263, 'lblType', 'backend', 'Options / Type', 'script', NULL),
(264, 'lblPromptSelecting', 'backend', 'Prompt Selecting', 'script', NULL),
(265, 'menuNotifications', 'backend', 'Menu Notifications', 'script', NULL),
(266, 'notification_types_ARRAY_NewTicket', 'arrays', 'notification_types_ARRAY_NewTicket', 'script', NULL),
(267, 'notification_types_ARRAY_NewClientReply', 'arrays', 'notification_types_ARRAY_NewClientReply', 'script', NULL),
(268, 'notification_types_ARRAY_NewSupportReply', 'arrays', 'notification_types_ARRAY_NewSupportReply', 'script', NULL),
(269, 'error_titles_ARRAY_AN01', 'arrays', 'error_titles_ARRAY_AN01', 'script', NULL),
(270, 'error_titles_ARRAY_AN03', 'arrays', 'error_titles_ARRAY_AN03', 'script', NULL),
(271, 'error_titles_ARRAY_AN04', 'arrays', 'error_titles_ARRAY_AN04', 'script', NULL),
(272, 'error_titles_ARRAY_AN08', 'arrays', 'error_titles_ARRAY_AN08', 'script', NULL),
(273, 'error_bodies_ARRAY_AN01', 'arrays', 'error_bodies_ARRAY_AN01', 'script', NULL),
(274, 'error_bodies_ARRAY_AN03', 'arrays', 'error_bodies_ARRAY_AN03', 'script', NULL),
(275, 'error_bodies_ARRAY_AN04', 'arrays', 'error_bodies_ARRAY_AN04', 'script', NULL),
(276, 'error_bodies_ARRAY_AN08', 'arrays', 'error_bodies_ARRAY_AN08', 'script', NULL),
(278, 'lblRecipientDepartments', 'backend', 'Recipient departments', 'script', NULL),
(279, 'lblRecipientUsers', 'backend', 'Recipient Users', 'script', NULL),
(280, 'lblRecipientClients', 'backend', 'Recipient Clients', 'script', NULL),
(281, 'lblAvailableTokens', 'backend', 'Available Tokens', 'script', NULL),
(282, 'lblEditReply', 'backend', 'Edit reply', 'script', NULL),
(283, 'btnEdit', 'backend', 'Button Edit', 'script', NULL),
(284, 'lnkDelete', 'backend', 'Link Delete', 'script', NULL),
(285, 'lnkEdit', 'backend', 'Link Edit', 'script', NULL),
(286, 'lblDeleteReply', 'backend', 'Delete Reply', 'script', NULL),
(287, 'lblDeleteReplyConfirmation', 'backend', 'Delete Reply Confirmation', 'script', NULL),
(288, 'lblInstallContact', 'backend', 'Install Contact', 'script', NULL),
(289, 'lblInstallLogin', 'backend', 'Install Login', 'script', NULL),
(290, 'lblInstallPhp1Title', 'backend', 'Install (PHP) Title', 'script', NULL),
(291, 'lblInstallPhp2Title', 'backend', 'Install (PHP) Login', 'script', NULL),
(292, 'lblInstallPhp1_1', 'backend', 'Install Contact (Step 1)', 'script', NULL),
(293, 'lblInstallPhp1_2', 'backend', 'Install Contact (Step 2)', 'script', NULL),
(294, 'lblInstallPhp1_3', 'backend', 'Install Contact (Step 3)', 'script', NULL),
(295, 'lblInstallPhp2_1', 'backend', 'Install Login (Step 1)', 'script', NULL),
(296, 'lblInstallPhp2_2', 'backend', 'Install Login (Step 2)', 'script', NULL),
(297, 'lblInstallPhp2_3', 'backend', 'Install Login (Step 3)', 'script', NULL),
(298, 'front_login_title', 'frontend', 'Front Login Title', 'script', NULL),
(299, 'front_login_email', 'frontend', 'Front Login Email', 'script', NULL),
(300, 'front_login_password', 'frontend', 'Front Login Password', 'script', NULL),
(301, 'front_login_submit', 'frontend', 'Front Login Submit', 'script', NULL),
(302, 'front_login_forgot', 'frontend', 'Front Login Forgot Password', 'script', NULL),
(303, 'front_sys_ARRAY_log_email', 'arrays', 'front_sys_ARRAY_log_email', 'script', NULL),
(304, 'front_sys_ARRAY_log_email_inv', 'arrays', 'front_sys_ARRAY_log_email_inv', 'script', NULL),
(305, 'front_sys_ARRAY_log_pass', 'arrays', 'front_sys_ARRAY_log_pass', 'script', NULL),
(306, 'front_sys_ARRAY_log_note', 'arrays', 'front_sys_ARRAY_log_note', 'script', NULL),
(307, 'front_sys_ARRAY_log_err1', 'arrays', 'front_sys_ARRAY_log_err1', 'script', NULL),
(308, 'front_sys_ARRAY_log_err2', 'arrays', 'front_sys_ARRAY_log_err2', 'script', NULL),
(309, 'front_ticket_list_title', 'frontend', 'Frontend You Ticket List', 'script', NULL),
(310, 'front_no_ticket_found', 'frontend', 'No ticket found.', 'script', NULL),
(311, 'front_label_ticketid', 'frontend', 'Ticket ID', 'script', NULL),
(312, 'front_label_status', 'frontend', 'Frontend Status', 'script', NULL),
(313, 'front_label_last_reply', 'frontend', 'Frontend Last reply', 'script', NULL),
(314, 'front_label_back', 'frontend', 'Label Back', 'script', NULL),
(315, 'front_post_reply_ARRAY_FR01', 'arrays', 'front_post_reply_ARRAY_FR01', 'script', NULL),
(316, 'front_post_reply_ARRAY_FR02', 'arrays', 'front_post_reply_ARRAY_FR02', 'script', NULL),
(317, 'front_post_reply_ARRAY_required', 'arrays', 'front_post_reply_ARRAY_required', 'script', NULL),
(318, 'front_contact_title', 'frontend', 'Frontend Contact Form', 'script', NULL),
(319, 'front_contact_name', 'frontend', 'Frontend Contact Name', 'script', NULL),
(320, 'front_contact_email', 'frontend', 'Frontend Contact Email', 'script', NULL),
(321, 'front_contact_department', 'frontend', 'Frontend Contact Department', 'script', NULL),
(322, 'front_contact_message', 'frontend', 'Frontend Contact Message', 'script', NULL),
(324, 'front_sys_ARRAY_contact_name', 'arrays', 'front_sys_ARRAY_contact_name', 'script', NULL),
(325, 'front_sys_ARRAY_contact_email', 'arrays', 'front_sys_ARRAY_contact_email', 'script', NULL),
(326, 'front_sys_ARRAY_contact_email_inv', 'arrays', 'front_sys_ARRAY_contact_email_inv', 'script', NULL),
(327, 'front_sys_ARRAY_contact_message', 'arrays', 'front_sys_ARRAY_contact_message', 'script', NULL),
(328, 'front_contact_ARRAY_FC01', 'arrays', 'front_contact_ARRAY_FC01', 'script', NULL),
(329, 'front_contact_ARRAY_FC02', 'arrays', 'front_contact_ARRAY_FC02', 'script', NULL),
(334, 'front_sys_ARRAY_forgot_err1', 'arrays', 'front_sys_ARRAY_forgot_err1', 'script', NULL),
(335, 'front_sys_ARRAY_forgot_err2', 'arrays', 'front_sys_ARRAY_forgot_err2', 'script', NULL),
(336, 'front_forgot_title', 'frontend', 'Frontend Forgot Password', 'script', NULL),
(337, 'front_forgot_ARRAY_FF01', 'arrays', 'front_forgot_ARRAY_FF01', 'script', NULL),
(338, 'front_forgot_ARRAY_FF02', 'arrays', 'front_forgot_ARRAY_FF02', 'script', NULL),
(339, 'front_forgot_ARRAY_FF03', 'arrays', 'front_forgot_ARRAY_FF03', 'script', NULL),
(340, 'front_add_ticket', 'frontend', 'Frontend Add New Ticket', 'script', NULL),
(341, 'front_tickets_ARRAY_FA01', 'arrays', 'front_tickets_ARRAY_FA01', 'script', NULL),
(342, 'front_tickets_ARRAY_FA02', 'arrays', 'front_tickets_ARRAY_FA02', 'script', NULL),
(343, 'front_sys_ARRAY_add_department', 'arrays', 'front_sys_ARRAY_add_department', 'script', NULL),
(344, 'front_sys_ARRAY_add_message', 'arrays', 'front_sys_ARRAY_add_message', 'script', NULL),
(345, 'lblDashNewTickets', 'backend', 'Label Dashboard New Tickets', 'script', NULL),
(346, 'lblDashNewTicket', 'backend', 'Label Dashboard New Ticket', 'script', NULL),
(347, 'lblDashSupportReplies', 'backend', 'Label Dashboard Support Replies', 'script', NULL),
(348, 'lblDashSupportReply', 'backend', 'Label Dashboard Support Reply', 'script', NULL),
(349, 'lblTicketReceivedToday', 'backend', 'Label Ticket Received Today', 'script', NULL),
(350, 'lblRepliesSentToday', 'backend', 'Label Replies Sent Today', 'script', NULL),
(351, 'lblTicketNotFound', 'backend', 'Label Ticket Not Found', 'script', NULL),
(352, 'lblReplyNotFound', 'backend', 'Label Reply Not Found', 'script', NULL),
(353, 'lblReceived', 'backend', 'Label Received', 'script', NULL),
(354, 'lblReplies', 'backend', 'Label Replies Flural', 'script', NULL),
(355, 'lblReply', 'backend', 'Label Replies Singular', 'script', NULL),
(356, 'lblRepliesByHour', 'backend', 'Label Replies By Hour', 'script', NULL),
(357, 'lblCustomerReplies', 'backend', 'Label Customer Replies', 'script', NULL),
(358, 'lblSupportReplies', 'backend', 'Label Support Replies', 'script', NULL),
(359, 'front_menu_logout', 'frontend', 'front_menu_logout', 'script', NULL),
(360, 'front_menu_profile', 'frontend', 'front_menu_profile', 'script', NULL),
(361, 'front_menu_new_ticket', 'frontend', 'front_menu_new_ticket', 'script', NULL),
(362, 'front_menu_tickets', 'frontend', 'front_menu_tickets', 'script', NULL),
(363, 'front_password_reminder_title', 'frontend', 'front_password_reminder_title', 'script', NULL),
(364, 'front_profile_ARRAY_FP01', 'arrays', 'front_profile_ARRAY_FP01', 'script', NULL),
(365, 'front_profile_ARRAY_FP02', 'arrays', 'front_profile_ARRAY_FP02', 'script', NULL),
(366, 'front_profile_ARRAY_FP03', 'arrays', 'front_profile_ARRAY_FP03', 'script', NULL),
(367, 'front_label_tickets', 'frontend', 'front_label_tickets', 'script', NULL),
(368, 'front_label_password', 'frontend', 'front_label_password', 'script', NULL),
(369, 'front_label_website', 'frontend', 'front_label_website', 'script', NULL),
(370, 'front_label_country', 'frontend', 'front_label_country', 'script', NULL),
(371, 'front_label_state', 'frontend', 'front_label_state', 'script', NULL),
(372, 'front_label_city', 'frontend', 'front_label_city', 'script', NULL),
(373, 'front_label_address', 'frontend', 'front_label_address', 'script', NULL),
(374, 'front_label_phone', 'frontend', 'front_label_phone', 'script', NULL),
(375, 'front_label_cell_phone', 'frontend', 'front_label_cell_phone', 'script', NULL),
(376, 'front_label_fax', 'frontend', 'front_label_fax', 'script', NULL),
(377, 'front_label_notes', 'frontend', 'front_label_notes', 'script', NULL),
(378, 'front_menu_login', 'frontend', 'front_menu_login', 'script', NULL),
(379, 'front_sys_ARRAY_data_inv', 'arrays', 'front_sys_ARRAY_data_inv', 'script', NULL),
(404, 'lblNotifyDepartmentTip', 'backend', 'Notifiy Recipient departments tooltip', 'script', NULL),
(405, 'lblNotifyUserTip', 'backend', 'Notifiy Recipient users tooltip', 'script', NULL),
(406, 'lblNotifyClientTip', 'backend', 'Notifiy Recipient clients tooltip', 'script', NULL),
(407, 'lblNotifyTypeTip', 'backend', 'Notifiy Type tooltip', 'script', NULL),
(408, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(409, 'lblLastReply', 'backend', 'Label Last reply', 'script', NULL),
(410, 'lblClientName', 'backend', 'Client name', 'script', NULL),
(411, 'lblClientEmail', 'backend', 'Client email', 'script', NULL),
(412, 'lblReceivedAfter', 'backend', 'Received after', 'script', NULL),
(413, 'lblReceivedBefore', 'backend', 'Received before', 'script', NULL),
(414, 'front_button_save', 'frontend', 'front_button_save', 'script', NULL),
(415, 'menuProfile', 'frontend', 'Menu / Profile', 'script', NULL),
(416, 'front_sys_ARRAY_max_size', 'arrays', 'front_sys_ARRAY_max_size', 'script', NULL),
(462, 'front_verification', 'frontend', 'Front / Verification code', 'script', NULL),
(463, 'front_sys_ARRAY_contact_verification', 'arrays', 'front_sys_ARRAY_contact_verification', 'script', NULL),
(464, 'front_sys_ARRAY_contact_verification_inv', 'arrays', 'front_sys_ARRAY_contact_verification_inv', 'script', NULL),
(465, 'front_sys_ARRAY_add_verification', 'arrays', 'front_sys_ARRAY_add_verification', 'script', NULL),
(466, 'front_sys_ARRAY_add_verification_inv', 'arrays', 'front_sys_ARRAY_add_verification_inv', 'script', NULL),
(467, 'opt_o_send_email', 'backend', 'Options / Send email', 'script', NULL),
(468, 'opt_o_smtp_host', 'backend', 'Options / SMTP Host', 'script', NULL),
(469, 'opt_o_smtp_pass', 'backend', 'Options / SMTP Password', 'script', NULL),
(470, 'opt_o_smtp_port', 'backend', 'Options / SMTP Port ', 'script', NULL),
(471, 'opt_o_smtp_user', 'backend', 'Options / SMTP Username', 'script', NULL),
(472, 'notification_types_ARRAY_NewClient', 'arrays', 'notification_types_ARRAY_NewClient', 'script', NULL),
(473, 'ts_field_required', 'backend', 'Validations / Field required', 'script', NULL),
(474, 'ts_email_invalid', 'arrays', 'Validations / Email invalid', 'script', NULL),
(475, 'daynames_ARRAY_1', 'arrays', 'daynames_ARRAY_1', 'script', NULL),
(476, 'daynames_ARRAY_2', 'arrays', 'daynames_ARRAY_2', 'script', NULL),
(477, 'daynames_ARRAY_3', 'arrays', 'daynames_ARRAY_3', 'script', NULL),
(478, 'daynames_ARRAY_4', 'arrays', 'daynames_ARRAY_4', 'script', NULL),
(479, 'daynames_ARRAY_5', 'arrays', 'daynames_ARRAY_5', 'script', NULL),
(480, 'daynames_ARRAY_6', 'arrays', 'daynames_ARRAY_6', 'script', NULL),
(481, 'daynames_ARRAY_7', 'arrays', 'daynames_ARRAY_7', 'script', NULL),
(482, 'front_sys_ARRAY_contact_file_ext', 'arrays', 'front_sys_ARRAY_contact_file_ext', 'script', NULL),
(483, 'front_sys_ARRAY_add_file_ext', 'arrays', 'front_sys_ARRAY_add_file_ext', 'script', NULL),
(484, 'ts_file_ext', 'arrays', 'Label / File extention', 'script', NULL),
(485, 'front_post_reply_ARRAY_FR03', 'arrays', 'front_post_reply_ARRAY_FR03', 'script', NULL),
(486, 'front_contact_ARRAY_FC03', 'arrays', 'front_contact_ARRAY_FC03', 'script', NULL),
(564, 'infoNotificationsTitle', 'backend', 'Infobox / Notifications', 'script', NULL),
(565, 'infoNotificationsDesc', 'backend', 'Infobox / Notifications description', 'script', NULL),
(566, 'infoAddNotificationTitle', 'backend', 'Infobox / Create notification title', 'script', NULL),
(567, 'infoAddNotificationDesc', 'backend', 'Infobox / Create notification desc', 'script', NULL),
(568, 'infoUpdateNotificationTitle', 'backend', 'Infobox / Update notification title', 'script', NULL),
(569, 'infoUpdateNotificationDesc', 'backend', 'Infobox / Update notification desc', 'script', NULL),
(647, 'infoAddTicketTitle', 'backend', 'Infobox / New ticket title', 'script', NULL),
(648, 'infoAddTicketDesc', 'backend', 'Infobox / New ticket description', 'script', NULL),
(649, 'infoEditTicketTitle', 'backend', 'Infobox / View ticket title', 'script', NULL),
(650, 'infoEditTicketDesc', 'backend', 'Infobox / View ticket description', 'script', NULL),
(651, 'infoClientsTitle', 'backend', 'Infobox / All Clients title', 'script', NULL),
(652, 'infoClientsDesc', 'backend', 'Infobox / All Clients description', 'script', NULL),
(653, 'infoUsersTitle', 'backend', 'Infobox / All Users title', 'script', NULL),
(654, 'infoUsersDesc', 'backend', 'Infobox / All Users description', 'script', NULL),
(655, 'infoAddUserTitle', 'backend', 'Infobox / Add user title', 'script', NULL),
(656, 'infoAddUserDesc', 'backend', 'Infobox / Add user description', 'script', NULL),
(657, 'infoDepartmentsTitle', 'backend', 'Infobox / Departments title', 'script', NULL),
(658, 'infoDepartmentsDesc', 'backend', 'Infobox / Departments description', 'script', NULL),
(659, 'infoMessagesTitle', 'backend', 'Infobox / Canned messages title', 'script', NULL),
(660, 'infoMessagesDesc', 'backend', 'Infobox / Canned messages description', 'script', NULL),
(661, 'opt_o_sender_email', 'backend', 'Options / Email address', 'script', NULL),
(662, 'front_login_remember_me', 'frontend', 'Label / Remember me', 'script', NULL);

INSERT INTO `ticketsupport_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Clients', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Clients', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 6, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Client updated!', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Client updated!', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Client added!', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Client added!', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Client failed to add.', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Client failed to add.', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Client failed to add.', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Client not found.', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Client not found.', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Client not found.', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Country updated!', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Country updated!', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Country updated!', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Country added!', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Country added!', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Country added!', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Country failed to add.', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'Country failed to add.', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'Country failed to add.', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Country not found.', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Country not found.', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Country not found.', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Department updated!', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Department updated!', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Department updated!', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Department added!', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Department added!', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Department added!', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Department failed to add.', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'Department failed to add.', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'Department failed to add.', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Department not found.', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Department not found.', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Department not found.', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Titles updated!', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Titles updated!', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Titles updated!', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Submissions updated!', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Submissions updated!', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Submissions updated!', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Install updated!', 'script'),
(NULL, 34, 'pjField', 2, 'title', 'Install updated!', 'script'),
(NULL, 34, 'pjField', 3, 'title', 'Install updated!', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'All the changes made to this country have been saved.', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'We are sorry, but the country has not been added.', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'We are sorry, but the country has not been added.', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'We are sorry, but the country has not been added.', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Country your looking for is missing.', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Country your looking for is missing.', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Country your looking for is missing.', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'All the changes made to this department have been saved.', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'We are sorry, but the department has not been added.', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'We are sorry, but the department has not been added.', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'We are sorry, but the department has not been added.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Department your looking for is missing.', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Department your looking for is missing.', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Department your looking for is missing.', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'All the changes made to submissions have been saved.', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'All the changes made to install have been saved.', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'All the changes made to install have been saved.', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'All the changes made to install have been saved.', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'last login', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'last login', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'last login', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Most Popular', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Most Popular', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Most Popular', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Add client', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Add client', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Client since', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Client since', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Client since', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Cell phone', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Cell phone', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Cell phone', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Is active', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Is active', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Is active', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Update client', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Update client', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Department', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Department', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Department', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Post ticket', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'Post ticket', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'Post ticket', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Select departments', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'Select departments', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'Select departments', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Upload files', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'Upload files', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'Upload files', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Week start', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Week start', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Week start', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 104, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 104, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 105, 'pjField', 2, 'title', 'E-mail', 'script'),
(NULL, 105, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 106, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 106, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Departments', 'script'),
(NULL, 107, 'pjField', 2, 'title', 'Departments', 'script'),
(NULL, 107, 'pjField', 3, 'title', 'Departments', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 108, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 108, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 109, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 109, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 110, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 110, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 111, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 111, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 112, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 112, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 113, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 113, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 114, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 114, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 115, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 115, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 116, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 116, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 117, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 117, 'pjField', 2, 'title', '&laquo; Prev', 'script'),
(NULL, 117, 'pjField', 3, 'title', '&laquo; Prev', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 118, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 118, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 119, 'pjField', 2, 'title', 'Next &raquo;', 'script'),
(NULL, 119, 'pjField', 3, 'title', 'Next &raquo;', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 120, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 120, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 121, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 121, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 122, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 122, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 123, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 123, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 124, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 124, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and input the correct text.', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Admin login', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'Admin login', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'Admin login', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Empty result set.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Empty result set.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Empty result set.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Your registration was successful.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Your registration was successful.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Your registration was successful.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Your registration was successful. Your account needs to be approved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'Your registration was successful. Your account needs to be approved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'Your registration was successful. Your account needs to be approved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'E-Mail address already exist.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'E-Mail address already exist.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'E-Mail address already exist.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Email address is already in use.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'Email address is already in use.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'Email address is already in use.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 157, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 157, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 158, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 158, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 172, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 172, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 173, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 173, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Countries', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Countries', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Locales', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Locales', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Locales', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Ticket updated!', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Ticket updated!', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Ticket updated!', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Ticket added!', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'Ticket added!', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'Ticket added!', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Ticket failed to add.', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Ticket failed to add.', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Ticket failed to add.', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Ticket not found.', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Ticket not found.', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Ticket not found.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'All the changes made to this ticket have been saved.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'We are sorry, but the ticket has not been added.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'We are sorry, but the ticket has not been added.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'We are sorry, but the ticket has not been added.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Ticket your looking for is missing.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Ticket your looking for is missing.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Ticket your looking for is missing.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Add ticket', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Add ticket', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Add ticket', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Ticket ID', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Ticket ID', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Ticket ID', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'Client', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'Client', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Assigned to', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'Assigned to', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'Assigned to', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'New', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'New', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Existing', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'Existing', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'Existing', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'New', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'New', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Replied by client', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'Replied by client', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'Replied by client', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Replied by support', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Replied by support', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Replied by support', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'In Progress', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'In Progress', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'In Progress', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Closed', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'Closed', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'Closed', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Add ticket', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'Add ticket', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'Add ticket', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Update ticket', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'Update ticket', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'Update ticket', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Canned messages', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'Canned messages', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'Canned messages', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Messages', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'Messages', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'Messages', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Category update!', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'Category update!', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'Category update!', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'Category added!', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'Category added!', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Category failed to add.', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'Category failed to add.', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'Category failed to add.', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Category not found.', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'Category not found.', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'Category not found.', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Message updated!', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'Message updated!', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'Message updated!', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Message added!', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'Message added!', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'Message added!', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Message failed to add.', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'Message failed to add.', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'Message failed to add.', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Message not found.', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'Message not found.', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'Message not found.', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'All the changes made to this message have been saved.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'We are sorry, but the message has not been added.', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'We are sorry, but the message has not been added.', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'We are sorry, but the message has not been added.', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Message your looking for is missing.', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'Message your looking for is missing.', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'Message your looking for is missing.', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Date / Time', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Date / Time', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Date / Time', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'All replies', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'All replies', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'All replies', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Reply to ticket', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Reply to ticket', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Reply to ticket', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Reply', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Reply', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Reply', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Reply message', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Reply message', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Reply message', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'File(s)', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'Bestanden', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'Archivos', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Reply posted!', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Reply posted!', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Reply posted!', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Reply failed to post.', 'script'),
(NULL, 257, 'pjField', 2, 'title', 'Reply failed to post.', 'script'),
(NULL, 257, 'pjField', 3, 'title', 'Reply failed to post.', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'The reply has been saved successfully.', 'script'),
(NULL, 258, 'pjField', 2, 'title', 'The reply has been saved successfully.', 'script'),
(NULL, 258, 'pjField', 3, 'title', 'The reply has been saved successfully.', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Sorry! The reply has been not saved successfully.', 'script'),
(NULL, 259, 'pjField', 2, 'title', 'Sorry! The reply has been not saved successfully.', 'script'),
(NULL, 259, 'pjField', 3, 'title', 'Sorry! The reply has been not saved successfully.', 'script');
INSERT INTO `ticketsupport_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 260, 'pjField', 1, 'title', 'Posted on', 'script'),
(NULL, 260, 'pjField', 2, 'title', 'Posted on', 'script'),
(NULL, 260, 'pjField', 3, 'title', 'Posted on', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'by', 'script'),
(NULL, 261, 'pjField', 2, 'title', 'by', 'script'),
(NULL, 261, 'pjField', 3, 'title', 'by', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 262, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 262, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 263, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 263, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Please select a category.', 'script'),
(NULL, 264, 'pjField', 2, 'title', 'Please select a category.', 'script'),
(NULL, 264, 'pjField', 3, 'title', 'Please select a category.', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 265, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 265, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'New ticket', 'script'),
(NULL, 266, 'pjField', 2, 'title', 'New ticket', 'script'),
(NULL, 266, 'pjField', 3, 'title', 'New ticket', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'New client reply', 'script'),
(NULL, 267, 'pjField', 2, 'title', 'New client reply', 'script'),
(NULL, 267, 'pjField', 3, 'title', 'New client reply', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'New support reply', 'script'),
(NULL, 268, 'pjField', 2, 'title', 'New support reply', 'script'),
(NULL, 268, 'pjField', 3, 'title', 'New support reply', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Notification update!', 'script'),
(NULL, 269, 'pjField', 2, 'title', 'Notification update!', 'script'),
(NULL, 269, 'pjField', 3, 'title', 'Notification update!', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Notification added!', 'script'),
(NULL, 270, 'pjField', 2, 'title', 'Notification added!', 'script'),
(NULL, 270, 'pjField', 3, 'title', 'Notification added!', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Notification failed to add.', 'script'),
(NULL, 271, 'pjField', 2, 'title', 'Notification failed to add.', 'script'),
(NULL, 271, 'pjField', 3, 'title', 'Notification failed to add.', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Notification not found.', 'script'),
(NULL, 272, 'pjField', 2, 'title', 'Notification not found.', 'script'),
(NULL, 272, 'pjField', 3, 'title', 'Notification not found.', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 273, 'pjField', 2, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 273, 'pjField', 3, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 274, 'pjField', 2, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 274, 'pjField', 3, 'title', 'All the changes made to the notification have been saved.', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'We are sorry, but the notification has not been added.', 'script'),
(NULL, 275, 'pjField', 2, 'title', 'We are sorry, but the notification has not been added.', 'script'),
(NULL, 275, 'pjField', 3, 'title', 'We are sorry, but the notification has not been added.', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Notification your looking for is missing.', 'script'),
(NULL, 276, 'pjField', 2, 'title', 'Notification your looking for is missing.', 'script'),
(NULL, 276, 'pjField', 3, 'title', 'Notification your looking for is missing.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Recipient departments', 'script'),
(NULL, 278, 'pjField', 2, 'title', 'Recipient departments', 'script'),
(NULL, 278, 'pjField', 3, 'title', 'Recipient departments', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Recipient users', 'script'),
(NULL, 279, 'pjField', 2, 'title', 'Recipient users', 'script'),
(NULL, 279, 'pjField', 3, 'title', 'Recipient users', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Recipient clients', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'Recipient clients', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'Recipient clients', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Some available tokens:<br/>{TicketID}<br/>{ClientName}<br/>{ClientEmail}<br/>{ClientPassword}<br/>{Date/TimeTicket}<br/>{Date/TimeReply}', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'Some available tokens:<br/>{TicketID}<br/>{ClientName}<br/>{ClientEmail}<br/>{ClientPassword}<br/>{Date/TimeTicket}<br/>{Date/TimeReply}', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'Some available tokens:<br/>{TicketID}<br/>{ClientName}<br/>{ClientEmail}<br/>{ClientPassword}<br/>{Date/TimeTicket}<br/>{Date/TimeReply}', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Edit reply', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Edit reply', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Edit reply', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'Edit', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'Edit', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'Edit', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'Edit', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Delete reply', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'Delete reply', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'Delete reply', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Are you sure you want to delete this reply?', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Are you sure you want to delete this reply?', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Are you sure you want to delete this reply?', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Contact form', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Contact form', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Login form', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'Login form', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'Login form', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Follow the steps below to install ticket support script on your web page.', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'Contact form PHP include code.', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'Contact form PHP include code.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Login form PHP include code. <i>Note</i> that you need to set the path to tickets listing page.', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'Login form PHP include code. <i>Note</i> that you need to set the path to tickets listing page.', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'Login form PHP include code. <i>Note</i> that you need to set the path to tickets listing page.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 292, 'pjField', 2, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the ticket support system will be displayed.', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'Step 2. Copy and paste following code inside your html code, where the contact form will be displayed.', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'Step 2. Copy and paste following code inside your html code, where the contact form will be displayed.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Step 1. Copy and paste following code at very top of your page, before any other code.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Step 2. Copy and paste following code inside your html code, where the login form will be displayed.', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Step 2. Copy and paste following code inside your html code, where the login form will be displayed.', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Step 2. Copy and paste following code inside your html code, where the login form will be displayed.', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Step 3. Copy and paste following code at very bottom of your page, after all the code.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Login your account', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'Login uw account', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'Ingresar a su cuenta', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'E-mail', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'inloggen', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 302, 'pjField', 2, 'title', 'Wachtwoord vergeten', 'script'),
(NULL, 302, 'pjField', 3, 'title', 'Olvid', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Email is required', 'script'),
(NULL, 303, 'pjField', 2, 'title', 'Email is required', 'script'),
(NULL, 303, 'pjField', 3, 'title', 'Email is required', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Email is invalid', 'script'),
(NULL, 304, 'pjField', 2, 'title', 'Email is invalid', 'script'),
(NULL, 304, 'pjField', 3, 'title', 'Email is invalid', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Password is required', 'script'),
(NULL, 305, 'pjField', 2, 'title', 'Password is required', 'script'),
(NULL, 305, 'pjField', 3, 'title', 'Password is required', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Please note that:', 'script'),
(NULL, 306, 'pjField', 2, 'title', 'Please note that:', 'script'),
(NULL, 306, 'pjField', 3, 'title', 'Please note that:', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 307, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 307, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Account disabled.', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Account disabled.', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Account disabled.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Your ticket list', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'Your ticket list', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'Your ticket list', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'No ticket found.', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'No ticket found.', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'No ticket found.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Ticket ID', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'Ticket ID', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'Ticket ID', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Last reply', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'Last reply', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'Last reply', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Your reply has been saved successfully.', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Your reply has been saved successfully.', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Your reply has been saved successfully.', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Your reply has not been saved successfully.', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'Your reply has not been saved successfully.', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'Your reply has not been saved successfully.', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Reply message is required.', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'Reply message is required.', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'Reply message is required.', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Contact form', 'script'),
(NULL, 318, 'pjField', 2, 'title', 'Contact form', 'script'),
(NULL, 318, 'pjField', 3, 'title', 'Contact form', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'Naam', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'Nombre', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'E-mail', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Department', 'script'),
(NULL, 321, 'pjField', 2, 'title', 'Department', 'script'),
(NULL, 321, 'pjField', 3, 'title', 'Department', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'Bericht', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'Mensaje', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'Name is required.', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'Name is required.', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Email is required.', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Email is required.', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Message is required.', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Message is required.', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Message is required.', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Your support ticket was sent successfully.', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Your support ticket was sent successfully.', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Your support ticket was sent successfully.', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'The contact information has been not saved successfully.', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'The contact information has been not saved successfully.', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'The contact information has been not saved successfully.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'The email was not found.', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'The email was not found.', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'The email was not found.', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Your account was disabled.', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'Your account was disabled.', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'Your account was disabled.', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Email was not found.', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'Email was not found.', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'Email was not found.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Account was disabled.', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Account was disabled.', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Account was disabled.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'The password was sent to your email.', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'The password was sent to your email.', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'The password was sent to your email.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Send a ticket', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Stuur een kaartje', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Enviar un ticket', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'The ticket has been added successfully.', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'The ticket has been added successfully.', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'The ticket has been added successfully.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'The ticket has not been added.', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'The ticket has not been added.', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'The ticket has not been added.', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Department is required.', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'Department is required.', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'Department is required.', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Message is required.', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Message is required.', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Message is required.', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'new tickets', 'script'),
(NULL, 345, 'pjField', 2, 'title', 'new tickets', 'script'),
(NULL, 345, 'pjField', 3, 'title', 'new tickets', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'new ticket', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'new ticket', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'new ticket', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'support replies', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'support replies', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'support replies', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'support reply', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'support reply', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'support reply', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Tickets Received Today', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Tickets Received Today', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Tickets Received Today', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Replies Sent Today', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'Replies Sent Today', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'Replies Sent Today', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'No ticket found', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'No ticket found', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'No ticket found', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'No reply found', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'No reply found', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'No reply found', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'received', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'received', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'received', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'replies', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'replies', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'replies', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'reply', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'reply', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'reply', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Replies by Hour', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Replies by Hour', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Replies by Hour', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Customer replies', 'script'),
(NULL, 357, 'pjField', 2, 'title', 'Customer replies', 'script'),
(NULL, 357, 'pjField', 3, 'title', 'Customer replies', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Support replies', 'script'),
(NULL, 358, 'pjField', 2, 'title', 'Support replies', 'script'),
(NULL, 358, 'pjField', 3, 'title', 'Support replies', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 359, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 359, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'New ticket', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Nieuw ticket', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Nuevo ticket', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 362, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 362, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 363, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 363, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Your profile has been updated.', 'script'),
(NULL, 364, 'pjField', 2, 'title', 'Your profile has been updated.', 'script'),
(NULL, 364, 'pjField', 3, 'title', 'Your profile has been updated.', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Your profile has been not updated.', 'script'),
(NULL, 365, 'pjField', 2, 'title', 'Your profile has been not updated.', 'script'),
(NULL, 365, 'pjField', 3, 'title', 'Your profile has been not updated.', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Your profile was not found.', 'script'),
(NULL, 366, 'pjField', 2, 'title', 'Your profile was not found.', 'script'),
(NULL, 366, 'pjField', 3, 'title', 'Your profile was not found.', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 367, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 367, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 368, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 368, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 369, 'pjField', 2, 'title', 'Website', 'script'),
(NULL, 369, 'pjField', 3, 'title', 'Website', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 370, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 370, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 371, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 371, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 372, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 372, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 373, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 373, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 374, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 374, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Cell phone', 'script'),
(NULL, 375, 'pjField', 2, 'title', 'Cell phone', 'script'),
(NULL, 375, 'pjField', 3, 'title', 'Cell phone', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Fax', 'script'),
(NULL, 376, 'pjField', 2, 'title', 'Fax', 'script'),
(NULL, 376, 'pjField', 3, 'title', 'Fax', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 377, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 377, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 378, 'pjField', 2, 'title', 'Inloggen', 'script'),
(NULL, 378, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'The data you entered is invalid.', 'script'),
(NULL, 379, 'pjField', 2, 'title', 'The data you entered is invalid.', 'script'),
(NULL, 379, 'pjField', 3, 'title', 'The data you entered is invalid.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Users from selected department will receive this email notification.', 'script'),
(NULL, 404, 'pjField', 2, 'title', 'Users from selected department will receive this email notification.', 'script'),
(NULL, 404, 'pjField', 3, 'title', 'Users from selected department will receive this email notification.', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Selected Users will receive this email notification', 'script'),
(NULL, 405, 'pjField', 2, 'title', 'Selected Users will receive this email notification', 'script'),
(NULL, 405, 'pjField', 3, 'title', 'Selected Users will receive this email notification', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Check if you want client who posted the ticket to receive this email notification.', 'script'),
(NULL, 406, 'pjField', 2, 'title', 'Check if you want client who posted the ticket to receive this email notification.', 'script'),
(NULL, 406, 'pjField', 3, 'title', 'Check if you want client who posted the ticket to receive this email notification.', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Set the type of event when this email notification will be sent.', 'script'),
(NULL, 407, 'pjField', 2, 'title', 'Set the type of event when this email notification will be sent.', 'script'),
(NULL, 407, 'pjField', 3, 'title', 'Set the type of event when this email notification will be sent.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 408, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 408, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Last reply', 'script'),
(NULL, 409, 'pjField', 2, 'title', 'Last reply', 'script'),
(NULL, 409, 'pjField', 3, 'title', 'Last reply', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Client name', 'script'),
(NULL, 410, 'pjField', 2, 'title', 'Client name', 'script'),
(NULL, 410, 'pjField', 3, 'title', 'Client name', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Client email', 'script'),
(NULL, 411, 'pjField', 2, 'title', 'Client email', 'script'),
(NULL, 411, 'pjField', 3, 'title', 'Client email', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Received after', 'script'),
(NULL, 412, 'pjField', 2, 'title', 'Received after', 'script'),
(NULL, 412, 'pjField', 3, 'title', 'Received after', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Received before', 'script'),
(NULL, 413, 'pjField', 2, 'title', 'Received before', 'script'),
(NULL, 413, 'pjField', 3, 'title', 'Received before', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 414, 'pjField', 2, 'title', 'Sturen', 'script'),
(NULL, 414, 'pjField', 3, 'title', 'Enviar', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 415, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 415, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'The file size is invalid. It is greater than {maxsize}.', 'script'),
(NULL, 416, 'pjField', 2, 'title', 'The file size is invalid. It is greater than {maxsize}.', 'script'),
(NULL, 416, 'pjField', 3, 'title', 'The file size is invalid. It is greater than {maxsize}.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Verification code', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Verification code', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Verification code', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Verification code is required', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Verification code is required', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Verification code is required', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Verification code is required.', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Verification code is required.', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Verification code is required.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Verification code is incorrect.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'New client', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'New client', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 479, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 479, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Only images, doc, pdf, zip files are allowed to upload.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'We sorry that the current ticket was deleted by the administrator.', 'script'),
(NULL, 485, 'pjField', 2, 'title', 'We sorry that the current ticket was deleted by the administrator.', 'script'),
(NULL, 485, 'pjField', 3, 'title', 'We sorry that the current ticket was deleted by the administrator.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'We sorry that your account has just been disabled by the administrator.', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'We sorry that your account has just been disabled by the administrator.', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'We sorry that your account has just been disabled by the administrator.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'Email notifications', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'Email notifications', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Create different email notifications and configure the system to send email messages when different events happen e.g. new ticket is received, reply to ticket is posted, etc..', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Create different email notifications and configure the system to send email messages when different events happen e.g. new ticket is received, reply to ticket is posted, etc..', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Create different email notifications and configure the system to send email messages when different events happen e.g. new ticket is received, reply to ticket is posted, etc..', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Create notification', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'Create notification', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'Create notification', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Fill in the form below to create a new email notification. You can select the recipients who will receive the message. Using the available tokens you can include information from the support ticket in the email confirmation.', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'Fill in the form below to create a new email notification. You can select the recipients who will receive the message. Using the available tokens you can include information from the support ticket in the email confirmation.', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'Fill in the form below to create a new email notification. You can select the recipients who will receive the message. Using the available tokens you can include information from the support ticket in the email confirmation.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Update notification', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'Update notification', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'Update notification', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'You can edit the notification email message and select the users who will receive it. Use available tokens to customize the message.', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'You can edit the notification email message and select the users who will receive it. Use available tokens to customize the message.', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'You can edit the notification email message and select the users who will receive it. Use available tokens to customize the message.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'New ticket', 'script'),
(NULL, 647, 'pjField', 2, 'title', 'New ticket', 'script'),
(NULL, 647, 'pjField', 3, 'title', 'New ticket', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Fill in the form below to create a new ticket. You can assign the ticket to a specific department or operator. Add Notes which will be visible only for operators and not the client.', 'script'),
(NULL, 648, 'pjField', 2, 'title', 'Fill in the form below to create a new ticket. You can assign the ticket to a specific department or operator. Add Notes which will be visible only for operators and not the client.', 'script'),
(NULL, 648, 'pjField', 3, 'title', 'Fill in the form below to create a new ticket. You can assign the ticket to a specific department or operator. Add Notes which will be visible only for operators and not the client.', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'View ticket', 'script'),
(NULL, 649, 'pjField', 2, 'title', 'View ticket', 'script'),
(NULL, 649, 'pjField', 3, 'title', 'View ticket', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Below you can see full ticket details. Using the form at the bottom of the page you can reply to the ticket. Canned messages can be used to quickly reply using a predefined messages. You can edit and delete any of the replies posted. Edit available canned messages under Options page, Canned messages tab.', 'script'),
(NULL, 650, 'pjField', 2, 'title', 'Below you can see full ticket details. Using the form at the bottom of the page you can reply to the ticket. Canned messages can be used to quickly reply using a predefined messages. You can edit and delete any of the replies posted. Edit available canned messages under Options page, Canned messages tab.', 'script'),
(NULL, 650, 'pjField', 3, 'title', 'Below you can see full ticket details. Using the form at the bottom of the page you can reply to the ticket. Canned messages can be used to quickly reply using a predefined messages. You can edit and delete any of the replies posted. Edit available canned messages under Options page, Canned messages tab.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'All Clients', 'script'),
(NULL, 651, 'pjField', 2, 'title', 'All Clients', 'script'),
(NULL, 651, 'pjField', 3, 'title', 'All Clients', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Below you can see a list with all clients who posted a ticket. Upon posting a new ticket a client account is created for the person who posts it. You can quickly access tickets from particular clients by clicking on the number in the Tickets column.', 'script'),
(NULL, 652, 'pjField', 2, 'title', 'Below you can see a list with all clients who posted a ticket. Upon posting a new ticket a client account is created for the person who posts it. You can quickly access tickets from particular clients by clicking on the number in the Tickets column.', 'script'),
(NULL, 652, 'pjField', 3, 'title', 'Below you can see a list with all clients who posted a ticket. Upon posting a new ticket a client account is created for the person who posts it. You can quickly access tickets from particular clients by clicking on the number in the Tickets column.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'All Users', 'script'),
(NULL, 653, 'pjField', 2, 'title', 'All Users', 'script'),
(NULL, 653, 'pjField', 3, 'title', 'All Users', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Below you can see a list of support operators who can log in this administration page and view and reply to tickets received. Create a new user using the Add User tab above.', 'script'),
(NULL, 654, 'pjField', 2, 'title', 'Below you can see a list of support operators who can log in this administration page and view and reply to tickets received. Create a new user using the Add User tab above.', 'script'),
(NULL, 654, 'pjField', 3, 'title', 'Below you can see a list of support operators who can log in this administration page and view and reply to tickets received. Create a new user using the Add User tab above.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 655, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 655, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Fill in the form below to add new user. You can assign an user to specific department so email notifications are sent to him when ticket for his department is received.', 'script'),
(NULL, 656, 'pjField', 2, 'title', 'Fill in the form below to add new user. You can assign an user to specific department so email notifications are sent to him when ticket for his department is received.', 'script'),
(NULL, 656, 'pjField', 3, 'title', 'Fill in the form below to add new user. You can assign an user to specific department so email notifications are sent to him when ticket for his department is received.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Departments', 'script'),
(NULL, 657, 'pjField', 2, 'title', 'Departments', 'script'),
(NULL, 657, 'pjField', 3, 'title', 'Departments', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Below you can see a list with departments which your clients can contact. When sending a support ticket they can select the department who they need to contact.', 'script'),
(NULL, 658, 'pjField', 2, 'title', 'Below you can see a list with departments which your clients can contact. When sending a support ticket they can select the department who they need to contact.', 'script'),
(NULL, 658, 'pjField', 3, 'title', 'Below you can see a list with departments which your clients can contact. When sending a support ticket they can select the department who they need to contact.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Canned messages', 'script'),
(NULL, 659, 'pjField', 2, 'title', 'Canned messages', 'script'),
(NULL, 659, 'pjField', 3, 'title', 'Canned messages', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'You can create as many canned messages as you want and organize them in categories. Use canned messages to quickly reply to the support tickets received.', 'script'),
(NULL, 660, 'pjField', 2, 'title', 'You can create as many canned messages as you want and organize them in categories. Use canned messages to quickly reply to the support tickets received.', 'script'),
(NULL, 660, 'pjField', 3, 'title', 'You can create as many canned messages as you want and organize them in categories. Use canned messages to quickly reply to the support tickets received.', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Email address', 'script'),
(NULL, 661, 'pjField', 2, 'title', 'Email address', 'script'),
(NULL, 661, 'pjField', 3, 'title', 'Email address', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Remember me', 'script'),
(NULL, 662, 'pjField', 2, 'title', 'Remember me', 'script'),
(NULL, 662, 'pjField', 3, 'title', 'Remember me', 'script');

INSERT INTO `ticketsupport_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_post_ticket', 1, 'everyone|registered_clients::everyone', 'Everyone|Registered clients', 'enum', 1, 1, NULL),
(1, 'o_select_departments', 1, 'Yes|No::Yes', NULL, 'enum', 2, 1, NULL),
(1, 'o_upload_files', 1, 'Yes|No::Yes', NULL, 'enum', 3, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 4, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 5, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 6, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 7, 1, NULL),
(1, 'o_sender_email', 1, 'admin@admin.com', NULL, 'string', 8, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 9, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 11, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 12, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::1', 'Yes|No', 'enum', NULL, 1, NULL);

INSERT INTO `ticketsupport_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'operator', 'T');