<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	
	<div class="dashboard_header">
		<div class="item">
			<div class="stat tickets">
				<div class="info">
					<abbr><?php echo (int) @$tpl['new_tickets']; ?></abbr>
					<?php (int) @$tpl['new_tickets'] !== 1 ? __('lblDashNewTicketsToday') : __('lblDashNewTicketToday'); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat tickets">
				<div class="info">
					<abbr><?php echo (int) @$tpl['waiting_tickets']; ?></abbr>
					<?php (int) @$tpl['waiting_tickets'] !== 1 ? __('lblDashTicketsWaiting') : __('lblDashTicketWaiting'); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat tickets">
				<div class="info">
					<abbr><?php echo (int) @$tpl['active_tickets']; ?></abbr>
					<?php (int) @$tpl['active_tickets'] !== 1 ? __('lblDashActiveTickets') : __('lblDashActiveTicket'); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashTicketsRequiringAction');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<table class="pj-table" cellspacing="0" cellpadding="0" style="width: 100%;">
						<thead>
							<tr>
								<th><?php __('lblDashIDClient')?></th>
								<th><?php __('lblDashDeptAssigned')?></th>
								<th><?php __('lblLastReply'); ?></th>
								<th><?php __('lblStatus'); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							$statuses = __('ticket_statarr', true);
							if(!empty($tpl['ticket_arr']))
							{
								foreach($tpl['ticket_arr'] as $k => $v)
								{
									?>
									<tr class="pj-table-row-odd">
										<td>
											<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['ticket_id']);?></a>
											<br/>
											<?php echo pjSanitize::html($v['client']);?>
										</td>
										<td>
											<?php echo pjSanitize::html($v['department']);?>
											<?php
											if(!empty($v['assigned_to']))
											{
												?><br/><?php echo pjSanitize::html($v['assigned_to']);
											} 
											?>
										</td>
										<td>
											<?php
											if(!empty($v['last_reply']))
											{ 
												echo date($tpl['option_arr']['o_date_format'], strtotime($v['last_reply']));?>
												<br/>
												<?php 
												echo date($tpl['option_arr']['o_time_format'], strtotime($v['last_reply']));
											}else{
												__('lblNA');
											} 
											?>
										</td>
										<td><?php echo $statuses[$v['status']];?></td>
									</tr>
									<?php
								}
							}else{
								?>
								<tr class="pj-table-row-odd">
									<td colspan="4"><?php __('lblDashNoTicketsFound'); ?></td>
								</tr>
								<?php
							} 
							?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashRepliesByClients');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column dashboard_last">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['reply_arr']))
					{ 
						foreach($tpl['reply_arr'] as $k => $v)
						{
							$by_name = empty($v['user_name']) ? stripslashes($v['client_name']) : stripslashes($v['user_name']);
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTickets&amp;action=pjActionUpdate&amp;id=<?php echo $v['ticket_id'];?>"><?php echo $v['ticketID'];?></a> | <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionUpdate&amp;id=<?php echo $v['clientID'];?>"><?php echo pjSanitize::html($by_name);?></a> <span><?php __('lblDashOn');?> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></span></label>
								<label><?php echo nl2br(htmlspecialchars(stripslashes(pjUtil::truncateDescription($v['reply_text'], 300, ' '))));?></label>
							</div>
							<?php 
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblDashNoRepliesFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	<?php
	$monthname_arr = __('months', true);
	$dayname_arr = __('daynames', true);
	$month_num = date("n", strtotime($_SESSION[$controller->defaultUser]['last_login']));
	$day_num = date("N");
	$curr_month_num = date("n");
	?>
	<div class="clear_left t20 overflow">
		<div class="float_left black t30"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo $monthname_arr[$month_num] . ' ' . date("d, Y H:i", strtotime($_SESSION[$controller->defaultUser]['last_login'])); ?></div>
		<div class="float_right overflow">
			<div class="dashboard_date">
				<abbr><?php echo $dayname_arr[$day_num]; ?></abbr>
				<?php echo $monthname_arr[$curr_month_num] . ' ' . date("d, Y"); ?>
			</div>
			<div class="dashboard_hour"><?php echo date('H:i'); ?></div>
		</div>
	</div>
	<?php
}
?>