<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	pjUtil::printNotice(__('infoTicketsTitle', true, false), __('infoTicketsDesc', true, false));
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminTickets" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddTicket'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$statuses = __('ticket_statarr', true);
		?>
		<div class="float_right form pj-form">
			<label class="block float_left t7 r5"><?php __('lblFilterByStatus');?>:</label>
			<select name="status" id="filter_by_status" class="pj-form-field required">
				<option value="">-- <?php __('lblAll');?> --</option>
				<option value="New"><?php echo $statuses['New']; ?></option>
				<option value="RepliedByClient"><?php echo $statuses['RepliedByClient']; ?></option>
				<option value="RepliedBySupport"><?php echo $statuses['RepliedBySupport']; ?></option>
				<option value="InProgress"><?php echo $statuses['InProgress']; ?></option>
				<option value="Closed"><?php echo $statuses['Closed']; ?></option>
			</select>
		</div>
		<br class="clear_both" />
	</div>


	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			
			<p class="float_left w340">
				<label class="title"><?php __('lblTicketID'); ?></label>
				<input type="text" name="ticket_id" id="ticket_id" class="pj-form-field w150" />
			</p>
			<p class="w340">
				<label class="title"><?php __('lblDepartment'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['department_arr']))
					{ 
						?>
						<select name="department_id" id="department_id" class="pj-form-field <?php echo $tpl['option_arr']['o_select_departments'] == 'Yes' ? 'required' : null; ?> w142">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['department_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							}
							?>
						</select>
						<?php
					}else{
						$message = __('lblNoDepartmentsMessage', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminDepartments&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?>
						<span class="block t5"><?php echo $message;?></span>
						<?php
					} 
					?>
				</span>
			</p>
			<p class="float_left w340">
				<label class="title"><?php __('lblClientName'); ?></label>
				<input type="text" name="client_name" id="client_name" class="pj-form-field w150" />
			</p>
			<p class="w340">
				<label class="title"><?php __('lblAssignedTo'); ?></label>
				<span class="inline_block">
					<select name="user_id" id="user_id" class="pj-form-field w142">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['user_arr'] as $k => $v)
						{
							
							?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
							
						}
						?>
					</select>
				</span>
			</p>
			<p class="float_left w340">
				<label class="title"><?php __('lblClientEmail'); ?></label>
				<input type="text" name="client_email" id="client_email" class="pj-form-field w150" />
			</p>
			<p class="w340">
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="adv_status" id="adv_status" class="pj-form-field">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						$statuses = __('ticket_statarr', true);
						foreach ($statuses as $k => $v)
						{
							if($tpl['arr']['status'] == $k)
							{
								?><option value="<?php echo $k; ?>" selected="selected"><?php echo $v; ?></option><?php
							}else{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}
						}
						?>
					</select>
				</span>
			</p>
			<p class="float_left w340">
				<label class="title"><?php __('lblReceivedAfter'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="received_after" id="received_after" class="pj-form-field pointer w80 required datepick" value="" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			<p class="w340">
				<label class="title"><?php __('lblReceivedBefore'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="received_before" id="received_before" class="pj-form-field pointer w80 required datepick" value="" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblMessage'); ?></label>
				<span class="inline_block">
					<textarea name="message" class="pj-form-field w500 h80"></textarea>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
			</p>
			<br class="clear_both" />
		</form>
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jqTimeFormat = "<?php echo pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']); ?>";
	pjGrid.currentUserId = <?php echo (int) $_SESSION[$controller->defaultUser]['id']; ?>;
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
	{
		?>pjGrid.queryString += "&client_id=<?php echo $_GET['client_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.ticketid = "<?php echo pjSanitize::clean(__('lblTicketID', true)); ?>";
	myLabel.client = "<?php echo pjSanitize::clean(__('lblClient', true)); ?>";
	myLabel.department = "<?php echo pjSanitize::clean(__('lblDepartment', true)); ?>";
	myLabel.assignedto = "<?php echo pjSanitize::clean(__('lblAssignedTo', true)); ?>";
	myLabel.confirmed = "<?php echo pjSanitize::clean(__('lblIsActive', true)); ?>";
	myLabel.lastreply = "<?php echo pjSanitize::clean(__('lblLastReply', true)); ?>";
	myLabel.departments = <?php echo count($tpl['department_arr']);?>;
	myLabel.revert_status = "<?php echo pjSanitize::clean(__('lblRevertStatus', true)); ?>";
	myLabel.exported = "<?php echo pjSanitize::clean(__('lblExport', true)); ?>";
	myLabel.New = "<?php echo $statuses['New']; ?>";
	myLabel.RepliedByClient = "<?php echo $statuses['RepliedByClient']; ?>";
	myLabel.RepliedBySupport = "<?php echo $statuses['RepliedBySupport']; ?>";
	myLabel.InProgress = "<?php echo $statuses['InProgress']; ?>";
	myLabel.Closed = "<?php echo $statuses['Closed']; ?>";
	myLabel.delete_selected = "<?php echo pjSanitize::clean(__('lblDeleteSelected', true)); ?>";
	myLabel.delete_confirmation = "<?php echo pjSanitize::clean(__('lblDeleteConfirmation', true)); ?>";
	myLabel.status = "<?php echo pjSanitize::clean(__('lblStatus', true)); ?>";
	</script>
	<?php
}
?>