<?php
$index = $_GET['index'];
$error_messages = __('front_sys', true);
?>
<div class="container-fluid pjTsContainer">
	<?php include PJ_VIEWS_PATH . 'pjLoad/elements/header.php'; ?>
	<div class="panel panel-default pjTsBody">
		<?php
		if(isset($tpl['arr']))
		{ 
			$client_name = !empty($tpl['arr']['client_name']) ? pjSanitize::html(stripslashes($tpl['arr']['client_name'])) : null;
			?>
			<header class="panel-heading text-left clearfix">
				<a href="#" class="btn btn-link pjTsBtnLink pjTsMenuItem" data-hash="Tickets">&laquo;&nbsp;<?php __('front_label_back'); ?></a>
				<p class="pull-right pjTsTicketTitle"><?php __('front_label_ticketid'); ?>: <?php echo $tpl['arr']['ticket_id'];?></p><!-- /.pull-right pjTsTicketTitle -->
			</header><!-- /.panel-heading text-center -->
			<?php
			$show_ticket_content = true;
			if (isset($tpl['paginator']) && $tpl['paginator']['pages'] > 1)
			{
				$page = $tpl['paginator']['pages'];
				if(isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0)
				{
					$page = $_GET['pjPage'];
				}
				if($page > 1)
				{
					$show_ticket_content = false;
				}
			}
			if($show_ticket_content == true)
			{	 
				?>
				
				<div class="panel-body pjTsTicketDetails">
					<p class="pjTsTicketMeta"><em><?php __('lblPostedOn'); ?>: </em><span><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['created'])), "Y-m-d", $tpl['option_arr']['o_date_format']) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created'])); ?></span><em> <?php __('lblPostedBy'); ?> </em><strong><?php echo $client_name;?></strong></p><!-- /.pjTsTicketMeta -->
	
					<div class="pjTsTicketContent"><?php echo nl2br(stripslashes(htmlspecialchars($tpl['arr']['message'])));?></div>
					<?php
					if(!empty($tpl['ticket_file_arr']))
					{ 
						?>
						<div class="pjTsTicketDetailsActions">
							<p><?php __('lblReplyFiles');?>: </p>
		
							<ul class="list-inline pjTsListFiles">
								<?php
								foreach($tpl['ticket_file_arr'] as $f)
								{ 
									?>
									<li>
										<a target="_blank" href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?controller=pjLoad&action=pjActionDownloadFile&id=<?php echo $f['id']; ?>" class="btn btn-link pjTsBtn pjTsBtnLink"><?php echo $f['file_name'];?></a>
									</li>
									<?php
								} 
								?>
							</ul><!-- /.list-inline pjTsListFiles -->
						</div><!-- /.pjTsTicketDetailsActions -->
						<?php
					} 
					?>
				</div><!-- /.panel-body pjTsTicketDetails -->
				<?php
			}
			if(!empty($tpl['reply_arr']))
			{ 
				if(isset($_GET['pjPage']))
				{	
					?><div id="pjTsPaging_<?php echo $index;?>"></div><?php
				} 
				?>
				<ul class="list-group pjTsTicketReplies">
					<?php
					foreach($tpl['reply_arr'] as $v)
					{ 
						$rating_arr = __('rating_arr', true);
						$by_name = empty($v['user_name']) ? pjSanitize::html(stripslashes($v['client_name'])) : pjSanitize::html(stripslashes($v['user_name']));
						$file_arr = isset($tpl['reply_file_arr'][$v['id']]) ? $tpl['reply_file_arr'][$v['id']] : array();
						?>
						<li id="pjTsTicketReply_<?php echo $v['id'];?>" class="list-group-item pjTsTicketReply">
							<p class="pjTsTicketMeta">
								<em><?php __('lblPostedOn'); ?>: </em>
								<span><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['created'])), "Y-m-d", $tpl['option_arr']['o_date_format']) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created'])); ?></span><em> <?php __('lblPostedBy'); ?> </em>
								<strong><?php echo $by_name;?></strong>
								
								<?php
								if((int) $v['user_id'] > 0 && $tpl['option_arr']['o_allow_rating'] == 'Yes' && empty($v['rate']))
								{ 
									?>
									<span class="pjTsRating">
										<a class="btn btn-link pjTsBtnLink" role="button" data-toggle="collapse" href="#pjTsRatingWrapper<?php echo $v['id'];?>" aria-expanded="false" aria-controls="pjTsRatingWrapper<?php echo $v['id'];?>">
											<span><?php __('front_rate_this_reply');?></span>
										</a>
									</span>
									<?php
								} else if((int) $v['user_id'] > 0 && (int)$v['rate'] > 0 && $tpl['option_arr']['o_allow_rating'] == 'Yes'){
									?><span class="pjTsRating"><span><?php __('front_rated');?>: <?php echo $rating_arr[$v['rate']];?></span></span><?php
								}
								?>
							</p><!-- /.pjTsTicketMeta -->

							<?php
							if((int) $v['user_id'] > 0 && $tpl['option_arr']['o_allow_rating'] == 'Yes' && empty($v['rate']))
							{ 
								
								?>
								<div class="pjTsRatingWrapper collapse" id="pjTsRatingWrapper<?php echo $v['id'];?>">
									<div class="pjSrRateBody">
										<ul class="pjSrListRates">
											<li class="pjSrRateBad">
												<a href="#" class="pjTsRateLink" data-id="<?php echo $v['id'];?>" data-rate="1">
													<span><?php echo $rating_arr[1];?></span>
												</a>
											</li>
											
											<li class="pjSrRateNotBad">
												<a href="#" class="pjTsRateLink" data-id="<?php echo $v['id'];?>" data-rate="2">
													<span><?php echo $rating_arr[2];?></span>
												</a>
											</li>
											
											<li class="pjSrRateGood">
												<a href="#" class="pjTsRateLink" data-id="<?php echo $v['id'];?>" data-rate="3">
													<span><?php echo $rating_arr[3];?></span>
												</a>
											</li>
											
											<li class="pjSrRateVeryGood">
												<a href="#" class="pjTsRateLink" data-id="<?php echo $v['id'];?>" data-rate="4">
													<span><?php echo $rating_arr[4];?></span>
												</a>
											</li>
											
											<li class="pjSrRateExcellent">
												<a href="#" class="pjTsRateLink" data-id="<?php echo $v['id'];?>" data-rate="5">
													<span><?php echo $rating_arr[5];?></span>
												</a>
											</li>
											
										</ul><!-- /.pjSrListRates -->
									</div><!-- /.pjSrRateBody -->
								</div><!-- /#sendByEmail.pjSlForm pjSlFormDirection collapse -->
								<?php
							} 
							?>
							
							<div class="pjTsTicketContent"><?php echo nl2br(htmlspecialchars(stripslashes($v['reply_text'])));?></div>
							
							<?php
							if(!empty($file_arr))
							{
								?>
								<br/>
								<div class="files">
									<p class="pull-left"><?php __('lblReplyFiles');?>:&nbsp;&nbsp;</p>
									<?php
									foreach($file_arr as $k => $f)
									{
										?>
										<a target="_blank" href="<?php echo $_SERVER['SCRIPT_NAME']; ?>?controller=pjLoad&action=pjActionDownloadFile&id=<?php echo $f['id']; ?>"><?php echo $f['file_name'];?></a><?php echo $k+1 < count($file_arr) ? '&nbsp;|&nbsp;' : NULL; ?>
										<?php 
									}	 
									?>
								</div>
								<?php 
							} 
							?>
						</li><!-- /.list-group-item pjTsTicketReply -->
						<?php
					} 
					?>
				</ul><!-- /.list-group pjTsTicketReplies -->
				<?php 
				include_once PJ_VIEWS_PATH . 'pjLoad/elements/pagination.php';
			}
			?>
			<footer class="panel-footer">
				<form id="frmReplyForm_<?php echo $index;?>" action="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjLoad&amp;action=pjActionPostReply" method="post" class="form-horizontal pjTsForm pjTsFormSendMessage" data-toggle="validator" role="form" enctype="multipart/form-data">
					<p class="pjFsFormTitle"><?php __('lblReplyToTicket'); ?></p><!-- /.pjFsFormTitle -->
					
					<div class="row">
						<div class="form-group">
							<label for="" class="col-sm-3 control-label"><?php __('lblReplyMessage'); ?></label>
						
							<div class="col-sm-8">
								<textarea name="reply_text" cols="60" rows="20" class="form-control required" data-msg-required="<?php echo $error_messages['contact_message'];?>"></textarea>
								<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
							</div><!-- /.col-sm-8 -->
						</div><!-- /.form-group -->
						<?php
						if( $tpl['option_arr']['o_upload_files'] == 'Yes' )
						{ 
							?>
							<div class="form-group">
								<div class="pjTsAddFile">
									<label for="" class="col-sm-3 control-label"><?php __('lblReplyFiles'); ?></label>
	
									<div class="col-sm-8">
										<div class="btn btn-default pjTsBtn pjTsBtnFile pjTsBtnUpload">
											<?php __('front_add_file');?>
																			
											<input type="file" name="files[]" class="pjTsFileUploadField" multiple="multiple" data-msg-extension="<?php echo $error_messages['contact_file_ext'];?>"/>
										</div>
																
										<a href="#" class="btn btn-default pjTsBtn pjTsBtnFile pjTsBtnReset"><?php __('front_add_file');?></a>
	
										<p class="pjTsUploadedFiles"></p><!-- /.pjTsUploadedFiles -->
										<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
									</div><!-- /.col-sm-8 -->
								</div><!-- /.pjTsAddFile -->
							</div><!-- /.form-group -->
							<?php
						}
						if(!$controller->checkLogin())
						{ 
							?>
							<div class="form-group pjTsCaptcha">
								<label for="" class="col-sm-3 control-label"><?php __('front_verification');?></label>
							
								<div class="col-sm-6">
									<input type="text" name="verification" maxlength="6" autocomplete="off" class="form-control required" data-msg-required="<?php echo $error_messages['contact_verification'];?>" data-msg-remote="<?php echo $error_messages['contact_verification_inv'];?>"/>
									<img id="pjTsCaptchaImage_<?php echo $index;?>" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 999999); ?><?php echo isset($_GET['session_id']) ? '&session_id=' . $_GET['session_id'] : NULL;?>" alt="" />
									<div class="help-block with-errors"><ul class="list-unstyled"></ul></div>
								</div><!-- /.col-sm-6 -->
							</div><!-- /.form-group pjTsCaptcha -->
							<?php
						} 
						?>
						<input type="hidden" name="ticket_id" value="<?php echo $tpl['arr']['id']; ?>" />
						<input type="hidden" name="client_id" value="<?php echo (int) $_SESSION[$controller->defaultClient]['id']; ?>" />
					
						<div class="form-group">
							<div class="col-sm-9 col-sm-offset-3">
								<button type="submit" class="btn btn-default pjTsBtn pjTsBtnPrimary"><?php __('btnReply'); ?></button>
							</div><!-- /.col-sm-9 col-sm-offset-3 -->
						</div><!-- /.form-group -->
						
						<div class="form-group" style="display: none;">
							<div class="col-sm-9 col-sm-offset-3">
								<p id="pjTsMessage_<?php echo $index;?>" class=""></p>
							</div><!-- /.col-sm-6 col-sm-offset-3 -->
						</div><!-- /.form-group -->
						
					</div><!-- /.row -->
				</form><!-- /.form-horizontal pjTsForm pjTsFormSendMessage -->
			</footer><!-- /.panel-footer -->
			<?php
		}else{
			?>
			<header class="panel-heading text-left clearfix">
				<a href="#" class="btn btn-link pjTsBtnLink pjTsMenuItem" data-hash="Tickets">&laquo;&nbsp;<?php __('front_label_back'); ?></a>
			</header><!-- /.panel-heading text-center -->
			<div class="panel-body pjTsTicketDetails"><?php __('front_ticket_not_found')?></div>
			<?php
		}
		?>
	</div><!-- /.panel panel-default pjTsBody -->
</div><!-- /.container-fluid pjTsContainer -->				