var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateMessage = $("#frmCreateMessage"),
			$frmUpdateMessage = $("#frmUpdateMessage"),
			validate = ($.fn.validate !== undefined),
			chosen = ($.fn.chosen !== undefined),
			datagrid = ($.fn.datagrid !== undefined);

		if ($frmCreateMessage.length > 0 && validate) {
			$frmCreateMessage.validate({
				messages: {
					"category_id": {
						required: myLabel.field_required
					},
					"message": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				ignore: '',
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			if (chosen) {
				$("#category_id").chosen();
			}
		}
		if ($frmUpdateMessage.length > 0 && validate) {
			$frmUpdateMessage.validate({
				messages: {
					"category_id": {
						required: myLabel.field_required
					},
					"message": {
						required: myLabel.field_required
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				//ignore: '',
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			if (chosen) {
				$("#category_id").chosen();
			}
			
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminMessages&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminMessages&action=pjActionDeleteMessage&id={:id}"}
				          ],
				columns: [{text: myLabel.subject, type: "text", sortable: false, editable: false, width: 400},
				          {text: myLabel.category, type: "text", sortable: false, editable: false, width: 210}],
				dataUrl: "index.php?controller=pjAdminMessages&action=pjActionGetMessage",
				dataType: "json",
				fields: ['message', 'categories'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminMessages&action=pjActionDeleteMessageBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminMessages&action=pjActionSaveMessage&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
	});
})(jQuery_1_8_2);