/*!
 * Ticket Support Script v3.0
 * 
 * http://www.phpjabbers.com/ticket-support-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});

	var document = window.document,
		routes = [
	          	{pattern: /^#!\/Contact$/, eventName: "loadContact"},
	          	{pattern: /^#!\/Login$/, eventName: "loadLogin"},
	          	{pattern: /^#!\/Register$/, eventName: "loadRegister"},
	          	{pattern: /^#!\/Forgot$/, eventName: "loadForgot"},
	          	{pattern: /^#!\/Tickets$/, eventName: "loadTickets"},
	          	{pattern: /^#!\/Ticket\/ticket_id:(\d+)?$/, eventName: "loadTicket"},
	          	{pattern: /^#!\/Ticket\/ticket_id:(\d+)\/page:(\d+)?$/, eventName: "loadTicket"},
	          	{pattern: /^#!\/AddTicket$/, eventName: "loadAddTicket"},
	          	{pattern: /^#!\/Profile$/, eventName: "loadProfile"}
	          ];
    
	function loadDelayedCSS(opts) {
		pjQ.$(window).load(function() {
			pjQ.$('body').append(pjQ.$('<link rel="stylesheet" type="text/css" />').attr('href', opts.server+'app/web/css/transitions.css'));
		});
	}
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadContact");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function TicketSupport(opts) {
		if (!(this instanceof TicketSupport)) {
			return new TicketSupport(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	TicketSupport.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	TicketSupport.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnYacht(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	TicketSupport.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;
			this.logged = false;
			this.ticket_id = null;
			this.page = null;
			this.keyword = null;
			this.opts = {};
			
			return this;
		},
		disableButtons: function () {
			var $el;
			this.$container.find(".pjTsBtn").each(function (i, el) {
				$el = pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".pjTsBtn").removeAttr("disabled");
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjTsContainer_" + this.opts.index);
			this.$container = pjQ.$(this.container);
			this.logged = self.opts.is_logged;
			
			pjQ.$(window).on("loadContact", this.container, function (e) {
				self.loadContact.call(self);
			}).on("loadLogin", this.container, function (e) {
				self.loadLogin.call(self);
			}).on("loadRegister", this.container, function (e) {
				self.loadRegister.call(self);
			}).on("loadForgot", this.container, function (e) {
				self.loadForgot.call(self);
			}).on("loadTickets", this.container, function (e) {
				self.loadTickets.call(self);
			}).on("loadTicket", this.container, function (e) {
				switch (arguments.length) {
					case 1:
						self.page = null;
						break;
					case 2:
						self.ticket_id = arguments[1];
						self.page = null;
						break;
					case 3:
						self.ticket_id = arguments[1];
						self.page = arguments[2];
						break;
				}
				self.loadTicket.call(self);
			}).on("loadAddTicket", this.container, function (e) {
				self.loadAddTicket.call(self);
			}).on("loadProfile", this.container, function (e) {
				self.loadProfile.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadContact.call(this);
			} else {
				onHashChange.call(null);
			}
			
			this.$container.on("click.ts", ".pjTsSelectorLocale", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var locale = pjQ.$(this).data("id");
				self.opts.locale = locale;
				pjQ.$(this).addClass("pjTsBtnActive").parent().parent().find("a.pjTsSelectorLocale").not(this).removeClass("pjTsBtnActive");
				
				pjQ.$.get([self.opts.folder, "index.php?controller=pjFront&action=pjActionLocale"].join(""), {
					"locale_id": locale,
					"session_id": self.opts.session_id
				}).done(function (data) {
					if(self.logged == true)
					{
						if(!hashBang("#!/Tickets"))
						{
							self.loadTickets.call(self);
						}
					}else{
						if(!hashBang("#!/Contact"))
						{
							self.loadContact.call(self);
						}
					}
				}).fail(function () {
					log("Deferred is rejected");
				});
				return false;
			}).on("click.ts", ".pjTsMenuItem", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var hash = pjQ.$(this).data("hash");
				if(hash == 'Logout')
				{
					pjQ.$.get([self.opts.folder, "index.php?controller=pjLoad&action=pjActionLogout", "&session_id=", self.opts.session_id].join("")).done(function (data) {
						if(data.hash == 'Login')
						{
							if(!hashBang("#!/Login"))
							{
								self.loadLogin.call(self);
							}
						}
						if(data.hash == 'Contact')
						{
							if(!hashBang("#!/Contact"))
							{
								self.loadContact.call(self);
							}
						}
					}).fail(function () {
						log("Deferred is rejected");
					});
				}else{
					hashBang("#!/" + hash);
				}
				return false;
			}).on("click.ts", ".pjTsForgotLink", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				hashBang("#!/Forgot");
				return false;
			}).on("click.ts", ".pjTsTicketDetail", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.page = null;
				hashBang("#!/Ticket/ticket_id:" + pjQ.$(this).attr('data-id'));
				return false;
			}).on("click.ts", ".pjTsPaging", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				hashBang("#!/Ticket/ticket_id:" + self.ticket_id + "/page:" + pjQ.$(this).attr('data-page'));
				return false;
			}).on("keyup.ts", ".pjTsSearchKeyword", function (e) {
				if(e.keyCode == 13)
				{
					self.keyword = pjQ.$(this).val();
					if (!hashBang("#!/Tickets")) 
					{
						self.loadTickets.call(self);
					}
				}
			}).on("click.ts", ".pjTsRateLink", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var params = {};
				params.reply_id = pjQ.$(this).attr('data-id');
				params.rate = pjQ.$(this).attr('data-rate');
				self.disableButtons.call(self);
				pjQ.$.get([self.opts.folder, "index.php?controller=pjLoad&action=pjActionRate", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
					if (data.status != undefined && data.status == 'ERR') {
						self.enableButtons.call(self);
						
					}else{
						pjQ.$('#pjTsTicketReply_' + params.reply_id).html(data);
						self.enableButtons.call(self);
					}
				}).fail(function () {
					self.enableButtons.call(self);
				});
				
				return false;
			}).on("click.ts", ".pjTsCreateAccLink", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if (!hashBang("#!/Register")) 
				{
					self.loadRegister.call(self);
				}
				return false;
			});
		},
		bindUploadFile: function()
		{
			if (pjQ.$('.pjTsFileUploadField').length) 
			{
				var holderSelector = '.pjTsAddFile';
				var hasSelectedClass = 'pjFsAddFileAdded';
				var inputSelector = '.pjTsFileUploadField';
				var namesSelector = '.pjTsUploadedFiles';
				
				var multipleNamesDivider = '; ';

				pjQ.$(inputSelector).on('change', function() {
					
					var input = this,
						files = input.files;

					pjQ.$(input).closest(holderSelector).toggleClass(hasSelectedClass, input.value !== '').find(namesSelector)
						.text(
							pjQ.$.map(files, function(file) {
								var file_name = file.name;
								return file.name;
							}).join(multipleNamesDivider)
						);
				});
			};
		},
		bindContactForm: function()
		{
			var self = this;
			var $frmContact = pjQ.$('#pjTsContactForm_' + self.opts.index);
			
			if($frmContact != null)
			{
				self.bindUploadFile.call(self);
				
				pjQ.$.validator.addMethod('validateEmail',
					function (value) { 
						var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
					    return re.test(value);
					}
				);
				$frmContact.validate({
					rules: {
						"verification": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&session_id=" + self.opts.session_id
						},
						"files[]": {extension: '"' + self.opts.allowed_ext + '"'}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'files[]')
		            	{
							error.appendTo(element.parent().siblings().find('ul'));
		            	}else{
		            		error.appendTo(element.siblings().find('ul'));
		            	}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().addClass('has-error');
		            	}else{
		            		$element.parent().addClass('has-error');
		            	}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().removeClass('has-error').addClass('has-success');
		            	}else{
		            		$element.parent().removeClass('has-error').addClass('has-success');
		            	}
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmContact.ajaxSubmit({
		            		success: function(data) {
		            			
		            			if(data.status == 'OK')
		            			{
		            				var $captchaImg = pjQ.$('#pjTsCaptchaImage_' + self.opts.index);
		            				if($captchaImg.length > 0){
										var rand = Math.floor((Math.random()*999999)+1); 
										$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + "&session_id=" + self.opts.session_id);
									}
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            				$frmContact.resetForm();
			            			pjQ.$('.pjTsUploadedFiles').html('');
		            			}else{
		            				if(data.code == '100')
		            				{
		            					hashBang("#!/Login");
		            				}else{
		            					$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();
		            				}
		            			}
		            			
		            			self.enableButtons.call(self);
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindLoginForm: function()
		{
			var self = this;
			var $frmLogin = pjQ.$('#pjTsLoginForm_' + self.opts.index);
			
			if($frmLogin.length > 0)
			{
				pjQ.$.validator.addMethod('validateEmail',
					function (value) { 
						var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
					    return re.test(value);
					}
				);
				
				$frmLogin.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.siblings().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmLogin.ajaxSubmit({
		            		success: function(data) {
		            			if(data.status == 'OK')
		            			{
		            				self.logged = true;
		            				$frmLogin.resetForm();
		            				hashBang("#!/Tickets");
		            			}else{
		            				$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();

			            			self.enableButtons.call(self);
		            			}
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindRegisterForm: function()
		{
			var self = this;
			var $frmRegister = pjQ.$('#pjTsRegisterForm_' + self.opts.index);
			
			if($frmRegister.length > 0)
			{
				$frmRegister.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&session_id=" + self.opts.session_id
						},
						"verification": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&session_id=" + self.opts.session_id
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.siblings().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmRegister.ajaxSubmit({
		            		success: function(data) {
		            			if(data.code != '100')
		            			{		            				
		            				var $captchaImg = pjQ.$('#pjTsCaptchaImage_' + self.opts.index);
		            				if($captchaImg.length > 0){
										var rand = Math.floor((Math.random()*999999)+1); 
										$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + '&session_id=' + self.opts.session_id);
									}
		            				$frmRegister.resetForm();
		            				$frmRegister.find('.pjTsRegisterFormInner').hide();
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            				if(data.code == '200')
		            				{
		            					pjQ.$('#pjTsLoginLink_' + self.opts.index).show();
		            				}
		            			}else{
		            				$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();
		            			}
		            			
		            			self.enableButtons.call(self);
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindForgotForm: function()
		{
			var self = this;
			var $frmForgot = pjQ.$('#pjTsForgotForm_' + self.opts.index);
			
			if($frmForgot.length > 0)
			{
				pjQ.$.validator.addMethod('validateEmail',
					function (value) { 
						var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
					    return re.test(value);
					}
				);
				
				$frmForgot.validate({
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.siblings().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmForgot.ajaxSubmit({
		            		success: function(data) {
		            			if(data.status == 'OK')
		            			{		            				
		            				$frmForgot.resetForm();
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            			}else{
		            				$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();
		            			}
		            			
		            			self.enableButtons.call(self);
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindReplyForm: function()
		{
			var self = this;
			var $frmReply = pjQ.$('#frmReplyForm_' + self.opts.index);
			
			if($frmReply != null)
			{
				self.bindUploadFile.call(self);
				$frmReply.validate({
					rules: {
						"verification": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&session_id=" + self.opts.session_id
						},
						"files[]": {extension: '"' + self.opts.allowed_ext + '"'}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'files[]')
		            	{
							error.appendTo(element.parent().siblings().find('ul'));
		            	}else{
		            		error.appendTo(element.siblings().find('ul'));
		            	}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().addClass('has-error');
		            	}else{
		            		$element.parent().addClass('has-error');
		            	}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().removeClass('has-error').addClass('has-success');
		            	}else{
		            		$element.parent().removeClass('has-error').addClass('has-success');
		            	}
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmReply.ajaxSubmit({
		            		success: function(data) {
		            			if(data.status == 'OK')
		            			{
		            				var $captchaImg = pjQ.$('#pjTsCaptchaImage_' + self.opts.index);
		            				if($captchaImg.length > 0){
										var rand = Math.floor((Math.random()*999999)+1); 
										$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + '&session_id=' + self.opts.session_id);
									}
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            				$frmReply.resetForm();
			            			pjQ.$('.pjTsUploadedFiles').html('');
			            			
			            			setTimeout(function(){ self.loadTicket.call(self); }, 2000);
		            			}else{
		            				$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();
		            			}
		            			self.enableButtons.call(self);
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindAddTicketForm: function()
		{
			var self = this;
			var $frmAddTicket = pjQ.$('#pjTsAddTicketForm_' + self.opts.index);
			
			if($frmAddTicket != null)
			{
				self.bindUploadFile.call(self);
				$frmAddTicket.validate({
					rules: {
						"verification": {
							remote: self.opts.folder + "index.php?controller=pjFront&action=pjActionCheckCaptcha&session_id=" + self.opts.session_id
						},
						"files[]": {extension: '"' + self.opts.allowed_ext + '"'}
					},
					ignore: "",
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						if(element.attr('name') == 'files[]')
		            	{
							error.appendTo(element.parent().siblings().find('ul'));
		            	}else{
		            		error.appendTo(element.siblings().find('ul'));
		            	}
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().addClass('has-error');
		            	}else{
		            		$element.parent().addClass('has-error');
		            	}
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	if($element.attr('name') == 'files[]')
		            	{
		            		$element.parent().parent().removeClass('has-error').addClass('has-success');
		            	}else{
		            		$element.parent().removeClass('has-error').addClass('has-success');
		            	}
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmAddTicket.ajaxSubmit({
		            		success: function(data) {
		            			if(data.status == 'OK')
		            			{
		            				var $captchaImg = pjQ.$('#pjTsCaptchaImage_' + self.opts.index);
		            				if($captchaImg.length > 0){
										var rand = Math.floor((Math.random()*999999)+1); 
										$captchaImg.attr("src", self.opts.folder + 'index.php?controller=pjFront&action=pjActionCaptcha&rand=' + rand + '&session_id=' + self.opts.session_id);
									}
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            				$frmAddTicket.resetForm();
			            			pjQ.$('.pjTsUploadedFiles').html('');
			            			
			            			setTimeout(function(){ hashBang("#!/Tickets"); }, 2000);
		            			}else{
		            				$message.addClass('pjTsTitleError').html(data.text).parent().parent().show();
		            				self.enableButtons.call(self);
		            			}
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		bindProfileForm: function()
		{
			var self = this;
			var $frmProfile = pjQ.$('#pjTsProfileForm_' + self.opts.index);
			
			if($frmProfile.length > 0)
			{
				pjQ.$.validator.addMethod('validateEmail',
					function (value) { 
						var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
					    return re.test(value);
					}
				);
				
				$frmProfile.validate({
					rules: {
						"email": {
							remote: self.opts.folder + "index.php?controller=pjLoad&action=pjActionCheckEmail&id=" + $frmProfile.find("input[name='id']").val() + "&session_id=" + self.opts.session_id
						}
					},
					onkeyup: false,
					errorElement: 'li',
					errorPlacement: function (error, element) {
						error.appendTo(element.siblings().find('ul'));
					},
					highlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().addClass('has-error');
		            },
		            unhighlight: function(ele, errorClass, validClass) {
		            	var $element = pjQ.$(ele);
		            	$element.parent().removeClass('has-error').addClass('has-success');
		            },
		            submitHandler: function(form){
		            	self.disableButtons.call(self);
		            	var $message = pjQ.$('#pjTsMessage_' + self.opts.index);
		            	$message.removeClass('pjTsTitleSuccess pjTsTitleError').html('').parent().parent().hide();
		            	$frmProfile.ajaxSubmit({
		            		success: function(data) {
		            			if(data.status == 'OK')
		            			{
		            				$message.addClass('pjTsTitleSuccess').html(data.text).parent().parent().show();
		            			}
		            			self.enableButtons.call(self);
							}
		            	});
		            	return false;
		            }
				});
			}
		},
		loadContact: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			if(self.opts.post_ticket == 'registered_clients' && self.logged == false)
			{
				hashBang("#!/Login");
			}else{
				self.disableButtons.call(self);
				pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionContact"].join(""), params).done(function (data) {
					self.$container.html(data);
					self.bindContactForm.call(self);
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		},
		loadLogin: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			
			self.disableButtons.call(self);
			pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionLogin"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindLoginForm.call(self);
				self.enableButtons.call(self);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		},
		loadRegister: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			
			self.disableButtons.call(self);
			pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionRegister"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindRegisterForm.call(self);
				self.enableButtons.call(self);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		},
		loadForgot: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			
			self.disableButtons.call(self);
			pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionForgotPassword"].join(""), params).done(function (data) {
				self.$container.html(data);
				self.bindForgotForm.call(self);
				self.enableButtons.call(self);
			}).fail(function () {
				self.enableButtons.call(self);
			});
		},
		loadTickets: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"keyword": this.keyword,
						"session_id": this.opts.session_id
					};
			if(self.logged == false)
			{
				hashBang("#!/Login");
			}else{
				self.disableButtons.call(self);
				pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionIndex"].join(""), params).done(function (data) {
					self.$container.html(data);
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		},
		loadTicket: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"id": self.ticket_id,
						"pjPage": self.page,
						"session_id": this.opts.session_id
					};
			if(self.logged == false)
			{
				hashBang("#!/Login");
			}else{
				self.disableButtons.call(self);
				pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionTicketDetail"].join(""), params).done(function (data) {
					self.$container.html(data);
					self.bindReplyForm.call(self);
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		},
		loadAddTicket: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			if(self.logged == false && self.opts.post_ticket == 'registered_clients')
			{
				hashBang("#!/Login");
			}else{
				self.disableButtons.call(self);
				pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionAddTicket"].join(""), params).done(function (data) {
					self.$container.html(data);
					self.bindAddTicketForm.call(self);
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		},
		loadProfile: function(){
			var self = this,
				index = this.opts.index,
				params = 	{
						"theme": this.opts.theme,
						"locale": this.opts.locale,
						"hide": this.opts.hide,
						"index": this.opts.index,
						"session_id": this.opts.session_id
					};
			if(self.logged == false)
			{
				hashBang("#!/Login");
			}else{
				self.disableButtons.call(self);
				pjQ.$.get([this.opts.folder, "index.php?controller=pjLoad&action=pjActionProfile"].join(""), params).done(function (data) {
					self.$container.html(data);
					self.bindProfileForm.call(self);
					self.enableButtons.call(self);
				}).fail(function () {
					self.enableButtons.call(self);
				});
			}
		}
	};
	
	window.TicketSupport = TicketSupport;	
})(window);