<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdmin extends pjAppController
{
	public $defaultUser = 'admin_user';
	
	public $requireLogin = true;
	
	public function __construct($requireLogin=null)
	{
		$this->setLayout('pjActionAdmin');
		
		if (!is_null($requireLogin) && is_bool($requireLogin))
		{
			$this->requireLogin = $requireLogin;
		}
		
		if ($this->requireLogin)
		{
			if (!$this->isLoged() && !in_array(@$_GET['action'], array('pjActionLogin', 'pjActionForgot', 'pjActionDownloadFile')))
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin");
			}
		}
	}
	
	public function afterFilter()
	{
		parent::afterFilter();
		if ($this->isLoged() && !in_array(@$_GET['action'], array('pjActionLogin')))
		{
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		}
	}
	
	public function beforeRender()
	{
		
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$pjFeedbackModel = pjFeedbackModel::factory();
			
			$info_arr = $pjFeedbackModel->reset()->prepare(sprintf("SELECT 1,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 AND DATE(`TF`.created) = CURDATE() LIMIT 1) AS `feedback_today`,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 LIMIT 1) AS `feedback_received`,
				(SELECT COUNT(DISTINCT email) FROM `%1\$s` WHERE 1 LIMIT 1) AS `unique_users`",
					$pjFeedbackModel->getTable())
			)->exec(array())->getData();
			
			$latest_arr = $pjFeedbackModel
				->reset()
				->select("t1.*, t2.content as product")
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->orderBy("created DESC")
				->limit(3)
				->findAll()
				->getData();
			
			$statistic_arr = $pjFeedbackModel->reset()->prepare(sprintf("SELECT 1,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:suggestion LIMIT 1) AS `suggestions`,
				(SELECT COUNT(DISTINCT email) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:suggestion LIMIT 1) AS `suggestion_users`,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:bug LIMIT 1) AS `bugs`,
				(SELECT COUNT(DISTINCT email) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:bug LIMIT 1) AS `bug_users`,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:compliment LIMIT 1) AS `compliments`,
				(SELECT COUNT(DISTINCT email) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:compliment LIMIT 1) AS `compliment_users`,
				(SELECT COUNT(*) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:complaint LIMIT 1) AS `complaints`,
				(SELECT COUNT(DISTINCT email) FROM `%1\$s` AS `TF` WHERE 1 AND `TF`.`type`=:complaint LIMIT 1) AS `complaint_users`",
					$pjFeedbackModel->getTable())
			)->exec(array('suggestion' => 'suggestion','bug' => 'bug', 'compliment' => 'compliment', 'complaint' => 'complaint'))->getData();
			
			$suggestion_popular = $pjFeedbackModel
				->reset()
				->select("product_id, MIN(t2.content) AS name, COUNT(*) AS cnt")
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('`type`', 'suggestion')
				->groupBy("product_id")
				->orderBy('cnt DESC')
				->limit(1)
				->findAll()->getData();
			
			$bug_popular = $pjFeedbackModel
				->reset()
				->select("product_id, MIN(t2.content) AS name, COUNT(*) AS cnt")
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('`type`', 'bug')
				->groupBy("product_id")
				->orderBy('cnt DESC')
				->limit(1)
				->findAll()->getData();
			
			$compliment_popular = $pjFeedbackModel
				->reset()
				->select("product_id, MIN(t2.content) AS name, COUNT(*) AS cnt")
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('`type`', 'compliment')
				->groupBy("product_id")
				->orderBy('cnt DESC')
				->limit(1)
				->findAll()->getData();
			
			$complaint_popular = $pjFeedbackModel
				->reset()
				->select("product_id, MIN(t2.content) AS name, COUNT(*) AS cnt")
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjSetting' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('`type`', 'complaint')
				->groupBy("product_id")
				->orderBy('cnt DESC')
				->limit(1)
				->findAll()->getData();
			
			$this->set('info_arr', $info_arr);
			$this->set('latest_arr', $latest_arr);
			$this->set('statistic_arr', $statistic_arr);
			
			$this->set('suggestion_popular', $suggestion_popular);
			$this->set('bug_popular', $bug_popular);
			$this->set('compliment_popular', $compliment_popular);
			$this->set('complaint_popular', $complaint_popular);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionForgot()
	{
		$this->setLayout('pjActionAdminLogin');
		
		if (isset($_POST['forgot_user']))
		{
			if (!isset($_POST['forgot_email']) || !pjValidation::pjActionNotEmpty($_POST['forgot_email']) || !pjValidation::pjActionEmail($_POST['forgot_email']))
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=AA10");
			}
			$pjUserModel = pjUserModel::factory();
			$user = $pjUserModel
				->where('t1.email', $_POST['forgot_email'])
				->limit(1)
				->findAll()
				->getData();
				
			if (count($user) != 1)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=AA10");
			} else {
				$user = $user[0];
				
				$Email = new pjEmail();
				$Email
					->setTo($user['email'])
					->setFrom($user['email'])
					->setSubject(__('emailForgotSubject', true));
				
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass'])
						->setSender($this->option_arr['o_smtp_user'])
					;
				}
				
				$body = str_replace(
					array('{Name}', '{Password}'),
					array($user['name'], $user['password']),
					__('emailForgotBody', true)
				);

				if ($Email->send($body))
				{
					$err = "AA11";
				} else {
					$err = "AA12";
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=$err");
			}
		} else {
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdmin.js');
		}
	}
	
	public function pjActionMessages()
	{
		$this->setAjax(true);
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionLogin()
	{
		$this->setLayout('pjActionAdminLogin');
		
		if (isset($_POST['login_user']))
		{
			if (!isset($_POST['login_email']) || !isset($_POST['login_password']) ||
				!pjValidation::pjActionNotEmpty($_POST['login_email']) ||
				!pjValidation::pjActionNotEmpty($_POST['login_password']) ||
				!pjValidation::pjActionEmail($_POST['login_email']))
			{				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=4");
			}
			$pjUserModel = pjUserModel::factory();

			$user = $pjUserModel
				->where('t1.email', $_POST['login_email'])
				->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['login_password']), PJ_SALT))
				->limit(1)
				->findAll()
				->getData();

			if (count($user) != 1)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=1");
			} else {
				$user = $user[0];
				unset($user['password']);
															
				if (!in_array($user['role_id'], array(1,2,3)))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=2");
				}
				
				if ($user['role_id'] == 3 && $user['is_active'] == 'F')
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=2");
				}
				
				if ($user['status'] != 'T')
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=3");
				}
				
				# Login succeed
				$last_login = date("Y-m-d H:i:s");
				if($user['last_login'] == $user['created'])
				{
					$user['last_login'] = date("Y-m-d H:i:s");
				}
    			$_SESSION[$this->defaultUser] = $user;
    			
    			$data = array();
    			$data['last_login'] = $last_login;
    			$pjUserModel->reset()->setAttributes(array('id' => $user['id']))->modify($data);

    			if ($this->isAdmin())
    			{
	    			pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionIndex");
    			}
			}
		} else {
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdmin.js');
		}
	}
	
	public function pjActionLogout()
	{
		if ($this->isLoged())
        {
        	unset($_SESSION[$this->defaultUser]);
        }
       	pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin");
	}
	
	public function pjActionProfile()
	{
		$this->checkLogin();
		
		if (!$this->isAdmin())
		{
			if (isset($_POST['profile_update']))
			{
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel->find($this->getUserId())->getData();
				$data = array();
				$data['role_id'] = $arr['role_id'];
				$data['status'] = $arr['status'];
				$post = array_merge($_POST, $data);
				if (!$pjUserModel->validates($post))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionProfile&err=AA14");
				}
				$pjUserModel->set('id', $this->getUserId())->modify($post);
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionProfile&err=AA13");
			} else {
				$this->set('arr', pjUserModel::factory()->find($this->getUserId())->getData());
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdmin.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionDownloadFile()
	{
		$id = $_GET['id'];
		$arr = pjFileModel::factory()->find($id)->getData();
		if(!empty($arr))
		{
			if($arr['hash'] == $_GET['hash'])
			{
				pjToolkit::chunckedDownload(PJ_INSTALL_PATH . $arr['file_path'], $arr['mime_type'], $arr['file_name']);
			}
		}
		exit;
	}
}
?>