<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat feedback">
				<div class="info">
					<abbr><?php echo $tpl['info_arr'][0]['feedback_today'];?></abbr>
					<?php $tpl['info_arr'][0]['feedback_today'] != 1 ? __('dash_feedbacks_today') : __('dash_feedback_today');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat feedback">
				<div class="info">
					<abbr><?php echo $tpl['info_arr'][0]['feedback_received'];?></abbr>
					<?php $tpl['info_arr'][0]['feedback_received'] != 1 ? __('dash_feedbacks_received') : __('dash_feedback_received');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat users">
				<div class="info">
					<abbr><?php echo $tpl['info_arr'][0]['unique_users'];?></abbr>
					<?php $tpl['info_arr'][0]['unique_users'] != 1 ? __('dash_unique_users') : __('dash_unique_user');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_feedback');?></div>
			<div class="dashboard_column_top"><?php __('dash_statistic');?></div>
			<div class="dashboard_column_top"><?php __('dash_most_popular');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_arr']) > 0)
					{
						$types = __('types', true);
						foreach($tpl['latest_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label class="fs13 bold"><?php echo pjSanitize::html($v['product'])?></label>							
								<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo $types[$v['type']];?></a></label>
								<label><?php __('dash_by')?> <?php echo pjSanitize::html($v['name'])?></label>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['created']))?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_feedback_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['statistic_arr']) > 0)
					{
						$types = pjUtil::sortArrayByArray(__('types', true), array('suggestion','bug','compliment', 'complaint'));
						foreach($types as $k => $v)
						{
							?>
							<div class="dashboard_row">
								<label class="fs13 bold"><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex&type=<?php echo $k;?>"><?php echo $tpl['statistic_arr'][0][$k . 's'];?></a> <?php $tpl['statistic_arr'][0][$k . 's'] != 1 ? __('dash_' . $k . 's') : __('dash_' . $k);?></label>							
								<label><?php __('dash_by')?> <?php echo $tpl['statistic_arr'][0][$k . '_users'];?> <?php $tpl['statistic_arr'][0][$k . '_users'] != 1 ? __('dash_unique_users') : __('dash_unique_user');?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_records_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['suggestion_popular']))
					{ 
						?>
						<div class="dashboard_row">
							<label class="fs13 bold"><?php echo pjSanitize::html($tpl['suggestion_popular'][0]['name']);?></label>		
							<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex&type=suggestion&product_id=<?php echo $tpl['suggestion_popular'][0]['product_id'];?>"><?php echo $tpl['suggestion_popular'][0]['cnt'];?></a> <?php $tpl['suggestion_popular'][0]['cnt'] != 1 ? __('dash_suggestions') : __('dash_suggestion');?></label>							
						</div>
						<?php
					}
					if(!empty($tpl['bug_popular']))
					{
						?>
						<div class="dashboard_row">
							<label class="fs13 bold"><?php echo pjSanitize::html($tpl['bug_popular'][0]['name']);?></label>		
							<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex&type=bug&product_id=<?php echo $tpl['bug_popular'][0]['product_id'];?>"><?php echo $tpl['bug_popular'][0]['cnt'];?></a> <?php $tpl['bug_popular'][0]['cnt'] != 1 ? __('dash_bugs') : __('dash_bug');?></label>							
						</div>
						<?php
					}
					if(!empty($tpl['compliment_popular']))
					{
						?>
						<div class="dashboard_row">
							<label class="fs13 bold"><?php echo pjSanitize::html($tpl['compliment_popular'][0]['name']);?></label>		
							<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex&type=compliment&product_id=<?php echo $tpl['compliment_popular'][0]['product_id'];?>"><?php echo $tpl['compliment_popular'][0]['cnt'];?></a> <?php $tpl['compliment_popular'][0]['cnt'] != 1 ? __('dash_compliments') : __('dash_compliment');?></label>							
						</div>
						<?php
					}
					if(!empty($tpl['complaint_popular']))
					{
						?>
						<div class="dashboard_row">
							<label class="fs13 bold"><?php echo pjSanitize::html($tpl['complaint_popular'][0]['name']);?></label>		
							<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex&type=complaint&product_id=<?php echo $tpl['complaint_popular'][0]['product_id'];?>"><?php echo $tpl['complaint_popular'][0]['cnt'];?></a> <?php $tpl['complaint_popular'][0]['cnt'] != 1 ? __('dash_complaints') : __('dash_complaint');?></label>							
						</div>
						<?php
					}  
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>