<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoAddFeedbackTitle', true, false), __('infoAddFeedbackDesc', true, false)); 
	
	?>
	
	<div class="clear_both">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFeedback&amp;action=pjActionCreate" method="post" id="frmCreateFeedback" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
			<input type="hidden" name="feedback_create" value="1" />
			
			<p>
				<label class="title"><?php __('lblType'); ?></label>
				<span class="inline_block">
					<select name="type" id="type" class="pj-form-field required w200" data-msg-required="<?php __('pj_field_required');?>">
						<?php
						$types = pjUtil::sortArrayByArray(__('types', true), array('suggestion','bug','compliment', 'complaint'));
						foreach ($types as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_invalid');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" class="pj-form-field w250 required" data-msg-required="<?php __('pj_field_required');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblProductService'); ?></label>
				<span class="inline_block">
					<select name="product_id" id="product_id" class="pj-form-field required w300" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['product_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<div class="feedbackBox suggestionBox">
				<p>
					<label class="title"><?php __('lblSuggestionType'); ?></label>
					<span class="inline_block">
						<select name="suggestion_type_id" id="suggestion_type_id" class="pj-form-field w200 fakeRequired" data-msg-required="<?php __('pj_field_required');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['type_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea id="suggestion_description" name="suggestion_description" class="pj-form-field w500 h100 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"></textarea>
					</span>
				</p>
			</div>
			<div class="feedbackBox bugBox">
				<p>
					<label class="title"><?php __('lblBugVersion'); ?></label>
					<span class="inline_block">
						<input type="text" name="bug_version" id="bug_version" class="pj-form-field w250 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea id="bug_description" name="bug_description" class="pj-form-field w500 h100 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"></textarea>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblStepsToReproduce'); ?></label>
					<span class="inline_block">
						<textarea id="bug_steps" name="bug_steps" class="pj-form-field w500 h100 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"></textarea>
					</span>
				</p>
			</div>
			<div class="feedbackBox fileBox">
				<p>
					<label class="title"><?php __('lblFiles'); ?></label>
					<span class="inline_block">
						<input name="files[]" type="file" multiple="multiple" class="pj-form-field w350" data-msg-required="<?php __('pj_field_required'); ?>" data-msg-extension="<?php __('lblExtensionMessage');?>"/>
					</span>
				</p>
			</div>
			<div class="feedbackBox complimentBox">
				<p>
					<label class="title"><?php __('lblSendComplimentTo'); ?></label>
					<span class="inline_block">
						<select name="compliment_send_id" id="compliment_send_id" class="pj-form-field w200 fakeRequired" data-msg-required="<?php __('pj_field_required');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['send_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblTestimonials'); ?></label>
					<span class="inline_block">
						<textarea id="compliment_testimonials" name="compliment_testimonials" class="pj-form-field w500 h100 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"></textarea>
					</span>
				</p>
			</div>
			<div class="feedbackBox complaintBox">
				<p>
					<label class="title"><?php __('lblComplaintFrom'); ?></label>
					<span class="inline_block">
						<select name="complaint_from_id" id="complaint_from_id" class="pj-form-field w200 fakeRequired" data-msg-required="<?php __('pj_field_required');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['from_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblReasonToComplaint'); ?></label>
					<span class="inline_block">
						<input type="text" name="complaint_reason" id="complaint_reason" class="pj-form-field w400 fakeRequired" data-msg-required="<?php __('pj_field_required');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblWhatToImprove'); ?></label>
					<span class="inline_block">
						<textarea id="complaint_improve" name="complaint_improve" class="pj-form-field w500 h100" data-msg-required="<?php __('pj_field_required');?>"></textarea>
					</span>
				</p>
			</div>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFeedback&action=pjActionIndex';" />
				</span>
			</p>
		</form>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	myLabel.allowed_extension = "<?php echo $tpl['option_arr']['o_file_allowed']; ?>";
	</script>
	<?php
}
?>