<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		$bodies_text = str_replace("{MAXSIZE}", ini_get('upload_max_filesize'), $bodies_text);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	pjUtil::printNotice(__('infoFeedbackTitle', true, false), __('infoFeedbackDesc', true, false));
	?>
	
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminFeedback" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddFeedback'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll'); ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<?php
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	
	<div class="pj-form-filter-advanced" style="display: none;">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="overflow float_left w300">
				<p>
					<label class="title100"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="type" id="search_type" class="pj-form-field w150">
							<option value="">-- <?php __('lblAll'); ?>--</option>
							<?php
							$types = pjUtil::sortArrayByArray(__('types', true), array('suggestion','bug','compliment', 'complaint'));
							foreach ($types as $k => $v)
							{
								?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title100"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" name="name" id="name" class="pj-form-field w150" />
					</span>
				</p>
				<p>
					<label class="title100">&nbsp;</label>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="overflow float_left">
				<p>
					<label class="title100"><?php __('lblProductService'); ?></label>
					<span class="inline_block">
						<select name="product_id" id="search_product_id" class="pj-form-field w250">
							<option value="">-- <?php __('lblAll'); ?>--</option>
							<?php
							foreach ($tpl['product_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title100"><?php __('lblDateTime'); ?></label>
					<span class="block float_left">
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="from_date" class="pj-form-field pointer w80 datepicker" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</span>
					<span class="block float_left t6 r5 l5"><?php __('lblTo');?></span>
					<span class="block float_left">
						<span class="pj-form-field-custom pj-form-field-custom-after">
							<input type="text" name="to_date" class="pj-form-field pointer w80 datepicker" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
							<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
						</span>
					</span>
				</p>
			</div>
			<br class="clear_both" />
		</form>
	</div>
	
	<div id="grid"></div>
		
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['setting_id']) && (int) $_GET['setting_id'] > 0)
	{
		?>pjGrid.queryString += "&setting_id=<?php echo (int) $_GET['setting_id']; ?>";<?php
	}
	if (isset($_GET['type']) && in_array($_GET['type'], array('suggestion', 'bug', 'compliment', 'complaint')))
	{
		?>pjGrid.queryString += "&type=<?php echo $_GET['type']; ?>";<?php
	}
	if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
	{
		?>pjGrid.queryString += "&product_id=<?php echo (int) $_GET['product_id']; ?>";<?php
	}
	if (isset($_GET['email']) && !empty($_GET['email']))
	{
		?>pjGrid.queryString += "&email=<?php echo $_GET['email']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.name = "<?php __('lblName'); ?> & <?php __('email'); ?>";
	myLabel.type = "<?php __('lblType'); ?>";
	myLabel.product = "<?php __('lblProductService'); ?>";
	myLabel.datetime = "<?php __('lblDateTime'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>