<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	pjUtil::printNotice(__('infoReportsTitle', true, false), __('infoReportsDesc', true, false));
	?>
	<?php
	$types = __('types', true);
	$setting_types = __('setting_types', true);
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminReports" />
			<input type="hidden" name="action" value="pjActionIndex" />
			<span class="block float_left r10" style="margin-top: 6px;"><?php __('lblFilter');?></span>
			<select name="type" id="type" class="pj-form-field w200">
				<option value="">-- <?php __('lblAll'); ?>--</option>
				<?php
				foreach ($setting_types as $k => $v)
				{
					?><option value="<?php echo $k; ?>"<?php echo isset($_GET['type']) ? ($_GET['type'] == $k ? ' selected="selected"' : NULL) : NULL;?>><?php echo $v; ?></option><?php
				}
				?>
			</select>
		</form>
		<br class="clear_both" />
	</div>
	
	<table class="pj-table" cellspacing="2" cellpadding="5" style="width: 100%">
		<thead>
			<tr>
				<th><?php __('lblType');?></th>
				<th><?php __('lblName');?></th>
				<th style="width: 80px;"><?php echo $types['suggestion'];?></th>
				<th style="width: 80px;"><?php echo $types['bug'];?></th>
				<th style="width: 80px;"><?php echo $types['compliment'];?></th>
				<th style="width: 80px;"><?php echo $types['complaint'];?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach($tpl['setting_arr'] as $k => $v)
			{
				?>
				<tr>
					<td><?php echo $setting_types[$v['type']]; ?></td>
					<td><?php echo pjSanitize::html($v['name']); ?></td>
					<?php
					if((int) $v['suggestions'] > 0)
					{ 
						?><td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFeedback&amp;action=pjActionIndex&amp;setting_id=<?php echo $v['id'];?>&amp;type=suggestion"><?php echo pjSanitize::html($v['suggestions']); ?></a></td><?php
					}else{
						?><td><?php echo pjSanitize::html($v['suggestions']); ?></td><?php
					}
					if((int) $v['bugs'] > 0)
					{ 
						?><td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFeedback&amp;action=pjActionIndex&amp;setting_id=<?php echo $v['id'];?>&amp;type=bug"><?php echo pjSanitize::html($v['bugs']); ?></a></td><?php
					}else{
						?><td><?php echo pjSanitize::html($v['bugs']); ?></td><?php
					}
					if((int) $v['compliments'] > 0)
					{
						?><td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFeedback&amp;action=pjActionIndex&amp;setting_id=<?php echo $v['id'];?>&amp;type=compliment"><?php echo pjSanitize::html($v['compliments']); ?></a></td><?php
					}else{
						?><td><?php echo pjSanitize::html($v['compliments']); ?></td><?php
					}
					if((int) $v['complaints'] > 0)
					{
						?><td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFeedback&amp;action=pjActionIndex&amp;setting_id=<?php echo $v['id'];?>&amp;type=complaint"><?php echo pjSanitize::html($v['complaints']); ?></a></td><?php
					}else{
						?><td><?php echo pjSanitize::html($v['complaints']); ?></td><?php
					}
					?>
				</tr>
				<?php
			} 
			?>
		</tbody>
	</table>
	<?php
}
?>