DROP TABLE IF EXISTS `survey_fields`;
CREATE TABLE IF NOT EXISTS `survey_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_multi_lang`;
CREATE TABLE IF NOT EXISTS `survey_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_options`;
CREATE TABLE IF NOT EXISTS `survey_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_roles`;
CREATE TABLE IF NOT EXISTS `survey_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys`;
CREATE TABLE IF NOT EXISTS `survey_surveys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `available_to` enum('everyone','users') DEFAULT 'everyone',
  `time_to_complete` int(10) DEFAULT NULL,
  `registration_required` enum('begin','end','anonymous') DEFAULT 'anonymous',
  `questions_per_page` int(10) DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_answers`;
CREATE TABLE IF NOT EXISTS `survey_surveys_answers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question_id` int(10) DEFAULT NULL,
  `add_open_answer` enum('T','F') DEFAULT 'F',
  `checked_by_default` enum('T','F') DEFAULT 'F',
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_available_users`;
CREATE TABLE IF NOT EXISTS `survey_surveys_available_users` (
  `survey_id` int(10) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_form_fields`;
CREATE TABLE IF NOT EXISTS `survey_surveys_form_fields` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_questions`;
CREATE TABLE IF NOT EXISTS `survey_surveys_questions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `survey_id` int(10) DEFAULT NULL,
  `is_required` enum('T','F') DEFAULT NULL,
  `type` enum('multi','single','open') DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  `created` datetime DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `lft` int(10) unsigned DEFAULT NULL,
  `rgt` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_user_details`;
CREATE TABLE IF NOT EXISTS `survey_surveys_user_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `survey_user_id` int(10) DEFAULT NULL,
  `survey_id` int(10) DEFAULT NULL,
  `question_id` int(10) DEFAULT NULL,
  `answer_id` int(10) DEFAULT NULL,
  `open_answer` text,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `survey_surveys_users`;
CREATE TABLE IF NOT EXISTS `survey_surveys_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(12) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  `survey_id` int(10) DEFAULT NULL,
  `dt_start_survey` datetime DEFAULT NULL,
  `dt_end_survey` datetime DEFAULT NULL,
  `theme` varchar(255) DEFAULT NULL,
  `locale_id` int(10) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `survey_users`;
CREATE TABLE IF NOT EXISTS `survey_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  `address` mediumtext,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country_id` int(10) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `age` smallint(3) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` enum('F','M','O') DEFAULT NULL,
  `education` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


INSERT INTO `survey_roles` (`id`, `role`, `status`) VALUES
(2, 'user', 'T');


INSERT INTO `survey_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 7, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL),
(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 1, NULL),
(1, 'o_email_account_subject', 2, '', NULL, 'string', 1, 1, NULL),
(1, 'o_email_account_message', 2, '', NULL, 'text', 2, 1, NULL),
(1, 'o_email_forgot_subject', 2, '', NULL, 'string', 3, 1, NULL),
(1, 'o_email_forgot_message', 2, '', NULL, 'text', 4, 1, NULL);

INSERT INTO `survey_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjOption', 1, 'o_email_account_subject', 'Your account details', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_account_message', 'You''ve just created account.<br/><br/>Name: {Name}<br/>nEmail: {Email}<br/>Password: {Password}<br/>Phone: {Phone}<br/>Address: {Address}<br/>Country: {Country}<br/>State: {State}<br/>City: {City}<br/>Zip: {Zip}<br/>Company: {Company}<br/>Age: {Age}<br/>Birthday: {Birthday}<br/>Gender: {Gender}<br/>Education: {Education}<br/>Job Title: {JobTitle}<br/><br/>Thanks!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Password Recovery', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', 'You''ve just sent a request for password recovery. Below is your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks!', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_account_subject', 'Your account details', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_account_message', 'You''ve just created account.<br/><br/>Name: {Name}<br/>Email: {Email}<br/>Password: {Password}<br/>Phone: {Phone}<br/>Address: {Address}<br/>Country: {Country}<br/>State: {State}<br/>City: {City}<br/>Zip: {Zip}<br/>Company: {Company}<br/>Age: {Age}<br/>Birthday: {Birthday}<br/>Gender: {Gender}<br/>Education: {Education}<br/>Job Title: {JobTitle}<br/><br/>Thanks!', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_forgot_subject', 'Password Recovery', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_forgot_message', 'You''ve just sent a request for password recovery. Below is your password:<br/><br/>Password: {Password}<br/><br/>Thanks!', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_account_subject', 'Your account details', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_account_message', 'You''ve just created account.<br/><br/>Name: {Name}\r\nEmail: {Email}<br/>Password: {Password}<br/>Phone: {Phone}<br/>nAddress: {Address}<br/>Country: {Country}<br/>nState: {State}<br/>City: {City}<br/>Zip: {Zip}<br/>Company: {Company}<br/>Age: {Age}<br/>Birthday: {Birthday}<br/>Gender: {Gender}<br/>Education: {Education}<br/>Job Title: {JobTitle}<br/><br/>Thanks!', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_forgot_subject', 'Password Recovery', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_forgot_message', 'You''ve just sent a request for password recovery. Below is your password:<br/><br/>Password: {Password}<br/><br/>Thanks!', 'data');


INSERT INTO `survey_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');

INSERT INTO `survey_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(119, 'addLocale', 'backend', 'Add language', 'script', NULL),
(120, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(121, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(122, 'backend', 'backend', 'Backend titles', 'script', NULL),
(123, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(124, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(125, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(126, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(127, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(128, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(129, 'btnLogin', 'backend', 'Login', 'script', NULL),
(130, 'btnReset', 'backend', 'Reset', 'script', NULL),
(131, 'btnSave', 'backend', 'Save', 'script', NULL),
(132, 'btnSearch', 'backend', 'Search', 'script', NULL),
(133, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(134, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(135, 'created', 'backend', 'Created', 'script', NULL),
(136, 'email', 'backend', 'E-Mail', 'script', NULL),
(137, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(138, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(139, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(140, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(141, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(142, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(143, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(144, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(145, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(146, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(147, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(148, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(149, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(150, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(151, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(152, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(153, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(154, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(155, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(156, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(157, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(158, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(159, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(160, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(161, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(162, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(163, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(164, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(165, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(166, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(167, 'lblDays', 'backend', 'Days', 'script', NULL),
(168, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(169, 'lblError', 'backend', 'Error', 'script', NULL),
(170, 'lblExport', 'backend', 'Export', 'script', NULL),
(171, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(172, 'lblIp', 'backend', 'IP address', 'script', NULL),
(173, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(174, 'lblName', 'backend', 'Name', 'script', NULL),
(175, 'lblNo', 'backend', 'No', 'script', NULL),
(176, 'lblOption', 'backend', 'Option', 'script', NULL),
(177, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(178, 'lblRole', 'backend', 'Role', 'script', NULL),
(179, 'lblStatus', 'backend', 'Status', 'script', NULL),
(180, 'lblType', 'backend', 'Type', 'script', NULL),
(181, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(182, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(183, 'lblValue', 'backend', 'Value', 'script', NULL),
(184, 'lblYes', 'backend', 'Yes', 'script', NULL),
(185, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(186, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(187, 'locales', 'backend', 'Languages', 'script', NULL),
(188, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(189, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(190, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(191, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(192, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(193, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(194, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(195, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(196, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(197, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(198, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(199, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(200, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(201, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(202, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(203, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(204, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(205, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(206, 'opt_o_send_email', 'backend', 'Options / Email sending method', 'script', NULL),
(207, 'opt_o_smtp_host', 'backend', 'Options / SMTP Host', 'script', NULL),
(208, 'opt_o_smtp_port', 'backend', 'Options / SMTP Port', 'script', NULL),
(209, 'opt_o_smtp_user', 'backend', 'Options / SMTP Username', 'script', NULL),
(210, 'opt_o_smtp_pass', 'backend', 'Options / SMTP Password', 'script', NULL),
(211, 'pass', 'backend', 'Password', 'script', NULL),
(212, 'pec_active', 'backend', 'Active', 'script', NULL),
(213, 'pec_delete_selected', 'backend', 'Delete selected', 'script', NULL),
(214, 'pec_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(215, 'pec_inactive', 'backend', 'Inactive', 'script', NULL),
(216, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(217, 'url', 'backend', 'URL', 'script', NULL),
(218, 'user', 'backend', 'Username', 'script', NULL),
(219, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(220, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(221, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(222, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(223, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(224, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(225, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(226, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(227, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(228, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(229, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(230, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(231, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(232, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(233, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(234, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(235, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(236, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(237, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(238, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(239, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(240, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(241, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(242, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(243, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(244, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(245, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(246, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(247, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(248, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(249, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(250, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(251, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(252, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(253, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(254, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(255, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(256, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(257, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(258, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(259, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(260, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(261, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(262, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(263, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(264, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(265, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(266, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(267, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(268, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(269, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(270, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(271, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(272, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(273, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(274, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(275, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(276, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(277, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(278, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(279, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(280, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(281, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(282, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(283, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(284, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(285, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(286, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(287, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(288, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(289, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(290, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(291, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(292, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(293, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(294, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(295, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(296, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(297, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(298, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(299, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(300, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(301, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(302, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(303, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(304, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(305, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(306, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(307, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(308, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(309, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(310, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(311, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(312, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(313, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(314, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(315, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(316, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(317, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(318, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(319, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(320, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(321, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(322, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(323, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(324, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(325, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(326, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(327, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(328, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(329, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(330, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(331, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(332, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(333, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(334, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(335, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(336, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(337, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(338, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(339, 'menuCalendar', 'backend', 'Menu / Calendar', 'script', NULL),
(340, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(341, 'monthly_each_ARRAY_first', 'arrays', 'montly_each_ARRAY_first', 'script', NULL),
(342, 'monthly_each_ARRAY_second', 'arrays', 'montly_each_ARRAY_second', 'script', NULL),
(343, 'monthly_each_ARRAY_third', 'arrays', 'montly_each_ARRAY_third', 'script', NULL),
(344, 'monthly_each_ARRAY_fourth', 'arrays', 'montly_each_ARRAY_fourth', 'script', NULL),
(345, 'monthly_date_ARRAY_0', 'arrays', 'monthly_date_ARRAY_0', 'script', NULL),
(346, 'monthly_date_ARRAY_1', 'arrays', 'monthly_date_ARRAY_1', 'script', NULL),
(347, 'monthly_date_ARRAY_2', 'arrays', 'monthly_date_ARRAY_2', 'script', NULL),
(348, 'monthly_date_ARRAY_3', 'arrays', 'monthly_date_ARRAY_3', 'script', NULL),
(349, 'monthly_date_ARRAY_4', 'arrays', 'monthly_date_ARRAY_4', 'script', NULL),
(350, 'monthly_date_ARRAY_5', 'arrays', 'monthly_date_ARRAY_5', 'script', NULL),
(351, 'monthly_date_ARRAY_6', 'arrays', 'monthly_date_ARRAY_6', 'script', NULL),
(352, 'monthly_date_ARRAY_8', 'arrays', 'monthly_date_ARRAY_8', 'script', NULL),
(353, 'monthly_date_ARRAY_9', 'arrays', 'monthly_date_ARRAY_9', 'script', NULL),
(354, 'monthly_date_ARRAY_10', 'arrays', 'monthly_date_ARRAY_10', 'script', NULL),
(355, 'monthly_date_ARRAY_11', 'arrays', 'monthly_date_ARRAY_11', 'script', NULL),
(356, 'monthly_date_ARRAY_12', 'arrays', 'monthly_date_ARRAY_12', 'script', NULL),
(357, 'monthly_date_ARRAY_13', 'arrays', 'monthly_date_ARRAY_13', 'script', NULL),
(358, 'monthly_date_ARRAY_14', 'arrays', 'monthly_date_ARRAY_14', 'script', NULL),
(359, 'monthly_date_ARRAY_15', 'arrays', 'monthly_date_ARRAY_15', 'script', NULL),
(360, 'monthly_date_ARRAY_16', 'arrays', 'monthly_date_ARRAY_16', 'script', NULL),
(361, 'monthly_date_ARRAY_17', 'arrays', 'monthly_date_ARRAY_17', 'script', NULL),
(362, 'monthly_date_ARRAY_18', 'arrays', 'monthly_date_ARRAY_18', 'script', NULL),
(363, 'monthly_date_ARRAY_19', 'arrays', 'monthly_date_ARRAY_19', 'script', NULL),
(364, 'monthly_date_ARRAY_20', 'arrays', 'monthly_date_ARRAY_20', 'script', NULL),
(365, 'monthly_date_ARRAY_21', 'arrays', 'monthly_date_ARRAY_21', 'script', NULL),
(366, 'monthly_date_ARRAY_22', 'arrays', 'monthly_date_ARRAY_22', 'script', NULL),
(367, 'monthly_date_ARRAY_23', 'arrays', 'monthly_date_ARRAY_23', 'script', NULL),
(368, 'monthly_date_ARRAY_24', 'arrays', 'monthly_date_ARRAY_24', 'script', NULL),
(369, 'monthly_date_ARRAY_25', 'arrays', 'monthly_date_ARRAY_25', 'script', NULL),
(370, 'monthly_date_ARRAY_26', 'arrays', 'monthly_date_ARRAY_26', 'script', NULL),
(371, 'monthly_date_ARRAY_27', 'arrays', 'monthly_date_ARRAY_27', 'script', NULL),
(372, 'monthly_date_ARRAY_28', 'arrays', 'monthly_date_ARRAY_28', 'script', NULL),
(373, 'monthly_date_ARRAY_29', 'arrays', 'monthly_date_ARRAY_29', 'script', NULL),
(374, 'monthly_date_ARRAY_30', 'arrays', 'monthly_date_ARRAY_30', 'script', NULL),
(375, 'monthly_date_ARRAY_31', 'arrays', 'monthly_date_ARRAY_31', 'script', NULL),
(376, 'front_label_choose', 'frontend', 'Front Label Choose', 'script', NULL),
(377, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(378, 'lblInstall', 'backend', 'Label Install', 'script', NULL),
(379, 'lblInstallPhp1Title', 'backend', 'Label instruction title', 'script', NULL),
(380, 'lblInstall_1', 'backend', 'Install step 1', 'script', NULL),
(381, 'lblInstall_2', 'backend', 'Step 2', 'script', NULL),
(382, 'lblView', 'backend', 'Label / View', 'script', NULL),
(383, 'lblCSSFile', 'backend', 'Label / CSS file', 'script', NULL),
(384, 'install_view_ARRAY_default', 'arrays', 'install_view_ARRAY_default', 'script', NULL),
(385, 'install_view_ARRAY_list', 'arrays', 'install_view_ARRAY_list', 'script', NULL),
(386, 'install_view_ARRAY_calendar', 'arrays', 'install_view_ARRAY_calendar', 'script', NULL),
(387, 'install_view_ARRAY_monthly', 'arrays', 'install_view_ARRAY_monthly', 'script', NULL),
(388, 'lblInstall_0', 'backend', 'Install / Preparation step', 'script', NULL),
(389, 'lblInstallCSSExplanation', 'backend', 'Label / Install CSS explanation', 'script', NULL),
(390, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(391, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(392, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(393, 'lblUsers', 'backend', 'Label / Users', 'script', NULL),
(394, 'layouts_ARRAY_layout_1', 'arrays', 'layouts_ARRAY_layout_1', 'script', NULL),
(395, 'layouts_ARRAY_layout_2', 'arrays', 'layouts_ARRAY_layout_2', 'script', NULL),
(396, 'layouts_ARRAY_layout_3', 'arrays', 'layouts_ARRAY_layout_3', 'script', NULL),
(397, 'layouts_ARRAY_layout_4', 'arrays', 'layouts_ARRAY_layout_4', 'script', NULL),
(398, 'layouts_ARRAY_layout_5', 'arrays', 'layouts_ARRAY_layout_5', 'script', NULL),
(399, 'pec_delete_confirmation', 'backend', 'pec_delete_confirmation', 'script', NULL),
(400, 'monthly_date_ARRAY_7', 'arrays', 'monthly_date_ARRAY_7', 'script', NULL),
(401, 'day_shortnames_ARRAY_0', 'arrays', 'day_shortnames_ARRAY_0', 'script', NULL),
(402, 'day_shortnames_ARRAY_1', 'arrays', 'day_shortnames_ARRAY_1', 'script', NULL),
(403, 'day_shortnames_ARRAY_2', 'arrays', 'day_shortnames_ARRAY_2', 'script', NULL),
(404, 'day_shortnames_ARRAY_3', 'arrays', 'day_shortnames_ARRAY_3', 'script', NULL),
(405, 'day_shortnames_ARRAY_4', 'arrays', 'day_shortnames_ARRAY_4', 'script', NULL),
(406, 'day_shortnames_ARRAY_5', 'arrays', 'day_shortnames_ARRAY_5', 'script', NULL),
(407, 'day_shortnames_ARRAY_6', 'arrays', 'day_shortnames_ARRAY_6', 'script', NULL),
(408, 'required_field', 'backend', 'Label / This field is required.', 'script', NULL),
(409, 'invalid_email', 'backend', 'Label / Invalid email format.', 'script', NULL),
(410, 'incorrect_captcha', 'backend', 'Label / Captcha does not match.', 'script', NULL),
(411, 'menuSurveys', 'backend', 'Surveys', 'script', NULL),
(412, 'menuCompletedSurveys', 'backend', 'Completed surveys', 'script', NULL),
(413, '_gender_ARRAY_F', 'arrays', '_gender_ARRAY_F', 'script', NULL),
(414, '_gender_ARRAY_M', 'arrays', '_gender_ARRAY_M', 'script', NULL),
(415, '_gender_ARRAY_O', 'arrays', '_gender_ARRAY_O', 'script', NULL),
(416, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(417, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(418, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(419, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(420, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(421, 'infoCreateUserTitle', 'backend', 'Infobox / Add new user', 'script', NULL),
(422, 'infoCreateUserDesc', 'backend', 'Infobox / Add new user', 'script', NULL),
(423, 'user_role_ARRAY_admin', 'arrays', 'user_role_ARRAY_admin', 'script', NULL),
(424, 'user_role_ARRAY_user', 'arrays', 'user_role_ARRAY_user', 'script', NULL),
(425, 'lblSiteTitle', 'backend', 'Title / Site title', 'script', NULL),
(426, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(427, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(428, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(429, 'lblState', 'backend', 'Label / State', 'script', NULL),
(430, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(431, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(432, 'lblCompany', 'backend', 'Label / Company', 'script', NULL),
(433, 'lblAge', 'backend', 'Label / Age', 'script', NULL),
(434, 'lblBirthday', 'backend', 'Label / Birthday', 'script', NULL),
(435, 'lblGender', 'backend', 'Label / Gender', 'script', NULL),
(436, 'lblEducation', 'backend', 'Label / Education', 'script', NULL),
(437, 'lblJobTitle', 'backend', 'Label / Job title', 'script', NULL),
(438, 'lblSurveys', 'backend', 'Surveys', 'script', NULL),
(439, 'lblAddSurvey', 'backend', 'Add Survey', 'script', NULL),
(440, 'lblUpdateSurvey', 'backend', 'Update Survey', 'script', NULL),
(441, 'lblSurveyDetails', 'backend', 'Survey details', 'script', NULL),
(442, 'lblSurveyTitle', 'backend', 'Title', 'script', NULL),
(443, 'lblSurveyDescription', 'backend', 'Description', 'script', NULL),
(444, 'lblSurveyCompletionConfirmation', 'backend', 'Completion confirmation', 'script', NULL),
(445, 'lblSurveyAvailableTo', 'backend', 'Available to', 'script', NULL),
(446, 'lblSurveyTimeToComplete', 'backend', 'Time to complete', 'script', NULL),
(447, 'lblMinutes', 'backend', 'minutes', 'script', NULL),
(448, 'lblSurveyRegistrationRequired', 'backend', 'Registration required', 'script', NULL),
(449, 'lblSurveyQuestionsPerPage', 'backend', 'Questions per page', 'script', NULL),
(450, 'lblSurveyUsers', 'backend', 'Users', 'script', NULL),
(451, '_survey_available_to_ARRAY_everyone', 'arrays', '_survey_available_to_ARRAY_everyone', 'script', NULL),
(452, '_survey_available_to_ARRAY_users', 'arrays', '_survey_available_to_ARRAY_users', 'script', NULL),
(453, '_survey_registration_required_ARRAY_begin', 'arrays', '_survey_registration_required_ARRAY_begin', 'script', NULL),
(454, '_survey_registration_required_ARRAY_end', 'arrays', '_survey_registration_required_ARRAY_end', 'script', NULL),
(455, '_survey_registration_required_ARRAY_anonymous', 'arrays', '_survey_registration_required_ARRAY_anonymous', 'script', NULL),
(456, 'error_titles_ARRAY_ASV01', 'arrays', 'error_titles_ARRAY_ASV01', 'script', NULL),
(457, 'error_titles_ARRAY_ASV03', 'arrays', 'error_titles_ARRAY_ASV03', 'script', NULL),
(458, 'error_titles_ARRAY_ASV04', 'arrays', 'error_titles_ARRAY_ASV04', 'script', NULL),
(459, 'error_titles_ARRAY_ASV08', 'arrays', 'error_titles_ARRAY_ASV08', 'script', NULL),
(460, 'error_bodies_ARRAY_ASV01', 'arrays', 'error_bodies_ARRAY_ASV01', 'script', NULL),
(461, 'error_bodies_ARRAY_ASV03', 'arrays', 'error_bodies_ARRAY_ASV03', 'script', NULL),
(462, 'error_bodies_ARRAY_ASV04', 'arrays', 'error_bodies_ARRAY_ASV04', 'script', NULL),
(463, 'error_bodies_ARRAY_ASV08', 'arrays', 'error_bodies_ARRAY_ASV08', 'script', NULL),
(464, 'lblQuestions', 'backend', 'Questions', 'script', NULL),
(465, 'btnAddSurvey', 'backend', 'Button / + Add survey', 'script', NULL),
(466, 'btnAddQuestion', 'backend', 'Button / + Add question', 'script', NULL),
(467, 'lblQuestion', 'backend', 'Question', 'script', NULL),
(468, 'lblQuestionAdditionalInformation', 'backend', 'Additional information', 'script', NULL),
(469, 'lblQuestionRequired', 'backend', 'Required', 'script', NULL),
(470, 'lblQuestionType', 'backend', 'Type', 'script', NULL),
(471, '_question_type_ARRAY_multi', 'arrays', '_question_type_ARRAY_multi', 'script', NULL),
(472, '_question_type_ARRAY_single', 'arrays', '_question_type_ARRAY_single', 'script', NULL),
(473, '_question_type_ARRAY_open', 'arrays', '_question_type_ARRAY_open', 'script', NULL),
(474, 'btnAddAnswer', 'backend', 'Button / + Add answer', 'script', NULL),
(475, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(476, 'lblQuestionAnswer', 'backend', 'Answer', 'script', NULL),
(477, 'lblQuestionAddOpenAnswer', 'backend', 'Add Open answer', 'script', NULL),
(478, 'lblQuestionAddAnswer', 'backend', 'Add answer', 'script', NULL),
(479, 'btnAddNewAnswer', 'backend', 'Button / + Add new answer', 'script', NULL),
(480, 'lblRegistrationForm', 'backend', 'Registration form', 'script', NULL),
(481, 'error_titles_ARRAY_ASQ01', 'arrays', 'error_titles_ARRAY_ASQ01', 'script', NULL),
(482, 'error_titles_ARRAY_ASQ03', 'arrays', 'error_titles_ARRAY_ASQ03', 'script', NULL),
(483, 'error_titles_ARRAY_ASQ04', 'arrays', 'error_titles_ARRAY_ASQ04', 'script', NULL),
(484, 'error_titles_ARRAY_ASQ08', 'arrays', 'error_titles_ARRAY_ASQ08', 'script', NULL),
(485, 'error_bodies_ARRAY_ASQ01', 'arrays', 'error_bodies_ARRAY_ASQ01', 'script', NULL),
(486, 'error_bodies_ARRAY_ASQ03', 'arrays', 'error_bodies_ARRAY_ASQ03', 'script', NULL),
(487, 'error_bodies_ARRAY_ASQ04', 'arrays', 'error_bodies_ARRAY_ASQ04', 'script', NULL),
(488, 'error_bodies_ARRAY_ASQ08', 'arrays', 'error_bodies_ARRAY_ASQ08', 'script', NULL),
(489, 'opt_o_sf_include_name', 'backend', 'Options / Name', 'script', NULL),
(490, 'opt_o_sf_include_email', 'backend', 'Options / Email', 'script', NULL),
(491, 'opt_o_sf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(492, 'opt_o_sf_include_gender', 'backend', 'Options / Gender', 'script', NULL),
(493, 'opt_o_sf_include_age', 'backend', 'Options / Age', 'script', NULL),
(494, 'opt_o_sf_include_birthday', 'backend', 'Options / Birthday', 'script', NULL),
(495, 'opt_o_sf_include_address', 'backend', 'Options / Address', 'script', NULL),
(496, 'opt_o_sf_include_city', 'backend', 'Options / City', 'script', NULL),
(497, 'opt_o_sf_include_state', 'backend', 'Options / State', 'script', NULL),
(498, 'opt_o_sf_include_country', 'backend', 'Options / Country', 'script', NULL),
(499, 'opt_o_sf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(500, 'opt_o_sf_include_company', 'backend', 'Options / Company', 'script', NULL),
(501, 'opt_o_sf_include_company_name', 'backend', 'Options / Company name', 'script', NULL),
(502, 'opt_o_sf_include_education', 'backend', 'Options / Education', 'script', NULL),
(503, 'opt_o_sf_include_job_title', 'backend', 'Options / Job title', 'script', NULL),
(504, 'lblNotifications', 'backend', 'Notifications', 'script', NULL),
(505, 'lblIntegration', 'backend', 'Integration', 'script', NULL),
(506, 'infoSurveyRegistrationFormTitle', 'backend', 'Info / Registration form', 'script', NULL),
(507, 'infoSurveyRegistrationFormDesc', 'backend', 'Info / Registration form', 'script', NULL),
(508, 'infoEmailNotificationsTitle', 'backend', 'Info / Email notifications', 'script', NULL),
(509, 'infoEmailNotificationsDesc', 'backend', 'Info / Email notifications', 'script', NULL),
(510, 'lblEmailNotifications', 'backend', 'Label / Email notifications', 'script', NULL),
(511, 'email_notification_types_ARRAY_user', 'arrays', 'email_notification_types_ARRAY_user', 'script', NULL),
(512, 'email_notification_types_ARRAY_admin', 'arrays', 'email_notification_types_ARRAY_admin', 'script', NULL),
(513, 'lblSendConfirmationEmail', 'backend', 'Send confirmation email', 'script', NULL),
(514, 'lblConfirmationEmailSubject', 'backend', 'Subject', 'script', NULL),
(515, 'lblConfirmationEmailMessage', 'backend', 'Message', 'script', NULL),
(516, 'lblTokensSupport', 'backend', 'Tokens support', 'script', NULL),
(517, 'lblMessageTokens', 'backend', 'Tokens message', 'script', NULL),
(518, 'infoSurveysTitle', 'backend', 'Infobox / List of surveys', 'script', NULL),
(519, 'infoSurveysDesc', 'backend', 'Infobox / List of surveys', 'script', NULL),
(520, 'infoUpdateSurveyTitle', 'backend', 'Infobox / Update survey', 'script', NULL),
(521, 'infoUpdateSurveyDesc', 'backend', 'Infobox / Update survey', 'script', NULL),
(522, 'infoCreateSurveyTitle', 'backend', 'Infobox / Add new survey', 'script', NULL),
(523, 'infoCreateSurveyDesc', 'backend', 'Infobox / Add new survey', 'script', NULL),
(524, 'lblSurvey', 'backend', 'Label / Survey', 'script', NULL),
(525, 'lblAnswer', 'backend', 'Label / Answer', 'script', NULL),
(526, 'infoSurveyQuestionTitle', 'backend', 'Infobox / Questions', 'script', NULL),
(527, 'infoSurveyQuestionDesc', 'backend', 'Infobox / Questions', 'script', NULL),
(528, 'infoCreateSurveyQuestionTitle', 'backend', 'Infobox / Add new question', 'script', NULL),
(529, 'infoCreateSurveyQuestionDesc', 'backend', 'Infobox / Add new question', 'script', NULL),
(530, 'infoUpdateSurveyQuestionTitle', 'backend', 'Infobox / Update question', 'script', NULL),
(531, 'infoUpdateSurveyQuestionDesc', 'backend', 'Infobox / Update question', 'script', NULL),
(532, 'lblDeleteAnswerConfirmTitle', 'backend', 'Infobox / Delete confirmation', 'script', NULL),
(533, 'lblDeleteAnswerConfirmBody', 'backend', 'Infobox / Delete confirmation', 'script', NULL),
(534, 'lblAll', 'backend', 'All', 'script', NULL),
(535, 'sv_field_required', 'backend', 'This field is required', 'script', NULL),
(536, 'front_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(537, 'front_invalid_email', 'frontend', 'Label / Email is not valid.', 'script', NULL),
(538, 'lblTheme', 'frontend', 'Label / Theme', 'script', NULL),
(539, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(540, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(541, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(542, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(543, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(544, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(545, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(546, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(547, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(548, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(549, 'option_themes_ARRAY_11', 'arrays', 'option_themes_ARRAY_11', 'script', NULL),
(550, 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', NULL),
(551, 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', NULL),
(552, 'lblInstallConfigLocale', 'backend', 'Install / Locale', 'script', NULL),
(553, 'lblInstallConfigHide', 'backend', 'Install / Config hide', 'script', NULL),
(554, 'install_legend', 'backend', 'Install / Legend', 'script', NULL),
(555, 'lblSurveyEmpty', 'backend', 'Label / No survey found', 'script', NULL),
(556, 'lblSurveyInActive', 'backend', 'Label / Survey inactive', 'script', NULL),
(557, 'front_existing_email', 'frontend', 'Label / Existing email', 'script', NULL),
(558, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(559, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(560, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(561, 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL),
(562, 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', NULL),
(563, 'front_messages_ARRAY_6', 'arrays', 'front_messages_ARRAY_6', 'script', NULL),
(564, 'front_messages_ARRAY_7', 'arrays', 'front_messages_ARRAY_7', 'script', NULL),
(565, 'login_messages_ARRAY_100', 'arrays', 'login_messages_ARRAY_100', 'script', NULL),
(566, 'login_messages_ARRAY_101', 'arrays', 'login_messages_ARRAY_101', 'script', NULL),
(567, 'login_messages_ARRAY_102', 'arrays', 'login_messages_ARRAY_102', 'script', NULL),
(568, 'forgot_messages_ARRAY_101', 'arrays', 'forgot_messages_ARRAY_101', 'script', NULL),
(569, 'forgot_messages_ARRAY_100', 'arrays', 'forgot_messages_ARRAY_100', 'script', NULL),
(570, 'forgot_messages_ARRAY_200', 'arrays', 'forgot_messages_ARRAY_200', 'script', NULL),
(571, 'lblLogin', 'backend', 'Label / Login', 'script', NULL),
(572, 'lblLoginDesc', 'backend', 'Label / Login info', 'script', NULL),
(573, 'lblClose', 'backend', 'Label / Close', 'script', NULL),
(574, 'front_email_address_required', 'backend', 'Label / Email is required', 'script', NULL),
(575, 'front_email_not_valid', 'backend', 'Label / Email is invalid', 'script', NULL),
(576, 'front_email_existed', 'backend', 'Label / User with such Email did exists', 'script', NULL),
(577, 'front_password_required', 'backend', 'Label / Password is required', 'script', NULL),
(578, 'front_label_email', 'backend', 'Label / Email', 'script', NULL),
(579, 'front_label_email_desc', 'backend', 'Label / Enter your email address', 'script', NULL),
(580, 'front_label_password', 'backend', 'Label / Password', 'script', NULL),
(581, 'front_label_password_desc', 'backend', 'Label / Enter your password', 'script', NULL),
(582, 'front_btn_login', 'backend', 'Button / Login', 'script', NULL),
(583, 'front_btn_register', 'backend', 'Button / Register', 'script', NULL),
(584, 'front_label_forgot_password', 'backend', 'Label / Forgot your password', 'script', NULL),
(585, 'front_label_create_account', 'backend', 'Label / Create account', 'script', NULL),
(586, 'lblForgotPassword', 'backend', 'Label / Forgot password', 'script', NULL),
(587, 'front_btn_send_password', 'backend', 'Button / Send password', 'script', NULL),
(588, 'lblForgotPasswordDesc', 'backend', 'Label / Forgot password info', 'script', NULL),
(589, 'lblRegisterNow', 'backend', 'Label / Sign Up Now', 'script', NULL),
(590, 'lblRegisterDesc', 'backend', 'Label / Register info', 'script', NULL),
(591, 'front_label_name', 'backend', 'Label / Name', 'script', NULL),
(592, 'front_label_name_desc', 'backend', 'Label / Enter your name', 'script', NULL),
(593, 'front_name_required', 'backend', 'Label / Name is required', 'script', NULL),
(594, 'front_label_phone', 'backend', 'Label / Phone', 'script', NULL),
(595, 'front_label_phone_desc', 'backend', 'Label / Enter your phone', 'script', NULL),
(596, 'front_phone_required', 'backend', 'Label / Phone is required', 'script', NULL),
(597, 'front_label_address', 'backend', 'Label / Address', 'script', NULL),
(598, 'front_label_address_desc', 'backend', 'Label / Enter your address', 'script', NULL),
(599, 'front_address_required', 'backend', 'Label / Address is required', 'script', NULL),
(600, 'front_label_city', 'backend', 'Label / City', 'script', NULL),
(601, 'front_label_city_desc', 'backend', 'Label / Enter your city', 'script', NULL),
(602, 'front_city_required', 'backend', 'Label / City is required', 'script', NULL),
(603, 'front_label_state', 'backend', 'Label / State', 'script', NULL),
(604, 'front_label_state_desc', 'backend', 'Label / Enter your state', 'script', NULL),
(605, 'front_state_required', 'backend', 'Label / State is required', 'script', NULL),
(606, 'front_label_country', 'backend', 'Label / Country', 'script', NULL),
(607, 'front_label_country_desc', 'backend', 'Label / Select country', 'script', NULL),
(608, 'front_country_required', 'backend', 'Label / Country is required', 'script', NULL),
(609, 'front_label_zip', 'backend', 'Label / Zip', 'script', NULL),
(610, 'front_label_zip_desc', 'backend', 'Label / Enter your zip', 'script', NULL),
(611, 'front_zip_required', 'backend', 'Label / State is required', 'script', NULL),
(612, 'front_label_company', 'backend', 'Label / Company', 'script', NULL),
(613, 'front_label_company_desc', 'backend', 'Label / Enter your company', 'script', NULL),
(614, 'front_company_required', 'backend', 'Label / Company is required', 'script', NULL),
(615, 'front_label_age', 'backend', 'Label / Age', 'script', NULL),
(616, 'front_label_age_desc', 'backend', 'Label / Enter your age', 'script', NULL),
(617, 'front_age_required', 'backend', 'Label / Age is required', 'script', NULL),
(618, 'front_label_birthday', 'backend', 'Label / Birthday', 'script', NULL),
(619, 'front_label_day', 'backend', 'Label / Day', 'script', NULL),
(620, 'front_label_month', 'backend', 'Label / Month', 'script', NULL),
(621, 'front_label_year', 'backend', 'Label / Year', 'script', NULL),
(622, 'front_label_gender', 'backend', 'Label / Gender', 'script', NULL),
(623, 'front_label_gender_desc', 'backend', 'Label / Select gender', 'script', NULL),
(624, 'front_gender_required', 'backend', 'Label / Gender is required', 'script', NULL),
(625, 'front_label_education', 'backend', 'Label / Education', 'script', NULL),
(626, 'front_label_education_desc', 'backend', 'Label / Enter your education', 'script', NULL),
(627, 'front_education_required', 'backend', 'Label / Education is required', 'script', NULL),
(628, 'front_label_job_title', 'backend', 'Label / Job title', 'script', NULL),
(629, 'front_label_job_title_desc', 'backend', 'Label / Enter your job title', 'script', NULL),
(630, 'front_job_title_required', 'backend', 'Label / Job title is required', 'script', NULL),
(631, 'front_birthday_required', 'backend', 'Label / Birthday is required', 'script', NULL),
(632, 'opt_o_email_account_subject', 'backend', 'Options / New client account subject', 'script', NULL),
(633, 'opt_o_email_account_message', 'backend', 'Options / New client account message', 'script', NULL),
(634, 'opt_o_email_account_message_text', 'backend', 'Options / New client account message', 'script', NULL),
(635, 'opt_o_email_forgot_subject', 'backend', 'Options / Forgot password subject', 'script', NULL),
(636, 'opt_o_email_forgot_message', 'backend', 'Options / Forgot password message', 'script', NULL),
(637, 'opt_o_email_forgot_message_text', 'backend', 'Options / Forgot password message', 'script', NULL),
(638, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(639, 'infoNotificationsTitle', 'backend', 'Info / Notifications sent to customers', 'script', NULL),
(640, 'infoNotificationsDesc', 'backend', 'Info / Notifications sent to customers', 'script', NULL),
(641, 'client_notify_arr_ARRAY_account', 'arrays', 'client_notify_arr_ARRAY_account', 'script', NULL),
(642, 'client_notify_arr_ARRAY_forgot', 'arrays', 'client_notify_arr_ARRAY_forgot', 'script', NULL),
(643, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(644, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(645, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(646, 'front_questions_empty', 'backend', 'Label / No questions', 'script', NULL),
(647, 'front_label_question', 'backend', 'Label / Question', 'script', NULL),
(648, 'front_label_next', 'backend', 'Label / Next', 'script', NULL),
(649, 'front_label_complete', 'backend', 'Label / Complete', 'script', NULL),
(650, 'front_label_time_left', 'backend', 'Label / Time left', 'script', NULL),
(651, 'front_label_answer_required', 'backend', 'Label / This question is mandatory', 'script', NULL),
(652, 'infoCompletedSurveysTitle', 'backend', 'Infobox / List of surveys', 'script', NULL),
(653, 'infoCompletedSurveysDesc', 'backend', 'Infobox / List of surveys', 'script', NULL),
(654, 'lblUserName', 'backend', 'Label / User name', 'script', NULL),
(655, 'lblDateCompletion', 'backend', 'Label / Date of completion', 'script', NULL),
(656, 'lblTimeCompletion', 'backend', 'Label / Time of completion', 'script', NULL),
(657, 'lblCompletedSurveyTitle', 'backend', 'Label / Survey title', 'script', NULL),
(658, 'lblViewSurveyDetails', 'backend', 'Label / View survey details', 'script', NULL),
(659, 'lblAnonymous', 'backend', 'Label / Anonymous', 'script', NULL),
(660, 'lblCheckedByDefault', 'backend', 'Checked by default', 'script', NULL),
(661, 'front_lable_start_survey', 'backend', 'Start survey', 'script', NULL),
(662, 'install_example_title', 'backend', 'Install / Example', 'script', NULL),
(663, 'install_method_2_hint', 'backend', 'Install / Method 2 (hint)', 'script', NULL),
(664, 'install_method_3', 'backend', 'Install / Method 3', 'script', NULL),
(665, 'install_method_3_hint', 'backend', 'Install / Method 3 (Hint)', 'script', NULL),
(666, 'install_method_2', 'backend', 'Install / Method 2', 'script', NULL),
(667, 'install_method_1', 'backend', 'Install / Method 1', 'script', NULL),
(668, 'install_method_1_hint', 'backend', 'Install / Method 1 (Hint)', 'script', NULL),
(669, 'install_review', 'backend', 'Install / Review', 'script', NULL),
(670, 'install_review_hint', 'backend', 'Install / Review (Hint)', 'script', NULL),
(671, 'install_request', 'backend', 'Install / Request help', 'script', NULL),
(672, 'install_request_hint', 'backend', 'Install / Request help (Hint)', 'script', NULL),
(673, 'install_contact', 'backend', 'Install / Contact Us', 'script', NULL),
(674, 'install_link', 'backend', 'Install / Link', 'script', NULL),
(675, 'install_example_tab_1', 'backend', 'Install / Example Tab 1', 'script', NULL),
(676, 'install_example_tab_2', 'backend', 'Install / Example Tab 2', 'script', NULL),
(677, 'install_example_tab_3', 'backend', 'Install / Example Tab 3', 'script', NULL),
(678, 'lblCompleted', 'backend', 'Label / Completed', 'script', NULL),
(679, '_down', 'backend', 'Label / down', 'script', NULL),
(680, '_up', 'backend', 'Label / up', 'script', NULL),
(681, 'front_messages_ARRAY_8', 'arrays', 'front_messages_ARRAY_8', 'script', NULL),
(682, 'option_survey_form_field_ARRAY_1', 'arrays', 'option_survey_form_field_ARRAY_1', 'script', NULL),
(683, 'option_survey_form_field_ARRAY_2', 'arrays', 'option_survey_form_field_ARRAY_2', 'script', NULL),
(684, 'option_survey_form_field_ARRAY_3', 'arrays', 'option_survey_form_field_ARRAY_3', 'script', NULL),
(685, 'sv_field_digits', 'backend', 'Lable / Please enter only digits.', 'script', NULL),
(686, 'sv_field_email', 'backend', 'Lable / Please enter a valid email address.', 'script', NULL),
(687, 'lblUp', 'backend', 'Label / Up', 'script', NULL),
(688, 'lblDown', 'backend', 'Label / Down', 'script', NULL),
(689, 'gridActionEmptyTitle', 'backend', 'Label / No records selected', 'script', NULL),
(690, 'gridActionEmptyBody', 'backend', 'Label / You need to select at least a single record', 'script', NULL),
(691, 'gridEmptyDate', 'backend', 'Label / (empty date)', 'script', NULL),
(692, 'gridInvalidDate', 'backend', 'Label / (invalid date)', 'script', NULL),
(693, 'sv_select_options', 'backend', 'Label / Select options', 'script', NULL),
(694, 'sv_uncheck_all', 'backend', 'Label / Uncheck all', 'script', NULL),
(695, 'sv_check_all', 'backend', 'Label / Check all', 'script', NULL),
(833, 'front_session_expired', 'frontend', 'Label / Your session has expired', 'script', NULL),
(834, 'lblHours', 'backend', 'Label / hours', 'script', NULL),
(835, 'lblHour', 'backend', 'Label / hour', 'script', NULL),
(836, 'lblMinute', 'backend', 'minute', 'script', NULL),
(837, 'lblSeconds', 'backend', 'Label / seconds', 'script', NULL),
(838, 'lblSecond', 'backend', 'Label / second', 'script', NULL);


INSERT INTO `survey_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 119, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 124, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 152, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Select email sending method', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Host', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Port', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'First', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Second', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Third', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Fourth', 'script'),
(NULL, 345, 'pjField', 1, 'title', '--', 'script'),
(NULL, 346, 'pjField', 1, 'title', '1st', 'script'),
(NULL, 347, 'pjField', 1, 'title', '2nd', 'script'),
(NULL, 348, 'pjField', 1, 'title', '3rd', 'script'),
(NULL, 349, 'pjField', 1, 'title', '4th', 'script'),
(NULL, 350, 'pjField', 1, 'title', '5th', 'script'),
(NULL, 351, 'pjField', 1, 'title', '6th', 'script'),
(NULL, 352, 'pjField', 1, 'title', '8th', 'script'),
(NULL, 353, 'pjField', 1, 'title', '9th', 'script'),
(NULL, 354, 'pjField', 1, 'title', '10th', 'script'),
(NULL, 355, 'pjField', 1, 'title', '11th', 'script'),
(NULL, 356, 'pjField', 1, 'title', '12th', 'script'),
(NULL, 357, 'pjField', 1, 'title', '13th', 'script'),
(NULL, 358, 'pjField', 1, 'title', '14th', 'script'),
(NULL, 359, 'pjField', 1, 'title', '15th', 'script'),
(NULL, 360, 'pjField', 1, 'title', '16th', 'script'),
(NULL, 361, 'pjField', 1, 'title', '17th', 'script'),
(NULL, 362, 'pjField', 1, 'title', '18th', 'script'),
(NULL, 363, 'pjField', 1, 'title', '19th', 'script'),
(NULL, 364, 'pjField', 1, 'title', '20th', 'script'),
(NULL, 365, 'pjField', 1, 'title', '21st', 'script'),
(NULL, 366, 'pjField', 1, 'title', '22nd', 'script'),
(NULL, 367, 'pjField', 1, 'title', '23rd', 'script'),
(NULL, 368, 'pjField', 1, 'title', '24th', 'script'),
(NULL, 369, 'pjField', 1, 'title', '25th', 'script'),
(NULL, 370, 'pjField', 1, 'title', '26th', 'script'),
(NULL, 371, 'pjField', 1, 'title', '27th', 'script'),
(NULL, 372, 'pjField', 1, 'title', '28th', 'script'),
(NULL, 373, 'pjField', 1, 'title', '29th', 'script'),
(NULL, 374, 'pjField', 1, 'title', '30th', 'script'),
(NULL, 375, 'pjField', 1, 'title', '31st', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Please follow these steps to do the installation.', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Step 1: (Optional) Do any customization to have your desired PHP event calendar.', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the event calendar to appear.', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'CSS file', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Default', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'List', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Preparation step: Please do any customization to have your desired PHP event calendar. ', 'script'),
(NULL, 389, 'pjField', 1, 'title', '{DefaultCSS} is the default css file for the layout, but if you want you can save it under a new name, then change the textbox here and use the new file.', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Layout 1', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Layout 2', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Layout 3', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Layout 4', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Layout 5', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 400, 'pjField', 1, 'title', '7th', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Sun', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Mon', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Tue', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Wed', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Thu', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Fri', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Sat', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Captcha does not match.', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Surveys', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Completed surveys', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Female', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Male', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 416, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'See below a list of all users of PHP Survey Script admin area. If you want to add a new user, just click on  "+ Add user". Click on the pencil icon next to the corresponding entry to edit user information.', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Add new user', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new user.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Admin', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'PHP Survey Script', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Birthday', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Gender', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Education', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Job title', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Surveys', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Add Survey', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Update Survey', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Survey details', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Completion confirmation', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Available to', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Time to complete', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Registration required', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Questions per page', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Everyone', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Selected users', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'At the beginning', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'At the end', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Anonymous survey', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Survey updated!', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Survey added!', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Survey failed to add.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Survey not found.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'All the changes made to this survey have been saved.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'All the changes made to this survey have been saved.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'We are sorry, but the survey has not been added.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Survey your looking for is missing.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 465, 'pjField', 1, 'title', '+ Add survey', 'script'),
(NULL, 466, 'pjField', 1, 'title', '+ Add question', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Question', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Additional information', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Required', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Multi answer', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Single answer', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Open answer', 'script'),
(NULL, 474, 'pjField', 1, 'title', '+ Add answer', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Answer', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Open answer', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Add answer', 'script'),
(NULL, 479, 'pjField', 1, 'title', '+ Add new answer', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Registration form', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Question updated!', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Question added!', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Question failed to add.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Question not found.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'All the changes made to this question have been saved.', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'All the changes made to this question have been saved.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'We are sorry, but the question has not been added.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Question your looking for is missing.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Gender', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Birthday', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Education', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Job title', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Integration', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Registration form', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Select the fields that users should fill in on the registration form.', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'You can send automated Email notifications both to Admins and Users. Switch to the respective Email message from the dropdown menu "Email notifications". <br /><br />These tokens will be replaced by the actual User''s details.<br /><br /><label>{SurveyTitle}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Address}</label><label>{City}</label><label>{State}</label><label>{Country}</label><label>{Zip}</label><label>{CompanyName}</label><label>{Age}</label><label>{Birthday}</label><label>{Gender}</label><label>{Education}</label><label>{JobTitle}</label><label>{ViewSurveyURL}</label>', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Email to the user', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Email to the admin', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Send confirmation email', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Tokens support', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'These tokens will be replaced by the actual lead''s data.<br /><br />\r\n<label>{SurveyTitle}</label>\r\n<label>{SurveyStartTime}</label>\r\n<label>{SurveyEndTime}</label>\r\n<label>{Name}</label>\r\n<label>{Email}</label>\r\n<label>{Phone}</label>\r\n<label>{Gender}</label>\r\n<label>{Age}</label>\r\n<label>{Birthday}</label>\r\n<label>{Address}</label>\r\n<label>{City}</label>\r\n<label>{State}</label>\r\n<label>{Country}</label>\r\n<label>{Zip}</label>\r\n<label>{CompanyName}</label>\r\n<label>{Education}</label>\r\n<label>{JobTitle}</label>\r\n<label>{ViewSurveyURL}</label>', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'List of surveys', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Below is a list of all surveys. If you want to add a new survey, just click on "+ Add survey". Click on the pencil icon next to the corresponding entry to edit survey information.', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Update survey', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'You can make any changes to the form below. Just click "Save" to update the survey details.', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Add new survey', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Fill in the form below to add a new survey and click "Save" to create it.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Survey', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Answer', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Questions', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Below is a list of all questions. If you want to add a new question, just click on "+ Add question". Click on the pencil icon next to the corresponding entry to edit question details.', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Add new question', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Fill in the form below with some mandatory fields and click "Save" button to add new question.', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Update question', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update question information.', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Are you sure you want to delete this answer?', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'This field is required', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Theme', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Theme 11', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Installation code', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Copy the code below and paste it on your web page. The survey will then appear on the selected place.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Hide language selector', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Install config', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'No survey found', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'This survey has not been activated', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Your survey is saved.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Survey failed to save', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'User failed to save. Please try again later.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Account has been created. Survey starting...', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Survey failed to save. Data is missing', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Thank you for doing surveys', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Unfortunately. You can not make this survey because of you have not assigned to this survey.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'There is no such account in the system.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Your account is not active yet.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Incorrect password. Please try again.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Your account is not active yet.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'There is no such account in the system.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'The password was sent to your mail box.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. ', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Email is required', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Email is invalid', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'There is an account with email address used. {STAG}Forgot password?{ETAG}', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Password is required', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Enter your email address', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Enter your password', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Forgot your password?', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Create Account', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Send password', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. ', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Sign Up Now', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. ', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Enter your name', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Name is required', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Enter your phone', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Phone is required', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Enter your address', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Address is required', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Enter your city', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'City is required', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Enter your state', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'State is required', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Select country', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Country is required', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Enter your zip', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Zip is required', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Enter your company', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Company is required', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Age', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Enter your age', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Age is required', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Birthday', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Month', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Year', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Gender', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Select gender', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Gender is required', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Education', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Enter your education', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Education is required', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Job title', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Enter your job title', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Job title is required', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Birthday is required', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'New client account subject', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'New client account message', 'script'),
(NULL, 634, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}\r\n{Phone}\r\n{Address}\r\n{Country}\r\n{State}\r\n{City}\r\n{Zip}\r\n{Company}\r\n{Age}\r\n{Birthday}\r\n{Gender}\r\n{Education}\r\n{JobTitle}', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Forgot password subject', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Forgot password message', 'script'),
(NULL, 637, 'pjField', 1, 'title', '<u>Available tokens:</u>\r\n{Name}\r\n{Email}\r\n{Password}', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Using the form below you can create different autoresponder messages. Use the available tokens to personalize your message.', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'New client account email', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Forgot password email', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'No questions found', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Question', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Complete', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Time left', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'This question is mandatory', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Completed surveys', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Below is a list of all surveys that have been completed.', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'User name', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Date of completion', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Time of completion', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Survey title', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'View survey details', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Anonymous', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Checked by default', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Start survey', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Example', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Use the following URL to open and preview your survey.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Insert a link to your survey script', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Copy and paste the code below into your website content and it will open your survey script.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Survey URL', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Embed the script front-end directly into your website', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Copy and paste this code into the web page HTML where you wish the survey script to show.', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Review an example', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'of how to embed the front-end code into your web page', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Request integration help for free', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'We''ll integrate the PHP Survey Script into your website for free.', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Contact Us', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Link', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'JavaScript', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Link', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Completed', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'down', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'up', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Please wait while your survey is being processed...', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Up', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Down', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'You need to select at least a single record', 'script'),
(NULL, 691, 'pjField', 1, 'title', '(empty date)', 'script'),
(NULL, 692, 'pjField', 1, 'title', '(invalid date)', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Select options', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Uncheck all', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Check all', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Your session has expired.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'hour', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'minute', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'seconds', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'second', 'script');
