<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminSurveyQuestions extends pjAdmin
{
	public function __construct() 
	{
		parent::__construct();
		if (!$this->isXHR()) {
			$survey_id = isset($_REQUEST['survey_id']) ? (int)$_REQUEST['survey_id'] : 0;
			$survey_arr = pjSurveyModel::factory()->select('t1.*, t2.content AS `title`')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSurvey' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
					->find($survey_id)->getData();
			if (count($survey_arr) === 0)
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSurveys&action=pjActionIndex&err=ASQ08");
			}
			$this->set('survey_arr', $survey_arr);
		}
	}
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['question_create']))
			{
				$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
				$pjSurveyAnswerModel = pjSurveyAnswerModel::factory();
				$data = array();
				if (isset($_POST['is_required'])) {
					$data['is_required'] = 'T';
				} else {
					$data['is_required'] = 'F';
				}
				
				$_arr = $pjSurveyQuestionModel->select('t1.id')->where('t1.survey_id', $_POST['survey_id'])->where('t1.parent_id', 0)->limit(1)->findAll()->getData();
				$parent_id = $_arr ? $_arr[0]['id'] : 0;
				$id = $pjSurveyQuestionModel->reset()->saveNode(array_merge($_POST, $data), $parent_id);
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ASQ03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjSurveyQuestion', 'data');
					}
					
					if($_POST['type'] != 'open' && isset($_POST['answer_index']))
					{
						$locale_arr = pjLocaleModel::factory()->select('t1.id')
							->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
							->where('t2.file IS NOT NULL')
							->orderBy('t1.sort ASC')->findAll()->getDataPair(null, 'id');
						foreach ($_POST['answer_index'] as $idx => $v){
							$data = array();
							$data['question_id'] = $id;
							$data['add_open_answer'] = isset($_POST['add_open_answer'][$idx]) ? 'T' : 'F';
							$data['checked_by_default'] = isset($_POST['checked_by_default'][$idx]) ? 'T' : 'F';
							$answer_id = $pjSurveyAnswerModel->reset()->setAttributes($data)->insert()->getInsertId();
							if ($answer_id !== false && (int) $answer_id > 0) {
								if (isset($_POST['answer'])) {
									$data_i18n = array();
									foreach ($locale_arr as $locale_id) {
										if (isset($_POST['answer'][$locale_id][$idx])) {
											$data_i18n[$locale_id]['answer'] = $_POST['answer'][$locale_id][$idx];
										}
									}	
									if ($data_i18n) {
										pjMultiLangModel::factory()->saveMultiLang($data_i18n, $answer_id, 'pjSurveyAnswer', 'data');
									}
								}
							}
						}
					}
				} else {
					$err = 'ASQ04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminSurveyQuestions&action=pjActionIndex&survey_id=".$_POST['survey_id']."&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				$this->set('user_arr', pjUserModel::factory()->where('t1.role_id', 2)->orderBy('t1.name ASC')->findAll()->getData());
						
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminSurveyQuestions.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteQuestion()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			
			$arr = $pjSurveyQuestionModel->find($_GET['id'])->getData();
			
			$pjSurveyQuestionModel->deleteNode($_GET['id']);
			$pjSurveyQuestionModel->rebuildTree($arr['parent_id'], 1);
			
			pjMultiLangModel::factory()->where('model', 'pjSurveyQuestion')->where('foreign_id', $_GET['id'])->eraseAll();
			$answer_arr = pjSurveyAnswerModel::factory()->whereIn('question_id', $_GET['id'])->findAll()->getDataPair(null, 'id');
			pjSurveyAnswerModel::factory()->reset()->where('question_id', $_GET['id'])->eraseAll();
			if ($answer_arr) {
				pjMultiLangModel::factory()->reset()->where('model', 'pjSurveyAnswer')->whereIn('foreign_id', $answer_arr)->eraseAll();
			}
			$response['code'] = 200;
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteQuestionBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjSurveyQuestionModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				
				$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
				foreach ($_POST['record'] as $id)
				{
					$pjSurveyQuestionModel->deleteNode($id);
					$arr = $pjSurveyQuestionModel->reset()->find($_GET['id'])->getData();
					$pjSurveyQuestionModel->rebuildTree($arr['parent_id'], 1);
				}
				
				pjMultiLangModel::factory()->where('model', 'pjSurveyQuestion')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				$answer_arr = pjSurveyAnswerModel::factory()->whereIn('t1.question_id', $_POST['record'])->findAll()->getDataPair(null, 'id');
				pjSurveyAnswerModel::factory()->reset()->whereIn('t1.question_id', $_POST['record'])->eraseAll();
				if ($answer_arr) {
					pjMultiLangModel::factory()->reset()->where('model', 'pjSurveyAnswer')->whereIn('foreign_id', $answer_arr)->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionGetQuestion()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			
			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
			
			$cond_arr = array();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$cond_arr['q'] = $q;
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$cond_arr['status'] = $_GET['status'];
			}
			if (isset($_GET['survey_id']) && (int)$_GET['survey_id'] > 0) {
				$cond_arr['survey_id'] = $_GET['survey_id'];
			}
			
			$survey_id = isset($_GET['survey_id']) ? (int)$_GET['survey_id'] : 0;
			
			$_arr = $pjSurveyQuestionModel->select('t1.id')->where('t1.survey_id', $survey_id)->where('t1.parent_id', 0)->limit(1)->findAll()->getData();
			$parent_id = $_arr ? $_arr[0]['id'] : 0;
			$data = $pjSurveyQuestionModel->getNode($this->getLocaleId(), $parent_id, $cond_arr);
			
			$total = count($data);
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array_slice($data, $offset, $rowCount);
				
			$stack = array();
			foreach ($data as $k => $question)
			{
				$data[$k]['up'] = 0;
				$data[$k]['down'] = 0;
				$data[$k]['id'] = (int) $question['data']['id'];
				if (!isset($stack[$question['deep']."|".$question['data']['parent_id']]))
				{
					$stack[$question['deep']."|".$question['data']['parent_id']] = 0;
				}
				$stack[$question['deep']."|".$question['data']['parent_id']] += 1;
				if ($stack[$question['deep']."|".$question['data']['parent_id']] > 1)
				{
					$data[$k]['up'] = 1;
				}
				//FIXME
				if (isset($data[$k + 1]) && $data[$k + 1]['deep'] == $question['deep'] || $stack[$question['deep']."|".$question['data']['parent_id']] < $question['siblings'])
				{
					$data[$k]['down'] = 1;
				}
				$data[$k]['question'] = $question['data']['question'];
				$data[$k]['type'] = $question['data']['type'];
				$data[$k]['is_required'] = $question['data']['is_required'];
				$data[$k]['status'] = $question['data']['status'];
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{	
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminSurveyQuestions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveQuestion()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			if (!in_array($_POST['column'], $pjSurveyQuestionModel->getI18n()))
			{
				$pjSurveyQuestionModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjSurveyQuestion', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['question_update']))
			{
				$data = array();
				if (isset($_POST['is_required'])) {
					$data['is_required'] = 'T';
				} else {
					$data['is_required'] = 'F';
				}
				pjSurveyQuestionModel::factory()->updateNode(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjSurveyQuestion', 'data');
				}
				
				$pjSurveyAnswerModel = pjSurveyAnswerModel::factory();
				if($_POST['type'] != 'open' && isset($_POST['answer_index']))
				{
					$locale_arr = pjLocaleModel::factory()->select('t1.id')
						->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
						->where('t2.file IS NOT NULL')
						->orderBy('t1.sort ASC')->findAll()->getDataPair(null, 'id');
					foreach ($_POST['answer_index'] as $idx => $v){
						$data = array();
						$data['question_id'] = $_POST['id'];
						$data['add_open_answer'] = isset($_POST['add_open_answer'][$idx]) ? 'T' : 'F';
						$data['checked_by_default'] = isset($_POST['checked_by_default'][$idx]) ? 'T' : 'F';
						if (strpos($idx, 'new_') !== false) { 
							$answer_id = $pjSurveyAnswerModel->reset()->setAttributes($data)->insert()->getInsertId();
							if ($answer_id !== false && (int) $answer_id > 0) {
								if (isset($_POST['answer'])) {
									$data_i18n = array();
									foreach ($locale_arr as $locale_id) {
										if (isset($_POST['answer'][$locale_id][$idx])) {
											$data_i18n[$locale_id]['answer'] = $_POST['answer'][$locale_id][$idx];
										}
									}	
									if ($data_i18n) {
										pjMultiLangModel::factory()->saveMultiLang($data_i18n, $answer_id, 'pjSurveyAnswer', 'data');
									}
								}
							}
						} else {
							$pjSurveyAnswerModel->reset()->where('id', $idx)->limit(1)->modifyAll($data);
							if (isset($_POST['answer'])) {
								$data_i18n = array();
								foreach ($locale_arr as $locale_id) {
									if (isset($_POST['answer'][$locale_id][$idx])) {
										$data_i18n[$locale_id]['answer'] = $_POST['answer'][$locale_id][$idx];
									}
								}	
								if ($data_i18n) {
									pjMultiLangModel::factory()->updateMultiLang($data_i18n, $idx, 'pjSurveyAnswer', 'data');
								}
							}
						}
					}
				} else {
					$pjSurveyAnswerModel->where('question_id', $_POST['id'])->eraseAll();
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminSurveyQuestions&action=pjActionIndex&survey_id=".(int)$_POST['survey_id']."&err=ASQ01");
			} else {
				$arr = pjSurveyQuestionModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminSurveyQuestions&action=pjActionIndex&survey_id=".$_GET['survey_id']."&err=ASQ08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjSurveyQuestion');
				$this->set('arr', $arr);
				
				$answer_arr = pjSurveyAnswerModel::factory()->where('t1.question_id', $_GET['id'])->findAll()->getData();
				foreach ($answer_arr as $k => $answer) {
					$answer_arr[$k]['i18n'] = pjMultiLangModel::factory()->getMultiLang($answer['id'], 'pjSurveyAnswer');
				}
				$this->set('answer_arr', $answer_arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminSurveyQuestions.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteAnswer()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjSurveyAnswerModel::factory()->setAttributes(array('id' => $_POST['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjSurveyAnswer')->where('foreign_id', $_POST['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionSetOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			$node = $pjSurveyQuestionModel->find($_POST['id'])->getData();
			if (count($node) > 0)
			{
				$pjSurveyQuestionModel->reset();
				$opts = array();
				switch ($_POST['direction'])
				{
					case 'up':
						$pjSurveyQuestionModel->where('t1.lft <', $node['lft'])->orderBy('t1.lft DESC');
						break;
					case 'down':
						$pjSurveyQuestionModel->where('t1.lft >', $node['lft'])->orderBy('t1.lft ASC');
						break;
				}

				$neighbour = $pjSurveyQuestionModel
					->where('t1.id !=', $node['id'])
					->where('t1.parent_id', $node['parent_id'])
					->limit(1)->findAll()->getData();
				if (count($neighbour) === 1)
				{
					$neighbour = $neighbour[0];
					$pjSurveyQuestionModel->reset()->set('id', $neighbour['id'])->modify(array('lft' => $node['lft'], 'rgt' => $node['rgt']));
					$pjSurveyQuestionModel->reset()->set('id', $node['id'])->modify(array('lft' => $neighbour['lft'], 'rgt' => $neighbour['rgt']));
					$pjSurveyQuestionModel->reset()->rebuildTree($node['parent_id'], 1);
				} else {
					//last one
				}
			}
		}
		exit;
	}
}
?>