<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{
	public $defaultCaptcha = 'pjSurvey_Captcha';
	public $defaultLocale = 'pjSurvey_LocaleId';
	public $defaultClient = 'pjSurvey_Client';
	public $defaultClientSurveyData = 'pjSurvey_Client_Survey_Data';
	
	public function __construct()
	{
		$this->setLayout('pjActionFrontJS');
		self::allowCORS();
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
	
	public function afterFilter()
	{
		$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
			->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')->findAll()->getData();
		
		$this->set('locale_arr', $locale_arr);
	}
	
	public function beforeFilter()
	{
		if (isset($_GET['sid']) && (int)$_GET['sid'] > 0) {
			$this->defaultCaptcha = 'pjSurvey_Captcha_'.(int)$_GET['sid'];
			$this->defaultLocale = 'pjSurvey_LocaleId_'.(int)$_GET['sid'];
			$this->defaultClient = 'pjSurvey_Client_'.(int)$_GET['sid'];
			$this->defaultClientSurveyData = 'pjSurvey_Client_Survey_Data_'.(int)$_GET['sid'];
		}
		
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();
		
		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->pjActionSetLocale($locale_arr[0]['id']);
			}
		}
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			$this->loadSetFields();
		}
		
		$sid = isset($_GET['sid']) ? (int)$_GET['sid'] : 0;
		$pjSurveyModel = pjSurveyModel::factory();
		$pjSurveyUserModel = pjSurveyUserModel::factory();
		if (isset($_GET['uuid']) && !empty($_GET['uuid'])) {
			$survey_user_arr = $pjSurveyUserModel->where('t1.uuid', $_GET['uuid'])->limit(1)->findAll()->getData();
			if ($survey_user_arr) {
				$sid = $survey_user_arr[0]['survey_id'];
			}
		}
		
		$survey_arr = $pjSurveyModel->select('t1.*, t2.content AS `title`, t3.content AS `description`, t4.content AS `completion_confirmation`')
			->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSurvey' AND t2.locale = '".$this->pjActionGetLocale()."' AND t2.field = 'title'", 'left')
			->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjSurvey' AND t3.locale = '".$this->pjActionGetLocale()."' AND t3.field = 'description'", 'left')
			->join('pjMultiLang', "t4.foreign_id = t1.id AND t4.model = 'pjSurvey' AND t4.locale = '".$this->pjActionGetLocale()."' AND t4.field = 'completion_confirmation'", 'left')
			->find($sid)->getData();
		$this->set('survey_arr', $survey_arr);
		$this->survey_arr = $survey_arr;
		
		if ($survey_arr) {
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$count = pjSurveyQuestionModel::factory()->where('t1.survey_id', $survey_arr['id'])->where('t1.status', 'T')->findCount()->getData();
			$row_count = $survey_arr['questions_per_page'];
			$pages = ceil($count / $row_count);
			$offset = ((int) $page - 1) * $row_count;
			$this->pages = $pages;
			$this->offset = $offset;
			$this->page = $page;
			$this->set('pages', $pages);
			$this->set('offset', $offset);
			$this->set('page', $page);
			
			if (!isset($_SESSION[$this->defaultClientSurveyData])) {
				$_SESSION[$this->defaultClientSurveyData] = array();
			}
		}
		$this->survey_id = $sid;
		$this->set('is_client_loggedin', $this->isFrontLogged());
		$this->set('client_id', $this->getClientId());
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
		header("Cache-Control: max-age=3600, private");
		$pjCaptcha = new pjCaptcha(PJ_WEB_PATH . 'obj/Anorexia.ttf', $this->defaultCaptcha . @$_GET['sid'], 6);
		$pjCaptcha->setImage(PJ_IMG_PATH . 'button.png')->init(@$_GET['rand']);
		exit;
	}


	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if ($this->isXHR())
		{
			echo isset($_SESSION[$this->defaultCaptcha . @$_GET['sid']]) && isset($_GET['captcha'])
				&& pjCaptcha::validate($_GET['captcha'], $_SESSION[$this->defaultCaptcha . @$_GET['sid']])
				? '100' : '101';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$theme = isset($_GET['theme']) ? (int)$_GET['theme'] : 1;
		$arr = array(
			array('file' => 'bootstrap.min.css', 'path' => $dm->getPath('bootstrap') . 'css/'),
			array('file' => 'font-awesome.min.css', 'path' => $dm->getPath('font_awesome') . 'css/'),
			array('file' => 'style.css', 'path' => PJ_CSS_PATH, 'media' => 'all'),
			array('file' => "theme$theme.css", 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			$string = FALSE;
			if ($stream = fopen($item['path'] . $item['file'], 'rb'))
			{
				$string = stream_get_contents($stream);
				fclose($stream);
			}
			if ($string !== FALSE)
			{
				echo str_replace(
					array('../img/', '../fonts/glyphicons', '../fonts/fontawesome', '[URL]', "pjWrapper"),
					array(
						PJ_INSTALL_URL . PJ_IMG_PATH,
						PJ_INSTALL_FOLDER . $dm->getPath('bootstrap') . 'fonts/glyphicons',
						PJ_INSTALL_FOLDER . $dm->getPath('font_awesome') . 'fonts/fontawesome',
						PJ_INSTALL_URL,
						"pjWrapperSurvey_" . $theme
					),
					$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		$sid = isset($_GET['sid']) ? (int)$_GET['sid'] : 0;
		$arr = pjSurveyModel::factory()->find($sid)->getData();
		if (!$arr) {
			$this->set('status', 2);
		} elseif ($arr && $arr['status'] == 'F') {
			$this->set('status', 3);
		} elseif ($arr && $arr['status'] == 'T') {
			$this->set('status', 1);
			if(isset($_GET['locale']) && $_GET['locale'] > 0)
			{
				$_SESSION[$this->defaultLocale] = (int) $_GET['locale'];
			}
		}
	}
	
	public function isFrontLogged()
    {
        if (isset($_SESSION[$this->defaultClient]) && count($_SESSION[$this->defaultClient]) > 0)
        {
            return true;
	    }
	    return false;
    }
    
    public function getClientId()
    {
    	return isset($_SESSION[$this->defaultClient]) && array_key_exists('id', $_SESSION[$this->defaultClient]) ? $_SESSION[$this->defaultClient]['id'] : FALSE;
    }
	
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjUserModel = pjUserModel::factory()->where('t1.email', $_GET['email']);
			if ($this->isFrontLogged())
			{
				$pjUserModel->where('t1.id !=', $this->getClientId());
			}
			echo $pjUserModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionLogin()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			
		}
	}
	
	public function pjActionCheckLogin()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			$user = $pjUserModel
				->where('t1.email', $_POST['login_email'])
				->where('t1.email', $_POST['login_email'])
				->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['login_password']), PJ_SALT))
				->limit(1)
				->findAll()
				->getData();

			$resp = array();	
			if (count($user) != 1)
			{
				$user = $pjUserModel
					->reset()
					->where('t1.email', $_POST['login_email'])
					->limit(1)
					->findAll()
					->getData();
				if (count($user) != 1)
				{
					$resp['code'] = 100;
				}else{
					$resp['code'] = 102;
				}
			}else{
				if ($user[0]['status'] != 'T')
				{
					$resp['code'] = 101;
				}else{
					
					if ($this->survey_arr['available_to'] == 'users') {
						$cnt = pjSurveyAvailableUserModel::factory()->where('t1.survey_id', $this->survey_id)->where('t1.user_id', $user[0]['id'])->findCount()->getData();
						if ($cnt == 0) {
							$front_messages = __('front_messages', true, false);
							pjAppController::jsonResponse(array('code' => 103, 'error_code' => 7, 'text' => $front_messages[7]));
							exit;
						}
					}
					
					$last_login = date("Y-m-d H:i:s");
	    			$_SESSION[$this->defaultClient] = $user[0];
	    			
	    			$data = array();
	    			$data['last_login'] = $last_login;
	    			$pjUserModel->reset()->setAttributes(array('id' => $user[0]['id']))->modify($data);
					$resp['code'] = 200;
				}
			}
			pjAppController::jsonResponse($resp);
		}
		exit;
	}
	
	public function pjActionForgot()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			
		}
	}
	
	public function pjActionSendPassword()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			$user = $pjUserModel
				->where('t1.email', $_POST['email'])
				->limit(1)
				->findAll()
				->getData();

			$resp = array();	
			if (count($user) != 1)
			{
				$resp['code'] = 100;
			}else{
				if ($user[0]['status'] != 'T')
				{
					$resp['code'] = 101;
				}else{
					pjFront::pjActionConfirmSend($this->option_arr, $user[0], PJ_SALT, 'forgot');
					$resp['code'] = 200;
				}
			}
			pjAppController::jsonResponse($resp);
		}
		exit;
	}
	
	public function pjActionRegister()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_POST['user_register'])) {
				$pjUserModel = pjUserModel::factory();
				
				$data = array();
				$data['role_id'] = 2;
				$data['ip'] = $_SERVER['REMOTE_ADDR'];
				$data['is_active'] = 'T';
				$c_data = array_merge($_POST, $data);
				$client_id = $pjUserModel
					->reset()
					->setAttributes($c_data)
					->insert()
					->getInsertId();
				if ($client_id !== false && (int) $client_id > 0)
				{
					$user = $pjUserModel->reset()->find($client_id)->getData();
					$code = 100;
					$last_login = date("Y-m-d H:i:s");
	    			$_SESSION[$this->defaultClient] = $user;
	    			
	    			$data = array();
	    			$data['last_login'] = $last_login;
	    			$pjUserModel->reset()->setAttributes(array('id' => $user['id']))->modify($data);
					pjFront::pjActionConfirmSend($this->option_arr, $c_data, PJ_SALT, 'account');
				} else {
					$code = 200;
				}
				pjAppController::jsonResponse(compact('code'));
			}
			$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->pjActionGetLocale()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
			$this->set('country_arr', $country_arr);
								
			$register_form_arr = pjSurveyFormFieldModel::factory()->getPairs($_GET['sid']);
			$this->set('register_form_arr', $register_form_arr);
		}
	}
	
	public function pjActionConfirmSend($option_arr, $data, $salt, $opt)
	{
		$Email = new pjEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$Email
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
			;
		}
		$Email->setContentType('text/html');
		
		$pjMultiLangModel = pjMultiLangModel::factory();
		$_admin_arr = $this->getFromEmailInfo();
		$from_email = $_admin_arr['email'];
				
		$locale_id = isset($data['locale_id']) && (int) $data['locale_id'] > 0 ? (int) $data['locale_id'] : $this->pjActionGetLocale();
		
		if($opt == 'account' || $opt == 'forgot')
		{
			$tokens = pjAppController::getClientTokens($option_arr, $data, PJ_SALT, $this->pjActionGetLocale());
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_'.$opt.'_message')
				->where('t1.foreign_id', $this->getForeignId())
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_'.$opt.'_subject')
				->where('t1.foreign_id', $this->getForeignId())
				->limit(0, 1)
				->findAll()
				->getData();
				
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$Email
					->setTo($data['email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send(pjUtil::textToHtml($message));
			}
		}
		
		if($opt == 'survey') {
			$tokens = pjAppController::getTokens($option_arr, $data, PJ_SALT, $this->pjActionGetLocale());
			$survey_form_arr = pjSurveyFormFieldModel::factory()->getPairs($data['survey_id']);
			
			/* Client */
			if ($survey_form_arr['o_send_confirmation_email_to_user'] == 2 && !empty($data['email'])) {
				$lang_message = $pjMultiLangModel
					->reset()
					->select('t1.*')
					->where('t1.model','pjSurveyForm')
					->where('t1.locale', $locale_id)
					->where('t1.field', 'confirmation_email_message')
					->where('t1.foreign_id', $this->getForeignId())
					->limit(0, 1)
					->findAll()
					->getData();
				$lang_subject = $pjMultiLangModel
					->reset()
					->select('t1.*')
					->where('t1.model','pjSurveyForm')
					->where('t1.locale', $locale_id)
					->where('t1.field', 'confirmation_email_subject')
					->where('t1.foreign_id', $this->getForeignId())
					->limit(0, 1)
					->findAll()
					->getData();
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
					$Email
						->setTo($data['email'])
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
				}
			}
			
			/* Admin */
			if ($survey_form_arr['o_send_confirmation_email_to_admin'] == 2) {
				$lang_message = $pjMultiLangModel
					->reset()
					->select('t1.*')
					->where('t1.model','pjSurveyForm')
					->where('t1.locale', $locale_id)
					->where('t1.field', 'admin_confirmation_email_message')
					->where('t1.foreign_id', $this->getForeignId())
					->limit(0, 1)
					->findAll()
					->getData();
				$lang_subject = $pjMultiLangModel
					->reset()
					->select('t1.*')
					->where('t1.model','pjSurveyForm')
					->where('t1.locale', $locale_id)
					->where('t1.field', 'admin_confirmation_email_subject')
					->where('t1.foreign_id', $this->getForeignId())
					->limit(0, 1)
					->findAll()
					->getData();
					
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
					$Email
						->setTo($from_email)
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
				}
			}
		}
	}
	
	public function pjActionQuestions()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if ($this->survey_arr['available_to'] == 'users') {
				$cnt = pjSurveyAvailableUserModel::factory()->where('t1.survey_id', $this->survey_id)->where('t1.user_id', $this->getClientId())->findCount()->getData();
				if ($cnt == 0) {					
					pjAppController::jsonResponse(array('code' => 100, 'error_code' => 7));
				}
			}
			if($_GET['page'] > 1)
			{
				for($i = 1; $i < $_GET['page']; $i++)
				{
					if(!isset($_SESSION[$this->defaultClientSurveyData]['data'][$i]))
					{
						pjAppController::jsonResponse(array('code' => 101, 'error_code' => 7, 'page' => $i));
					}
				}
			}
			
			if (!isset($_SESSION[$this->defaultClientSurveyData]['dt_start_survey'])) {
				$_SESSION[$this->defaultClientSurveyData]['dt_start_survey'] = date('Y-m-d H:i:s');
			}
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			$pjSurveyAnswerModel = pjSurveyAnswerModel::factory();
			$row_count = $this->survey_arr['questions_per_page'];
			
			$pjSurveyQuestionModel->reset()->select('t1.*, t2.content AS `question`, , t3.content AS `additional_information`')
				->join('pjMultiLang', "t2.model='pjSurveyQuestion' AND t2.foreign_id=t1.id AND t2.field='question' AND t2.locale='".$this->pjActionGetLocale()."'", 'left outer')
				->join('pjMultiLang', "t3.model='pjSurveyQuestion' AND t3.foreign_id=t1.id AND t3.field='additional_information' AND t3.locale='".$this->pjActionGetLocale()."'", 'left outer')
				->where('t1.survey_id', $this->survey_id)
				->where('t1.status', 'T');
			$question_ids_arr = $pjSurveyQuestionModel->orderBy('t1.lft ASC')->limit($row_count, $this->offset)->findAll()->getDataPair(null, 'id');
			$question_arr = $pjSurveyQuestionModel->orderBy('t1.lft ASC')->limit($row_count, $this->offset)->findAll()->getData();
			
			$answer_arr = array();
			if ($question_ids_arr) {
				$_answer_arr = $pjSurveyAnswerModel
					->select('t1.*, t2.content AS `answer`')
					->whereIn('t1.question_id', $question_ids_arr)
					->join('pjMultiLang', "t2.model='pjSurveyAnswer' AND t2.foreign_id=t1.id AND t2.field='answer' AND t2.locale='".$this->pjActionGetLocale()."'", 'left outer')
					->findAll()
					->getData();
				foreach ($_answer_arr as $item) {
					$answer_arr[$item['question_id']][] = $item;
				}
			}
			
			$this->set('question_arr', $question_arr);
			$this->set('answer_arr', $answer_arr);
		}
	}
	
	public function pjActionSaveForm() {
		$this->setAjax(true);
		if ($this->isXHR()) {
			$code = 100;
			if (isset($_POST['page'])) {
				$page = $_POST['page'];
				unset($_POST['page']);
				$_SESSION[$this->defaultClientSurveyData]['data'][$page] = $_POST;
			}
			pjAppController::jsonResponse(compact('code'));
		}
	}
	
	public function pjActionProcessSurvey() {
		$this->setAjax(true);
		if ($this->isXHR()) {
			$code = 100;
			$status = '';
			if (isset($_GET['complete_survey'])) {
				$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();	
				$pjSurveyUserModel = pjSurveyUserModel::factory();
				$pjSurveyUserDetailModel = pjSurveyUserDetailModel::factory();
				
				if (isset($_SESSION[$this->defaultClientSurveyData]['data'])) {
					$data = array();
					$data['ip'] = pjUtil::getClientIp();
					if ($this->isFrontLogged()) {
						$data['user_id'] = $this->getClientId();
					}
					$data['survey_id'] = $this->survey_id;
					$data['dt_start_survey'] = $_SESSION[$this->defaultClientSurveyData]['dt_start_survey'];
					$data['dt_end_survey'] = date('Y-m-d H:i:s');
					$data['theme'] = $_GET['theme'];
					$data['uuid'] = pjUtil::uuid();
					$data['locale_id'] = $this->pjActionGetLocale();
					
					$id = $pjSurveyUserModel->setAttributes($data)->insert()->getInsertId();
					if ($id !== false && (int) $id > 0) {
						$code = 200;
						$status = 6;
						$data_survey = $_SESSION[$this->defaultClientSurveyData]['data'];
						$question_arr = $pjSurveyQuestionModel->reset()->select('t1.id, t1.type')->where('t1.survey_id', $this->survey_id)->findAll()->getData();
						foreach ($question_arr as $question) {
							foreach (range(1, $this->pages) as $i) {		
								$data_details = array();
								$data_details['survey_user_id'] = $id;
								$data_details['survey_id'] = $this->survey_id;
								$data_details['question_id'] = $question['id'];						
								if ($question['type'] == 'multi') {
									if (isset($data_survey[$i]['answer'][$question['id']])) {
										foreach ($data_survey[$i]['answer'][$question['id']] as $answer_id) {
											$data_details['answer_id'] = $answer_id;
											if (isset($data_survey[$i]['open_answer'][$question['id']][$answer_id])) {
												$data_details['open_answer'] = $data_survey[$i]['open_answer'][$question['id']][$answer_id];
											}
											$pjSurveyUserDetailModel->reset()->setAttributes($data_details)->insert();
										}
										break;
									}
								} else {
									if (isset($data_survey[$i]['answer_'.$question['id']])) {
										if ($question['type'] == 'open') {
											$data_details['open_answer'] = $data_survey[$i]['answer_'.$question['id']];
										} elseif ($question['type'] == 'single') {
											$answer_id = $data_survey[$i]['answer_'.$question['id']];
											$data_details['answer_id'] = $answer_id;
											if (isset($data_survey[$i]['open_answer'][$question['id']][$answer_id])) {
												$data_details['open_answer'] = $data_survey[$i]['open_answer'][$question['id']][$answer_id];
											}
										}					
										$pjSurveyUserDetailModel->reset()->setAttributes($data_details)->insert();
										break;
									}
								}
							}
						}
						$survey_user_arr = $pjSurveyUserModel->reset()
							->select('t1.*, t2.email, t2.name, t2.phone, t2.address, t2.city, t2.state, t2.country_id, t2.zip, t2.company_name, t2.age, t2.birthday, t2.gender, t2.education, t2.job_title, t3.content AS `survey_title`')
							->join('pjUser', 't1.user_id=t2.id', 'left outer')
							->join('pjMultiLang', "t3.foreign_id = t1.survey_id AND t3.model = 'pjSurvey' AND t3.locale = '".$this->pjActionGetLocale()."' AND t3.field = 'title'", 'left')
							->find($id)
							->getData();
						pjFront::pjActionConfirmSend($this->option_arr, $survey_user_arr, PJ_SALT, 'survey');
					} else {
						$code = 300;
						$status = 5;
					}
				} else {
					$code = 300;
					$status = 5;
				}
			}
			pjAppController::jsonResponse(compact('code', 'status'));
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
			}
		}
		exit;
	}
	
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	
	public function pjActionReviewSurvey()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$pjSurveyQuestionModel = pjSurveyQuestionModel::factory();
			$pjSurveyAnswerModel = pjSurveyAnswerModel::factory();
			$row_count = $this->survey_arr['questions_per_page'];
			
			$pjSurveyQuestionModel->reset()->select('t1.*, t2.content AS `question`, , t3.content AS `additional_information`')
				->join('pjMultiLang', "t2.model='pjSurveyQuestion' AND t2.foreign_id=t1.id AND t2.field='question' AND t2.locale='".$this->pjActionGetLocale()."'", 'left outer')
				->join('pjMultiLang', "t3.model='pjSurveyQuestion' AND t3.foreign_id=t1.id AND t3.field='additional_information' AND t3.locale='".$this->pjActionGetLocale()."'", 'left outer')
				->where('t1.survey_id', $this->survey_id)
				->where('t1.status', 'T');
			$question_ids_arr = $pjSurveyQuestionModel->orderBy('t1.lft ASC')->limit($row_count, $this->offset)->findAll()->getDataPair(null, 'id');
			$question_arr = $pjSurveyQuestionModel->orderBy('t1.lft ASC')->limit($row_count, $this->offset)->findAll()->getData();
			
			$answer_arr = array();
			if ($question_ids_arr) {
				$_answer_arr = $pjSurveyAnswerModel
					->select('t1.*, t2.content AS `answer`')
					->whereIn('t1.question_id', $question_ids_arr)
					->join('pjMultiLang', "t2.model='pjSurveyAnswer' AND t2.foreign_id=t1.id AND t2.field='answer' AND t2.locale='".$this->pjActionGetLocale()."'", 'left outer')
					->findAll()
					->getData();
				foreach ($_answer_arr as $item) {
					$answer_arr[$item['question_id']][] = $item;
				}
			}
			
			$this->set('question_arr', $question_arr);
			$this->set('answer_arr', $answer_arr);
			
			$pjSurveyUserModel = pjSurveyUserModel::factory();
			$pjSurveyUserDetailModel = pjSurveyUserDetailModel::factory();
			
			$user_survey_detail_arr = array();
			$_user_survey_detail_arr = $pjSurveyUserDetailModel->where('t1.survey_user_id', (int)$_GET['view_user_survey_id'])->findAll()->getData();
			foreach ($_user_survey_detail_arr as $item) {
				if ((int)$item['answer_id'] > 0) {
					$user_survey_detail_arr[$item['question_id']]['answer_id'][] = $item['answer_id'];
					$user_survey_detail_arr[$item['question_id']]['open_answer'][$item['answer_id']] = $item['open_answer'];
				} else {
					$user_survey_detail_arr[$item['question_id']] = $item['open_answer'];
				}
			}
			$this->set('user_survey_detail_arr', $user_survey_detail_arr);
		}
	}
	
	public function pjActionComplete() {
		$this->setAjax(true);
		if ($this->isXHR() || isset($_GET['_escaped_fragment_'])) {
			
			if(empty($_SESSION[$this->defaultClientSurveyData]))
			{
				pjAppController::jsonResponse(array('code' => 100, 'error_code' => 7));
			}
			
			$time_to_complete = $this->survey_arr['time_to_complete'];
			$dt_start_survey = $_SESSION[$this->defaultClientSurveyData]['dt_start_survey'];
			if (strtotime($dt_start_survey) + ($time_to_complete * 60) > time()) {
				foreach (range(1, $this->pages) as $i) 
				{
					if(!isset($_SESSION[$this->defaultClientSurveyData]['data'][$i]))
					{
						pjAppController::jsonResponse(array('code' => 101, 'error_code' => 7, 'page' => $i));
					}
				}
			}
			
			$_SESSION[$this->defaultClientSurveyData] = array();
			$_SESSION[$this->defaultClient] = array();
			unset($_SESSION[$this->defaultClientSurveyData]);
			unset($_SESSION[$this->defaultClient]);
		}
	}
	
	public function pjActionLoadWelcome() {
		$this->setAjax(true);
		if ($this->isXHR() || isset($_GET['_escaped_fragment_'])) {
			
		}
	}
	public function pjActionExpire() {
		$this->setAjax(true);
		if ($this->isXHR() || isset($_GET['_escaped_fragment_'])) {
			$_SESSION[$this->defaultClientSurveyData] = array();
			$_SESSION[$this->defaultClient] = array();
			unset($_SESSION[$this->defaultClientSurveyData]);
			unset($_SESSION[$this->defaultClient]);
		}
	}
}
?>