<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjSurveyModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'surveys';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'available_to', 'type' => 'enum', 'default' => 'everyone'),
		array('name' => 'time_to_complete', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'registration_required', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'questions_per_page', 'type' => 'int', 'default' => '10'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'T'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()')
	);
	
	public $i18n = array('title','description','completion_confirmation');
	
	public static function factory($attr=array())
	{
		return new pjSurveyModel($attr);
	}
}
?>