<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjSurveyFormFieldModel extends pjAppModel
{
	protected $primaryKey = NULL;
	
	protected $table = 'surveys_form_fields';
	
	protected $schema = array(
		array('name' => 'foreign_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'key', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'value', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'label', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'varchar', 'default' => 'string'),
		array('name' => 'order', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'is_visible', 'type' => 'tinyint', 'default' => 1)
	);
	
	public static function factory($attr=array())
	{
		return new pjSurveyFormFieldModel($attr);
	}
	
	public function getAllPairs($foreign_id)
	{
		return $this->where('t1.foreign_id', $foreign_id)->findAll()->getDataPair('key', 'value');
	}
	
	public function getPairs($foreign_id)
	{
		$_arr = $this->where('t1.foreign_id', $foreign_id)->findAll()->getData();
		$arr = array();
		foreach ($_arr as $row)
		{
			switch ($row['type'])
			{
				case 'enum':
					list(, $arr[$row['key']]) = explode("::", $row['value']);
					break;
				default:
					$arr[$row['key']] = $row['value'];
					break;
			}
		}
		return $arr;
	}
	
	function initSurveyForm($survey_id = null, $locale_id = 1) {
		$query = "INSERT INTO `".$this->getTable()."` (`foreign_id`, `key`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES 
		(".(int)$survey_id.", 'o_sf_include_name', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_email', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 0, NULL),
		(".(int)$survey_id.", 'o_sf_include_phone', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),		
		(".(int)$survey_id.", 'o_sf_include_address', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_city', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_state', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_country', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_zip', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_company', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_age', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_birthday', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
		(".(int)$survey_id.", 'o_sf_include_gender', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),	
		(".(int)$survey_id.", 'o_sf_include_education', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),	
		(".(int)$survey_id.", 'o_sf_include_job_title', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),			
		(".(int)$survey_id.", 'o_send_confirmation_email_to_user', '1|2::1', 'No|Yes', 'enum', 15, 0, NULL),
		(".(int)$survey_id.", 'o_send_confirmation_email_to_admin', '1|2::1', 'No|Yes', 'enum', 16, 0, NULL);";
		$this->execute($query);
		
		$data_i18 = array();
		$data_i18[$locale_id]['confirmation_email_subject'] = 'Email notification to the user';
		$data_i18[$locale_id]['confirmation_email_message'] = 'Email notification body';		
		$data_i18[$locale_id]['admin_confirmation_email_subject'] = 'Email notification to the admin';
		$data_i18[$locale_id]['admin_confirmation_email_message'] = 'Email notification body';
		pjMultiLangModel::factory()->saveMultiLang($data_i18, $survey_id, 'pjSurveyForm', 'data');
	}
}
?>