<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	pjUtil::printNotice(__('infoCreateSurveyTitle', true), __('infoCreateSurveyDesc', true)); 
	?>
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
	<div class="multilang"></div>
	<?php endif; ?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSurveys&amp;action=pjActionCreate" method="post" id="frmCreateSurvey" class="form pj-form" autocomplete="off">
		<input type="hidden" name="survey_create" value="1" />
		<?php
		foreach ($tpl['lp_arr'] as $v)
		{
		?>
			<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
				<label class="title"><?php __('lblSurveyTitle'); ?>:</label>
				<span class="inline_block">
					<input type="text" id="i18n_name_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" />
					<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
					<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
					<?php endif; ?>
				</span>
			</p>
			<?php
		}
		foreach ($tpl['lp_arr'] as $v)
		{
		?>
			<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
				<label class="title"><?php __('lblSurveyDescription'); ?></label>
				<span class="inline_block">
					<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h50" lang="<?php echo $v['id']; ?>"></textarea>
					<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
					<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
					<?php endif; ?>
				</span>
			</p>
			<?php
		}
		foreach ($tpl['lp_arr'] as $v)
		{
		?>
			<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
				<label class="title"><?php __('lblSurveyCompletionConfirmation'); ?></label>
				<span class="inline_block">
					<textarea id="i18n_completion_confirmation_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][completion_confirmation]" class="pj-form-field w500 h50" lang="<?php echo $v['id']; ?>"></textarea>
					<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
					<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
					<?php endif; ?>
				</span>
			</p>
			<?php
		}
		?>
		
		<p>
			<label class="title"><?php __('lblSurveyAvailableTo'); ?></label>
			<?php foreach (__('_survey_available_to', true) as $k => $v) { ?>
				<input <?php echo $k == 'everyone' ? 'checked="checked"' : null;?> type="radio" name="available_to" id="available_to_<?php echo $k;?>" value="<?php echo $k;?>" /> <label for="available_to_<?php echo $k;?>" class="pointer r10"><?php echo $v;?></label>
			<?php } ?>
		</p>
		<p class="survey-registration-required">
			<label class="title"><?php __('lblSurveyRegistrationRequired'); ?></label>
			<select name="registration_required" id="registration_required" class="pj-form-field w300">
				<?php foreach (__('_survey_registration_required') as $k => $v) { ?>
					<option value="<?php echo $k;?>"><?php echo $v;?></option>
				<?php } ?>
			</select>
		</p>
		<p class="survey-users" style="display: none;">
			<label class="title"><?php __('lblSurveyUsers'); ?></label>
			<select name="user_id[]" id="user_id" class="pj-form-field w350"  data-placeholder="--<?php __('lblChoose'); ?>--" multiple="multiple">
				<?php foreach ($tpl['user_arr'] as $user) { ?>
					<option value="<?php echo $user['id'];?>"><?php echo pjSanitize::html($user['name']);?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label class="title"><?php __('lblSurveyTimeToComplete'); ?> (<?php __('lblMinutes');?>)</label>
			<input type="text" id="time_to_complete" name="time_to_complete" class="pj-form-field field-int digits w100 required" />
		</p>
		<p>
			<label class="title"><?php __('lblSurveyQuestionsPerPage'); ?></label>
			<input type="text" id="questions_per_page" name="questions_per_page" class="pj-form-field field-int digits w100 required" />
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('u_statarr', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo $k == 'T' ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<span class="inline_block">
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminSurveys&action=pjActionIndex';" />
			</span>
		</p>
	</form>
	
	<script type="text/javascript">
	var pjLocale = pjLocale || {};
	var myLabel = myLabel || {};
	myLabel.install_url = "<?php echo PJ_INSTALL_URL; ?>";
	myLabel.field_required = "<?php __('sv_field_required'); ?>";
	myLabel.field_digits = "<?php __('sv_field_digits'); ?>";
	myLabel.select_options = "<?php __('sv_select_options'); ?>";
	myLabel.uncheck_all = "<?php __('sv_uncheck_all'); ?>";
	myLabel.check_all = "<?php __('sv_check_all'); ?>";
	
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1) : ?>
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	<?php endif; ?>
	</script>
	<?php
}
?>