<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else { ?>
	<h2 class="update-form-header"><?php __('lblSurvey'); ?>: <?php echo pjSanitize::html($tpl['arr']['title']);?></h2>
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) :?>
	<div class="multilang"></div>
	<?php endif; ?>
	
	<div id="tabs">
		<ul>
			<li><a href="#tabs-1"><?php __('lblSurveyDetails'); ?></a></li>
			<li><a href="#tabs-2"><?php __('lblQuestions'); ?></a></li>
			<li><a href="#tabs-3"><?php __('lblRegistrationForm'); ?></a></li>
			<li><a href="#tabs-4"><?php __('lblNotifications'); ?></a></li>
			<li><a href="#tabs-5"><?php __('lblIntegration'); ?></a></li>
		</ul>
		<div id="tabs-1">
			<?php pjUtil::printNotice(__('infoUpdateSurveyTitle', true), __('infoUpdateSurveyDesc', true)); ?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSurveys&amp;action=pjActionUpdate" method="post" id="frmUpdateSurvey" class="form pj-form">
				<input type="hidden" name="survey_update" value="1" />
				<input type="hidden" name="tab_id" value="tabs-1" />
				<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
				<?php
				foreach ($tpl['lp_arr'] as $v)
				{
				?>
					<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<label class="title"><?php __('lblSurveyTitle'); ?>:</label>
						<span class="inline_block">
							<input type="text" id="i18n_name_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]"  value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" />
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif; ?>
						</span>
					</p>
					<?php
				}
				foreach ($tpl['lp_arr'] as $v)
				{
				?>
					<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<label class="title"><?php __('lblSurveyDescription'); ?></label>
						<span class="inline_block">
							<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h50" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif; ?>
						</span>
					</p>
					<?php
				}
				foreach ($tpl['lp_arr'] as $v)
				{
				?>
					<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
						<label class="title"><?php __('lblSurveyCompletionConfirmation'); ?></label>
						<span class="inline_block">
							<textarea id="i18n_completion_confirmation_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][completion_confirmation]" class="pj-form-field w500 h50" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['completion_confirmation'])); ?></textarea>
							<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
							<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
							<?php endif; ?>
						</span>
					</p>
					<?php
				}
				?>
				
				<p>
					<label class="title"><?php __('lblSurveyAvailableTo'); ?></label>
					<?php foreach (__('_survey_available_to', true) as $k => $v) { ?>
						<input <?php echo $k == $tpl['arr']['available_to'] ? 'checked="checked"' : null;?> type="radio" name="available_to" id="available_to_<?php echo $k;?>" value="<?php echo $k;?>" /> <label for="available_to_<?php echo $k;?>" class="pointer r10"><?php echo $v;?></label>
					<?php } ?>
				</p>
				<p class="survey-registration-required" style="display: <?php echo  $tpl['arr']['available_to'] == 'everyone' ? null : 'none';?>">
					<label class="title"><?php __('lblSurveyRegistrationRequired'); ?></label>
					<select name="registration_required" id="registration_required" class="pj-form-field w300">
						<?php foreach (__('_survey_registration_required') as $k => $v) { ?>
							<option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['registration_required'] ? ' selected="selected"' : null; ?>><?php echo $v;?></option>
						<?php } ?>
					</select>
				</p>
				<p class="survey-users" style="display: <?php echo  $tpl['arr']['available_to'] == 'users' ? null : 'none';?>">
					<label class="title"><?php __('lblSurveyUsers'); ?></label>
					<select name="user_id[]" id="user_id" class="pj-form-field w350"  data-placeholder="--<?php __('lblChoose'); ?>--" multiple="multiple">
						<?php foreach ($tpl['user_arr'] as $user) { ?>
							<option value="<?php echo $user['id'];?>" <?php echo in_array($user['id'], $tpl['user_ids_arr']) ? 'selected="selected"' : null;?>><?php echo pjSanitize::html($user['name']);?></option>
						<?php } ?>
					</select>
				</p>
				<p>
					<label class="title"><?php __('lblSurveyTimeToComplete'); ?> (<?php __('lblMinutes');?>)</label>
					<input type="text" id="time_to_complete" name="time_to_complete" value="<?php echo (int)$tpl['arr']['time_to_complete'];?>" class="pj-form-field field-int digits w100 required" />
				</p>
				<p>
					<label class="title"><?php __('lblSurveyQuestionsPerPage'); ?></label>
					<input type="text" id="questions_per_page" name="questions_per_page" value="<?php echo (int)$tpl['arr']['questions_per_page'];?>" class="pj-form-field field-int digits w100 required" />
				</p>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : null; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminSurveys&action=pjActionIndex';" />
					</span>
				</p>
			</form>
		</div>
		<div id="tabs-2">
			
		</div>
		
		<div id="tabs-3">
			<?php pjUtil::printNotice(__('infoSurveyRegistrationFormTitle', true), __('infoSurveyRegistrationFormDesc', true)); ?>
			<?php 
				$count = count($tpl['survey_form_field_arr']) - 1;
				if ($count > 0)
				{
					?>
					<div class="clear_both">
						<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSurveys&amp;action=pjActionUpdate" method="post" class="form pj-form">
							<input type="hidden" name="options_update" value="1" />
							<input type="hidden" name="tab_id" value="tabs-3" />
							<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
							<table class="pj-table b10" cellpadding="0" cellspacing="0" style="width: 100%">
								<thead>
									<tr>
										<th><?php __('lblOption'); ?></th>
										<th><?php __('lblValue'); ?></th>
									</tr>
								</thead>
								<tbody>
					
								<?php
								$option_survey_form_field_arr = __('option_survey_form_field', true);
								for ($i = 0; $i <= $count; $i++)
								{			
									if ($tpl['survey_form_field_arr'][$i]['is_visible'] == 0) {
										continue;
									}					
									?>
									<tr class="pj-table-row-odd">
										<td width="30%">
											<?php __('opt_' . $tpl['survey_form_field_arr'][$i]['key']); ?>
										</td>
										<td>
											<?php
											switch ($tpl['survey_form_field_arr'][$i]['type'])
											{
												case 'string':
													?><input type="text" name="value-<?php echo $tpl['survey_form_field_arr'][$i]['type']; ?>-<?php echo $tpl['survey_form_field_arr'][$i]['key']; ?>" class="pj-form-field w200" value="<?php echo htmlspecialchars(stripslashes($tpl['survey_form_field_arr'][$i]['value'])); ?>" /><?php
													break;
												case 'text':
													?><textarea name="value-<?php echo $tpl['survey_form_field_arr'][$i]['type']; ?>-<?php echo $tpl['survey_form_field_arr'][$i]['key']; ?>" class="pj-form-field" style="width: 400px; height: 80px;"><?php echo htmlspecialchars(stripslashes($tpl['survey_form_field_arr'][$i]['value'])); ?></textarea><?php
													break;
												case 'int':
													?><input type="text" name="value-<?php echo $tpl['survey_form_field_arr'][$i]['type']; ?>-<?php echo $tpl['survey_form_field_arr'][$i]['key']; ?>" class="pj-form-field field-int w60" value="<?php echo htmlspecialchars(stripslashes($tpl['survey_form_field_arr'][$i]['value'])); ?>" /><?php
													break;
												case 'float':
													?><input type="text" name="value-<?php echo $tpl['survey_form_field_arr'][$i]['type']; ?>-<?php echo $tpl['survey_form_field_arr'][$i]['key']; ?>" class="pj-form-field field-float w60" value="<?php echo htmlspecialchars(stripslashes($tpl['survey_form_field_arr'][$i]['value'])); ?>" /><?php
													break;
												case 'enum':
													?><select name="value-<?php echo $tpl['survey_form_field_arr'][$i]['type']; ?>-<?php echo $tpl['survey_form_field_arr'][$i]['key']; ?>" class="pj-form-field">
													<?php
													$default = explode("::", $tpl['survey_form_field_arr'][$i]['value']);
													$enum = explode("|", $default[0]);
													
													$enumLabels = array();
													if (!empty($tpl['survey_form_field_arr'][$i]['label']) && strpos($tpl['survey_form_field_arr'][$i]['label'], "|") !== false)
													{
														$enumLabels = explode("|", $tpl['survey_form_field_arr'][$i]['label']);
													}
													
													foreach ($enum as $k => $el)
													{
														if ($default[1] == $el)
														{
															?><option value="<?php echo $default[0].'::'.$el; ?>" selected="selected"><?php echo @$option_survey_form_field_arr[$el]; ?></option><?php
														} else {
															?><option value="<?php echo $default[0].'::'.$el; ?>"><?php echo @$option_survey_form_field_arr[$el]; ?></option><?php
														}
													}
													?>
													</select>
													<?php
													break;
											}
											?>
										</td>
									</tr>
									<?php
								}
								?>
								</tbody>
							</table>
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						</form>
					</div>	
									
					<?php
				}
			?>
		</div>
		
		<div id="tabs-4">
			<?php
			pjUtil::printNotice(__('infoEmailNotificationsTitle', true), __('infoEmailNotificationsDesc', true), false);
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSurveys&amp;action=pjActionUpdate" method="post" class="form pj-form">
				<input type="hidden" name="email_update" value="1" />
				<input type="hidden" name="tab_id" value="tabs-4" />				
				<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
				
				<fieldset class="overflow b10">
					<p>
						<label class="title"><?php __('lblEmailNotifications'); ?></label>
						<span class="inline_block">
							<?php $email_notification_types_arr = __('email_notification_types', true);?>
							<select name="email_notification_type" id="email_notification_type" class="pj-form-field">
								<?php foreach ($email_notification_types_arr as $k => $v) { ?>
									<option value="<?php echo $k;?>"><?php echo pjSanitize::html($v);?></option>
								<?php } ?>
							</select>
						</span>
					</p>
					
					<div class="emailBox_user" style="display: none;">
						<p>
							<label class="title"><?php __('lblSendConfirmationEmail'); ?></label>
							<span class="inline_block">
								<select name="value-enum-o_send_confirmation_email_to_user" class="pj-form-field">
									<option value="1|2::1" <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_user'] == 1 ? 'selected="selected"' : null;?>><?php __('lblNo');?></option>
									<option value="1|2::2" <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_user'] == 2 ? 'selected="selected"' : null;?>><?php __('lblYes');?></option>
								</select>
							</span>
						</p>
						<div class="lead-confirmation-email-container" style="display: <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_user'] == 2 ? null : 'none;';?>">
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
							?>
								<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<label class="title"><?php __('lblConfirmationEmailSubject'); ?>:</label>
									<span class="inline_block">
										<input type="text" id="i18n_confirmation_email_subject_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][confirmation_email_subject]" value="<?php echo htmlspecialchars(stripslashes(@$tpl['data_field_arr']['i18n'][$v['id']]['confirmation_email_subject'])); ?>" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" />
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</p>
								<?php
							}
							foreach ($tpl['lp_arr'] as $v)
							{
							?>
								<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<label class="title"><?php __('lblConfirmationEmailMessage'); ?></label>
									<span class="inline_block">
										<textarea id="i18n_confirmation_email_message_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][confirmation_email_message]" class="pj-form-field w500 h400" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['data_field_arr']['i18n'][$v['id']]['confirmation_email_message'])); ?></textarea>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</p>
								<?php
							}
							?>
						</div>
					</div>
					<div class="emailBox_admin">
						<p>
							<label class="title"><?php __('lblSendConfirmationEmail'); ?></label>
							<span class="inline_block">
								<select name="value-enum-o_send_confirmation_email_to_admin" class="pj-form-field">
									<option value="1|2::1" <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_admin'] == 1 ? 'selected="selected"' : null;?>><?php __('lblNo');?></option>
									<option value="1|2::2" <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_admin'] == 2 ? 'selected="selected"' : null;?>><?php __('lblYes');?></option>
								</select>
							</span>
						</p>
						
						<div class="admin-confirmation-email-container" style="display: <?php echo $tpl['data_field_arr']['o_send_confirmation_email_to_admin'] == 2 ? null : 'none;';?>">
							<?php
							foreach ($tpl['lp_arr'] as $v)
							{
							?>
								<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<label class="title"><?php __('lblConfirmationEmailSubject'); ?>:</label>
									<span class="inline_block">
										<input type="text" id="i18n_admin_confirmation_email_subject_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][admin_confirmation_email_subject]" value="<?php echo htmlspecialchars(stripslashes(@$tpl['data_field_arr']['i18n'][$v['id']]['admin_confirmation_email_subject'])); ?>" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" />
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</p>
								<?php
							}
							foreach ($tpl['lp_arr'] as $v)
							{
							?>
								<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
									<label class="title"><?php __('lblConfirmationEmailMessage'); ?></label>
									<span class="inline_block">
										<textarea id="i18n_admin_confirmation_email_message_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][admin_confirmation_email_message]" class="pj-form-field w500 h400" lang="<?php echo $v['id']; ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['data_field_arr']['i18n'][$v['id']]['admin_confirmation_email_message'])); ?></textarea>
										<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
										<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
										<?php endif; ?>
									</span>
								</p>
								<?php
							}
							?>
						</div>
					</div>
					
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					</p>
				</fieldset>
			</form>
		</div>
		
		<div id="tabs-5">
			<?php pjUtil::printNotice(__('lblInstallJs1_title', true), __('lblInstallJs1_body', true), false, false); ?>

			<div class="float_left w450">
				<form action="<?php echo PJ_INSTALL_URL; ?>index.php" method="get" class="pj-form form frmInstallForm" target="_blank">
					<input type="hidden" name="controller" value="pjAdminOptions" />
					<input type="hidden" name="action" value="pjActionPreview" />
					<input type="hidden" name="sid" value="<?php echo (int)$tpl['arr']['id']; ?>" />
					<fieldset class="fieldset white">
						<legend><?php __('install_legend'); ?></legend>
						<p>
							<label class="title"><?php __('lblTheme'); ?></label>
							<select name="theme" id="theme" class="pj-form-field">
								<?php
								$option_themes = pjUtil::sortArrayByArray(__('option_themes', true), array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10'));
								foreach ($option_themes as $k => $v)
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</p>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) :?>
						<p>
							<label class="title"><?php __('lblInstallConfigLocale'); ?></label>
							<select class="pj-form-field w200" name="locale">
								<option value="">-- <?php __('lblChoose'); ?> --</option>
								<?php
								foreach ($tpl['locale_arr'] as $locale)
								{
									?><option value="<?php echo $locale['id']; ?>"><?php echo pjSanitize::html($locale['title']); ?></option><?php
								}
								?>
							</select>
						</p>
						<p>
							<label class="title"><?php __('lblInstallConfigHide'); ?></label>
							<span class="left">
								<input type="checkbox" name="hide" value="1" />
							</span>
						</p>
						<?php endif; ?>
					</fieldset>
				</form>
			
				<div class="install-heading"><?php __('install_method_1'); ?></div>
				<div class="install-hint"><?php __('install_method_1_hint'); ?></div>
				<div class="install-code">
					<textarea class="pj-form-field textarea_install" id="install_code" style="overflow: auto; height:100px">
&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoadCss&sid=<?php echo (int)$tpl['arr']['id']; ?>" type="text/css" rel="stylesheet" /&gt;
&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoad&sid=<?php echo (int)$tpl['arr']['id']; ?>"&gt;&lt;/script&gt;</textarea>
		
					<div style="display:none" id="hidden_code">&lt;link href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoadCss&sid=<?php echo (int)$tpl['arr']['id']; ?>" type="text/css" rel="stylesheet" /&gt;
&lt;script type="text/javascript" src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&action=pjActionLoad&sid=<?php echo (int)$tpl['arr']['id']; ?>"&gt;&lt;/script&gt;</div>
				</div>
				
				<div class="install-method">
					<div class="install-heading"><?php __('install_method_2'); ?></div>
					<div class="install-hint"><?php __('install_method_2_hint'); ?></div>
					<div class="install-code install_method_2">
				 		<a target="_blank" href="<?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?>"><?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?></a>
					</div>
					<div class="install_method_2_hidden" style="display: none;">
						<a target="_blank" href="<?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?>"><?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?></a>
					</div>
				</div>
				
				<div class="install-method">
					<div class="install-heading"><?php __('install_method_3'); ?></div>
					<div class="install-hint"><?php __('install_method_3_hint'); ?></div>
					<div class="install-code install_method_3">
						<textarea class="pj-form-field textarea_install" style="overflow: auto; height:65px">&lt;a href="<?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?>"&gt;<?php __('install_link'); ?>&lt/a&gt;</textarea>
					</div>
					<div class="install_method_3_hidden" style="display: none;">
						<textarea class="pj-form-field textarea_install" style="overflow: auto; height:65px">&lt;a href="<?php echo PJ_INSTALL_URL; ?>survey.php?sid=<?php echo (int)$tpl['arr']['id']; ?>"&gt;<?php __('install_link'); ?>&lt/a&gt;</textarea>
					</div>
				</div>
				
			</div>
			<div class="float_right w270">
				<div class="install-segment">
					<div class="install-title"><?php __('install_review'); ?></div>
					<div class="install-text"><?php __('install_review_hint'); ?></div>
					<div class="install-example">
						<a href="#" class="btn-example"><img src="<?php echo PJ_INSTALL_URL.PJ_IMG_PATH; ?>backend/install-example.png" alt="" /></a>
					</div>
				</div>
			</div>
			<div class="clear_both"></div>
		</div>
		
	</div>
	<div id="dialogExample" title="<?php __('install_example_title', false, true); ?>" style="display:none"></div>
	<script type="text/javascript">
	var pjLocale = pjLocale || {};
	var myLabel = myLabel || {};
	myLabel.install_url = "<?php echo PJ_INSTALL_URL; ?>";
	myLabel.field_required = "<?php __('sv_field_required'); ?>";
	myLabel.field_digits = "<?php __('sv_field_digits'); ?>";
	myLabel.select_options = "<?php __('sv_select_options'); ?>";
	myLabel.uncheck_all = "<?php __('sv_uncheck_all'); ?>";
	myLabel.check_all = "<?php __('sv_check_all'); ?>";
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	
	
	(function ($) {
		$(function() {
			<?php
			if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
			{		
				$tab_id = $_GET['tab_id'];
				$tab_id = $tab_id < 0 ? 0 : $tab_id; 
				?>$("#tabs").tabs("option", "active", <?php echo str_replace("tabs-", "", $tab_id) - 1;?>);<?php
			}
			?>

			<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1) : ?>
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
				}
			});
			<?php endif; ?>
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>