var jQuery_1_8_2 = $.noConflict();
(function ($, undefined) {
	$(function () {
		var tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		$(".field-int").spinner({
			min: 0
		});
		
		$("#content").on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "#client_email_notify", function (e) {
			var value = $(this).val();
			$('.boxClient').hide();
			$('.boxClient' + value).show();
		});
		
		if (window.tinyMCE !== undefined) {
			tinymce.init({
				relative_urls : false,
				remove_script_host : false,
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 560,
			    height: 350,
			    plugins: [
			              "advlist autolink lists link image charmap print preview anchor",
			              "searchreplace visualblocks code fullscreen",
			              "insertdatetime media table contextmenu paste"
			    ],
			    toolbar: "insertfile undo redo | styleselect fontselect fontsizeselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
			    setup: function (editor) {
			        editor.on('change', function () {
			            tinymce.triggerSave();
			        });
			    },
			    external_filemanager_path: "core/third-party/filemanager/",
			    filemanager_title: "Responsive Filemanager" ,
			    external_plugins: {"filemanager": "../../filemanager/plugin.min.js"}
			});
		}
	});
})(jQuery_1_8_2);