var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateQuestion = $("#frmCreateQuestion"),
			$frmUpdateQuestion = $("#frmUpdateQuestion"),
			dialog = ($.fn.dialog !== undefined),
			$dialogDeleteAnswer = $("#dialogDeleteAnswer"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if(validate) {
			$.extend($.validator.messages, {
			    required: myLabel.field_required
			});
		}
		
		if ($dialogDeleteAnswer.length > 0 && dialog) {
			$dialogDeleteAnswer.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				buttons: {
					"Delete": function () {
						var $this = $(this),
							$link = $this.data("link"),
							$div = $link.closest(".answer-details");
						$.post("index.php?controller=pjAdminSurveyQuestions&action=pjActionDeleteAnswer", {
							id: $link.data("id")
						}).done(function () {
							$div.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
								$div.remove();
								$(".answer-num-answer .answer-details").each(function(i) {
									$(this).find("span.question-no").html(i + 1);
								});
								$this.dialog("close");
							});
						});
					},
					"Cancel": function () {
						$(this).dialog("close");
					}
				}
			});
		}
				
		if ($frmCreateQuestion.length > 0 && validate) {
			$frmCreateQuestion.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore, :hidden",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined && parseInt(localeId) > 0)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		if ($frmUpdateQuestion.length > 0 && validate) {
			$frmUpdateQuestion.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore, :hidden",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined && parseInt(localeId) > 0)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		
		function onBeforeShow (obj) {
			if (parseInt(pjGrid.isAdmin) == 1) {
				return true;
			}
			return false;
		}
		
		function formatQuestionRequired(str, obj) {
			if (obj.is_required == 'T') {
				return myLabel.yes;
			} else {
				return myLabel.no;
			}
		}
		
		function formatQuestionType(str, obj) {
			if (obj.type == 'multi') {
				return myLabel.multi;
			} else if (obj.type == 'single') {
				return myLabel.single;
			} else {
				return myLabel.open;
			}
		}
		
		function formatDown(val, obj) {
			return (obj.down === 1) ? ['<a href="index.php?controller=pjAdminSurveyQuestions" class="arrow_down" rev="down" rel="', val.id , '" title="', myLabel.down, '"></a>'].join("") : '';
		}
		function formatUp(val, obj) {
			return (obj.up === 1) ? ['<a href="index.php?controller=pjAdminSurveyQuestions" class="arrow_up" rev="up" rel="', val.id , '" title="', myLabel.up, '"></a>'].join("") : '';
		}
		
		var queryStr = ""; 
		if ($("#grid").length > 0 && datagrid) {
			var queryStr = "&survey_id=" + myLabel.survey_id, 
				$grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminSurveyQuestions&action=pjActionUpdate"+queryStr+"&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminSurveyQuestions&action=pjActionDeleteQuestion&id={:id}"}
				          ],
				columns: [{text: myLabel.question, type: "text", sortable: true, editable: false, width: 150},
				          {text: myLabel.question_type, type: "text", sortable: true, editable: false, renderer: formatQuestionType},
				          {text: myLabel.question_required, type: "text", sortable: true, editable: false, renderer: formatQuestionRequired},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, editableWidth: 90, options: [
						                                                                                     {label: myLabel.active, value: "T"}, 
						                                                                                     {label: myLabel.inactive, value: "F"}
						                                                                                     ], applyClass: "pj-status"},
                          {text: myLabel.down, type: "text", sortable: false, editable: false, renderer: formatDown, width: 21},
						  {text: myLabel.up, type: "text", sortable: false, editable: false, renderer: formatUp, width: 21}],
				dataUrl: "index.php?controller=pjAdminSurveyQuestions&action=pjActionGetQuestion" + queryStr,
				dataType: "json",
				fields: ['question', 'type', 'is_required', 'status', 'data', 'data'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminSurveyQuestions&action=pjActionDeleteQuestionBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminSurveyQuestions&action=pjActionSaveQuestion&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("focusin", ".datepick", function (e) {			
			var $this = $(this);
			$("#start_date").datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev"),
		        onSelect: function(selected) {
		          $("#end_date").datepicker("option","minDate", selected)
		        }
		    });
		    $("#end_date").datepicker({
		    	firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev"),
		        onSelect: function(selected) {
		           $("#start_date").datepicker("option","maxDate", selected)
		        }
		    });  
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				if(!$dp.is('[disabled=disabled]'))
				{
					$dp.trigger("focusin").datepicker("show");
				}
			}
		}).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveyQuestions&action=pjActionGetQuestion" + queryStr, "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveyQuestions&action=pjActionGetQuestion" + queryStr, "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveyQuestions&action=pjActionGetQuestion" + queryStr, "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".rdo-question-type", function (e) {
			if ($(this).val() == 'open') {
				$(".answer-container").hide();
				$(".answer-container").find("input[type='text']").removeClass("required");
			} else {
				$(".answer-container").show();
				$(".answer-container").find("input[type='text']").addClass("required");
				if ($(this).val() == 'single') {
					$(".chk-checked-by-default").each(function(){
						$(this).attr("checked", false);
					});
				}
			}
		}).on("click", ".chk-checked-by-default", function (e) {	
			var $this = this;
			if ($("input[name='type']:checked").val() == 'single') {
				$(".chk-checked-by-default").each(function(){
					if (!$this.checked || ($this.checked && $this.name != this.name)) {
						$(this).attr("checked", false);
					}
				});
			}
		}).on("click", ".btn-add-answer", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var len = $(".answer-container").find(".answer-details").length,
				clone = $(".answer-clone").clone(),
				index =  Math.ceil(Math.random() * 99999999);
			clone.find("span.question-no").html(len + 1);
			
			var cloneHtml = clone.html().replace(/\{INDEX\}/g, index);
			$(".answer-num-answer").append(cloneHtml);
			
			$(".answer-num-answer .answer-details").each(function(i) {
				$(this).find("span.question-no").html(i + 1);
			});
		}).on("click", ".btn-remove-answer", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				$div = $this.closest(".answer-details");
			
			$div.css("backgroundColor", "#FFB4B4").fadeOut("slow", function () {
				$div.remove();
				$(".answer-num-answer .answer-details").each(function(i) {
					$(this).find("span.question-no").html(i + 1);
				});
			});
		}).on("click", ".btn-delete-answer", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogDeleteAnswer.length > 0 && dialog) {
				$dialogDeleteAnswer.data('link', $(this)).dialog("open");
			}
			return false;
		}).on("click", ".arrow_up, .arrow_down", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminSurveyQuestions&action=pjActionSetOrder", {
				"id": $(this).attr("rel"),
				"direction": $(this).attr("rev")
			}).done(function (data) {
				var content = $grid.datagrid("option", "content");
				$grid.datagrid("load", "index.php?controller=pjAdminSurveyQuestions&action=pjActionGetQuestion" + queryStr, "id", "ASC", content.page, content.rowCount);
			});
			return false;
		});
	});
})(jQuery_1_8_2);