var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateSurvey = $("#frmCreateSurvey"),
			$frmUpdateSurvey = $("#frmUpdateSurvey"),
			$dialogExample = $("#dialogExample"),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),			
			spinner = ($.fn.spinner !== undefined),
			multiselect = ($.fn.multiselect !== undefined),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val(ui.newPanel.attr('id'));
					if (ui.newPanel.attr('id') == 'tabs-2')
					{
						window.location.href = "index.php?controller=pjAdminSurveyQuestions&action=pjActionIndex&survey_id=" + $frmUpdateSurvey.find("input[name='id']").val();
					}
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		
		if (spinner) {
			$(".field-int").spinner({
				min: 1
			});
		}
				
		if (multiselect) {
			$("#user_id").multiselect({
				noneSelectedText: myLabel.select_options,
				uncheckAllText: myLabel.uncheck_all,
				checkAllText: myLabel.check_all
			});
		}
		
		if(validate) {
			$.extend($.validator.messages, {
			    required: myLabel.field_required,
			    digits: myLabel.field_digits
			});
		}
		
		function reDrawCode() {
			var code = $("#hidden_code").text(),
				code_2 = $(".install_method_2_hidden").html(),
				code_3 = $(".install_method_3_hidden").html(),
				theme = $("select[name='theme']").find("option:selected").val(),
				locale = $("select[name='locale']").find("option:selected").val(),
				hide = $("input[name='hide']").is(":checked") ? "&hide=1" : "";
			theme = parseInt(theme.length, 10) > 0 ? "&theme=" + theme : "";
			if (locale != undefined) {
				locale = parseInt(locale.length, 10) > 0 ? "&locale=" + locale : "";
			} else {
				locale = '';
			}
						
			$("#install_code").text(code.replace(/&action=pjActionLoad&sid=(\d+)/g, function(match) {
	            return [match, theme, locale, hide].join("");
	        }).replace(/&action=pjActionLoadCss&sid=(\d+)/g, function(match) {
	            return [match, theme].join("");
	        }));
			
			code_2 = code_2.replace(/sid=(\d+)/g, function(match) {
	            return [match, theme, locale, hide].join("");
	        });
			$(".install_method_2").html(code_2);
			
			code_3 = code_3.replace(/sid=(\d+)/g, function(match) {
	            return [match, theme, locale, hide].join("");
	        });
			$(".install_method_3").html(code_3);
			
		}
		
		if ($frmCreateSurvey.length > 0 && validate) {
			$frmCreateSurvey.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore, :hidden",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined && parseInt(localeId) > 0)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		if ($frmUpdateSurvey.length > 0 && validate) {
			$frmUpdateSurvey.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ".ignore, :hidden",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined && parseInt(localeId) > 0)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		
		function onBeforeShow (obj) {
			if (parseInt(pjGrid.isAdmin) == 1) {
				return true;
			}
			return false;
		}
		
		function formatCompleted(str, obj) {
			return '<a href="index.php?controller=pjAdminSurveys&action=pjActionCompleted&survey_id='+obj.id+'">'+obj.num_completed+'</a>';
		}
		
		function formatAvailableTo(str, obj) {
			if (str == 'everyone') {
				return myLabel.available_everyone;
			} else {
				return myLabel.available_users;
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "view", url: "index.php?controller=pjAdminOptions&action=pjActionPreview&sid={:id}&theme=1", target: "_blank"},
				          {type: "edit", url: "index.php?controller=pjAdminSurveys&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminSurveys&action=pjActionDeleteSurvey&id={:id}"}
				          ],
				columns: [{text: myLabel.survey_title, type: "text", sortable: true, editable: false, width: 120},
				          {text: myLabel.available_to, type: "text", sortable: true, editable: false, renderer: formatAvailableTo},
				          {text: myLabel.completed, type: "text", sortable: true, editable: false, align: "center", renderer: formatCompleted},
				          {text: myLabel.questions, type: "text", sortable: true, editable: false, align: "center"},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 90, editableWidth: 80, options: [
						                                                                                     {label: myLabel.active, value: "T"}, 
						                                                                                     {label: myLabel.inactive, value: "F"}
						                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminSurveys&action=pjActionGetSurvey",
				dataType: "json",
				fields: ['title', 'available_to', 'num_completed', 'num_questions', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminSurveys&action=pjActionDeleteSurveyBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminSurveys&action=pjActionSaveSurvey&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		function formatUserName(str, obj) {
			if (parseInt(obj.user_id, 10) > 0) {
				return '<a href="index.php?controller=pjAdminUsers&action=pjActionUpdate&id='+obj.user_id+'" title="'+obj.user_name+'">'+obj.user_name+'</a>';
			} else {
				return obj.user_name;
			}
		}
		
		if ($("#grid_completed_surveys").length > 0) {
			var query_str = "&survey_id=" + pjGrid.survey_id;
		}
		if ($("#grid_completed_surveys").length > 0 && datagrid) {
			var $grid_completed_surveys = $("#grid_completed_surveys").datagrid({
				buttons: [
				          {type: "view", url: "index.php?controller=pjFrontEnd&action=pjActionViewSurvey&uuid={:uuid}", target: "_blank"},
				          {type: "delete", url: "index.php?controller=pjAdminSurveys&action=pjActionDeleteCompletedSurvey&id={:id}"}
				          ],
				columns: [{text: myLabel.user_name, type: "text", sortable: true, editable: false, width: 120, renderer: formatUserName},
				          {text: myLabel.date_completion, type: "text", sortable: true, editable: false, width: 130 },
				          {text: myLabel.time_completion, type: "text", sortable: false, editable: false, width: 150 },
				          {text: myLabel.survey_title, type: "text", sortable: true, editable: false, width: 190}],
				dataUrl: "index.php?controller=pjAdminSurveys&action=pjActionGetCompletedSurvey" + query_str,
				dataType: "json",
				fields: ['user_name', 'date_completion', 'time_completion', 'survey_title'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminSurveys&action=pjActionDeleteCompletedSurveyBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("focusin", ".datepick", function (e) {			
			var $this = $(this);
			$("#start_date").datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev"),
		        onSelect: function(selected) {
		          $("#end_date").datepicker("option","minDate", selected)
		        }
		    });
		    $("#end_date").datepicker({
		    	firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev"),
		        onSelect: function(selected) {
		           $("#start_date").datepicker("option","maxDate", selected)
		        }
		    });  
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				if(!$dp.is('[disabled=disabled]'))
				{
					$dp.trigger("focusin").datepicker("show");
				}
			}
		}).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveys&action=pjActionGetSurvey", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveys&action=pjActionGetSurvey", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSurveys&action=pjActionGetSurvey", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("change", "#email_notification_type", function (e) {
			if ($(this).val() == 'user') {
				$(".emailBox_user").show();
				$(".emailBox_admin").hide();
			} else {
				$(".emailBox_user").hide();
				$(".emailBox_admin").show();
			}
		}).on("change", "select[name='value-enum-o_send_confirmation_email_to_admin']", function (e) {
			switch ($("option:selected", this).val()) {
			case '1|2::1':
				$(".admin-confirmation-email-container").hide();
				break;
			case '1|2::2':
				$(".admin-confirmation-email-container").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_send_confirmation_email_to_user']", function (e) {
			switch ($("option:selected", this).val()) {
			case '1|2::1':
				$(".lead-confirmation-email-container").hide();
				break;
			case '1|2::2':
				$(".lead-confirmation-email-container").show();
				break;
			}
		}).on("click", "input[name='available_to']", function (e) {
			switch ($(this).val()) {
			case 'everyone':
				$(".survey-registration-required").show();
				$(".survey-users").hide();
				break;
			case 'users':
				$(".survey-registration-required").hide();
				$(".survey-users").show();
				break;
			}
		}).on("change", "select[name='theme']", function(e) {
            reDrawCode.call(null);
		}).on("change", "select[name='locale']", function(e) {
            reDrawCode.call(null);
		}).on("change", "input[name='hide']", function (e) {
			reDrawCode.call(null);
		}).on("submit", ".frm-filter-completed-surveys", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid_completed_surveys.datagrid("option", "content"),
				cache = $grid_completed_surveys.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid_completed_surveys.datagrid("option", "cache", cache);
			$grid_completed_surveys.datagrid("load", "index.php?controller=pjAdminSurveys&action=pjActionGetCompletedSurvey" + query_str, "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-example", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogExample.length > 0 && dialog) {
				$dialogExample.dialog("open");
			}
			return false;
		});
		
		if ($dialogExample.length > 0 && dialog) {
			$dialogExample.dialog({
				modal: true,
				autoOpen: false,
				resizable: false,
				draggable: false,
				width: 600,
				open: function () {
					var $sid = $(".frmInstallForm").find("input[name='sid']").val(),
						$theme = $(".frmInstallForm").find("select[name='theme']").val();
					$.get("index.php?controller=pjAdminSurveys&action=pjActionGetExample&sid=" + $sid + "&theme=" + $theme).done(function (data) {
						$dialogExample.html(data);
						
						var editor_1 = CodeMirror.fromTextArea(document.getElementById("install-example-1"), {
							lineNumbers: true,
							readOnly: true,
						    mode: "text/html"
						});
						var editor_3 = CodeMirror.fromTextArea(document.getElementById("install-example-3"), {
							lineNumbers: true,
							readOnly: true,
						    mode: "text/html"
						});
						$dialogExample.find("#methods").tabs();
						
						$dialogExample.dialog("option", "position", "center");
					});
				},
				buttons: {
					"Close": function () {
						$dialogExample.dialog("close");
					}
				}
			});
		}
	});
})(jQuery_1_8_2);