/*!
 * Survey Script v1.0
 * http://www.phpjabbers.com/php-survey-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		  xhrFields: {
		   withCredentials: true
		  }
	 });
	var document = window.document,
		routes = [
		          	{pattern: /^#!\/loadInit$/, eventName: "loadInit"},
		          	{pattern: /^#!\/loadLogin$/, eventName: "loadLogin"},
		          	{pattern: /^#!\/loadLogin\/(.*)$/, eventName: "loadLogin"},
		          	{pattern: /^#!\/loadForgot$/, eventName: "loadForgot"},
		          	{pattern: /^#!\/loadForgot\/(.*)$/, eventName: "loadForgot"},
		          	{pattern: /^#!\/loadRegister$/, eventName: "loadRegister"},
		          	{pattern: /^#!\/loadRegister\/(.*)$/, eventName: "loadRegister"},
		          	{pattern: /^#!\/loadQuestions$/, eventName: "loadQuestions"},
		          	{pattern: /^#!\/loadQuestions\/(\d+)$/, eventName: "loadQuestions"},
		          	{pattern: /^#!\/loadReviewSurvey$/, eventName: "loadReviewSurvey"},
		          	{pattern: /^#!\/loadReviewSurvey\/(\d+)$/, eventName: "loadReviewSurvey"},
		          	{pattern: /^#!\/loadComplete\/(\d+)$/, eventName: "loadComplete"},
		          	{pattern: /^#!\/loadWelcome$/, eventName: "loadWelcome"},
		          	{pattern: /^#!\/loadExpire$/, eventName: "loadExpire"}
		         ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadInit");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function StivaSurvey(opts) {
		if (!(this instanceof StivaSurvey)) {
			return new StivaSurvey(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	StivaSurvey.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	StivaSurvey.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	StivaSurvey.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.opts = {};
			this.params = {};
			this.b_day = null,
			this.b_month = null,
			this.b_year = null;
			this.page = 1;
			this.time_to_complete = null;
			return this;
		},
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).addClass('ssButtonDisabled').prop("disabled", true);
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeClass('ssButtonDisabled').removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;				
			this.opts = opts,
			self.b_day = null,
			self.b_month = null,
			self.b_year = null;
			self.params = { 
					"locale": self.opts.locale,
					"hide": self.opts.hide,
					"index": self.opts.index,
					"theme": self.opts.theme,
					"sid": self.opts.sid
				 }
			
			this.container = document.getElementById("ssContainer_" + self.opts.index);
			self.$container = pjQ.$(self.container);
			
			this.$container.on("click.fd", ".ssButtonLogin", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if (!self.validateLogin.call(self)) {
					return false;
				}
				var $frm = pjQ.$('#ssLoginForm_' + self.opts.index),
					type = pjQ.$(this).attr("data-type");
				self.disableButtons.call(self);
				pjQ.$.post([self.opts.server, "index.php?controller=pjFront&action=pjActionCheckLogin", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join(""), $frm.serialize()).done(function (data) {
					if(data.code != '200')
					{
						if(data.code != '103')
						{
							pjQ.$('#ssLoginMessage_' + self.opts.index).html(self.opts.login_messages[parseInt(data.code, 10)]);
						}else{
							pjQ.$('#ssLoginMessage_' + self.opts.index).html(data.text);
						}
						pjQ.$('#ssLoginMessage_' + self.opts.index).parent().css('display', 'block');
						self.enableButtons.call(self);
					}else{
						self.opts.is_client_loggedin = 1;
						if (type == 'Complete') {
							self.processSurvey.call(self);
						} else {
							hashBang("#!/loadQuestions");
						}
					}
				});
				return false;
			}).on("click.fd", ".ssForogtPassword", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var type = pjQ.$(this).attr("data-type");
				hashBang("#!/loadForgot/" + type);
				return false;
			}).on("click.fd", ".ssButtonForgotPassword", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if (!self.validateForgot.call(self)) {
					return false;
				}
				var $frm = pjQ.$('#ssForgotPasswordForm_' + self.opts.index);
				self.disableButtons.call(self);
				pjQ.$.post([self.opts.server, "index.php?controller=pjFront&action=pjActionSendPassword", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join(""), $frm.serialize()).done(function (data) {
					pjQ.$('#ssForgotMessage_' + self.opts.index).html(self.opts.forgot_messages[parseInt(data.code, 10)]).parent().css('display', 'block');
					self.enableButtons.call(self);
				});
				return false;
			}).on("click.fd", ".ssLogin", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var type = pjQ.$(this).attr("data-type");
				hashBang("#!/loadLogin/" + type);
				return false;
			}).on("click.fd", ".ssRegister", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var type = pjQ.$(this).attr("data-type");
				hashBang("#!/loadRegister/" + type);
				return false;
			}).on("change.fd", ".select-birthday", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $val = pjQ.$(this).val();
				if (this.name == 'day') {
					self.b_day = $val;
				}
				if (this.name == 'month') {
					self.b_month = $val;
				}
				if (this.name == 'year') {
					self.b_year = $val;
				}
				if (self.b_year != '' && self.b_month != '' && self.b_day != '') {
					var $birthday = self.b_year + "-" + self.b_month + "-" + self.b_day;
					pjQ.$(".user-birthday").val($birthday);
				} else {
					pjQ.$(".user-birthday").val('');
				}
			}).on("click.fd", ".ssButtonRegister", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $frm = pjQ.$('#ssRegisterForm_' + self.opts.index),
					type = pjQ.$(this).attr("data-type");
				
				if (!self.validateRegister.call(self, type)) {
					return false;
				}
				self.disableButtons.call(self);
				pjQ.$.post([self.opts.server, "index.php?controller=pjFront&action=pjActionRegister", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join(""), $frm.serialize()).done(function (data) {
					if(data.code == 200)
					{
						pjQ.$('#ssRegisterMessage_' + self.opts.index).html(self.opts.messages[3]);
						pjQ.$('#ssRegisterMessage_' + self.opts.index).parent().css('display', 'block');
						self.enableButtons.call(self);
						
						pjQ.$('html, body').animate({
					        scrollTop: pjQ.$('#ssRegisterMessage_' + self.opts.index).offset().top - 20
					    }, 'slow');
					}else{
						if (type == 'Complete') {
							pjQ.$('#ssRegisterMessage_' + self.opts.index).html(self.opts.messages[8]);
						} else {
							pjQ.$('#ssRegisterMessage_' + self.opts.index).html(self.opts.messages[4]);
						}
						pjQ.$('#ssRegisterMessage_' + self.opts.index).parent().css('display', 'block');

						pjQ.$('html, body').animate({
					        scrollTop: pjQ.$('#ssRegisterMessage_' + self.opts.index).offset().top - 20
					    }, 'slow');
						
						pjQ.$(".pjSsRegisterFormDetails").hide();
						$frm[0].reset();
						self.opts.is_client_loggedin = 1;
						setTimeout(function(){ 
							if (type == 'Complete') {
								self.processSurvey.call(self);
							} else {
								hashBang("#!/loadQuestions");
							}
						}, 3000);
					}
					self.enableButtons.call(self);
				});
				return false;
			}).on("click.fd", ".ssButtonStartSurvey", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				self.opts.survey_started = 1;
				hashBang("#!/loadQuestions");
				return false;
			}).on("click.fd", ".ssButtonQuestion", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = this,
					type = pjQ.$($this).attr("data-type"),
					page = pjQ.$($this).attr("data-page");

				if (type == 'back') {
					hashBang("#!/loadQuestions/" + page);
				} else {
					if (!self.validateQuestion.call(self)) {
						return false;
					}
					var $frm = pjQ.$('#ssQuestionForm_' + self.opts.index);
					pjQ.$.post([self.opts.server, "index.php?controller=pjFront&action=pjActionSaveForm", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join(""), $frm.serialize()).done(function (data) {
						if (type == 'next') {
							hashBang("#!/loadQuestions/" + page);
						} else {
							if (self.opts.is_client_loggedin == 1 || (self.opts.available_to == 'everyone' && self.opts.registration_required == 'anonymous')) {
								self.processSurvey.call(self);
							} else {
								hashBang("#!/loadRegister/Complete");
							}
						}
					});
				}
				
				return false;
			}).on("click.fd", ".ssButtonReviewSurvey", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var $this = this,
					page = pjQ.$($this).attr("data-page");

				hashBang("#!/loadReviewSurvey/" + page);
				return false;
			});
			
			pjQ.$(window).on("loadInit", this.$container, function (e) {
				self.loadInit.call(self);
			}).on("loadLogin", this.$container, function (e) {
				var type = '';
				if (arguments.length == 2) {
					type = arguments[1];
				}
				self.loadLogin.call(self, type);
			}).on("loadForgot", this.$container, function (e) {
				var type = '';
				if (arguments.length == 2) {
					type = arguments[1];
				}
				self.loadForgot.call(self, type);
			}).on("loadRegister", this.$container, function (e) {
				var type = '';
				if (arguments.length == 2) {
					type = arguments[1];
				}
				self.loadRegister.call(self, type);
			}).on("loadQuestions", this.container, function (e, q) {
				switch (arguments.length) {
				    case 1:
				    	self.page = 1;
				     break;
				    case 2:
				    	self.page = arguments[1];
				     break;
			    }
				if (self.opts.available_to == 'everyone' && self.opts.registration_required != 'begin' && self.opts.survey_started == 0) {
					hashBang("#!/loadWelcome");
				} else if (self.opts.is_client_loggedin == 1 || (self.opts.available_to == 'everyone' && self.opts.registration_required != 'begin' && self.opts.survey_started == 1)) {
					self.loadQuestions.call(self);
				} else {
					hashBang("#!/loadRegister");
				}
			}).on("loadReviewSurvey", this.container, function (e, q) {
				switch (arguments.length) {
				    case 1:
				    	self.page = 1;
				     break;
				    case 2:
				    	self.page = arguments[1];
				     break;
			    }
				self.loadReviewSurvey.call(self);
			}).on("loadComplete", this.$container, function (e) {
				self.loadComplete.call(self, arguments[1]);
			}).on("loadWelcome", this.$container, function (e) {
				self.loadWelcome.call(self, arguments[1]);
			}).on("loadExpire", this.$container, function (e) {
				self.loadExpire.call(self, arguments[1]);
			});
			
			if (window.location.hash.length === 0) {
				this.loadInit.call(this);
			} else {
				onHashChange.call(null);
			}
		},		
		loadInit: function () {
			var self = this;
			self.time_to_complete = self.opts.time_to_complete;
			if (self.opts.view_user_survey_id > 0) {
				hashBang("#!/loadReviewSurvey");
			} else {
				if (self.opts.available_to == 'everyone' && self.opts.registration_required != 'begin' && self.opts.survey_started == 0) {
					hashBang("#!/loadWelcome");
				} else if (self.opts.is_client_loggedin == 1 || (self.opts.available_to == 'everyone' && self.opts.registration_required != 'begin' && self.opts.survey_started == 1)) {
					hashBang("#!/loadQuestions");
				} else {
					if(self.opts.available_to == 'users')
					{
						hashBang("#!/loadLogin");
					}else{
						hashBang("#!/loadRegister");
					}
				}
			}
		},
		loadLogin: function(type){
			var self = this,
				params = { 
						"locale": self.opts.locale,
						"hide": self.opts.hide,
						"index": self.opts.index,
						"theme": self.opts.theme,
						"sid": self.opts.sid,
						"type": type
					 };
			pjQ.$.get([this.opts.server, "index.php?controller=pjFront&action=pjActionLogin"].join(""), params).done(function (data) {
				self.$container.html(data);
			});
		},
		loadForgot: function(type){
			var self = this,
				params = { 
						"locale": self.opts.locale,
						"hide": self.opts.hide,
						"index": self.opts.index,
						"theme": self.opts.theme,
						"sid": self.opts.sid,
						"type": type
					 };
			pjQ.$.get([this.opts.server, "index.php?controller=pjFront&action=pjActionForgot"].join(""), params).done(function (data) {
				self.$container.html(data);
			});
		},
		loadRegister: function(type){
			var self = this,
				params = { 
						"locale": self.opts.locale,
						"hide": self.opts.hide,
						"index": self.opts.index,
						"theme": self.opts.theme,
						"sid": self.opts.sid,
						"type": type
					 };
			if(self.opts.available_to == 'users')
			{
				hashBang("#!/loadLogin");
			}else{
				if(this.opts.registration_required == 'anonymous')
				{
					hashBang("#!/loadWelcome");
				}else{
					pjQ.$.get([this.opts.server, "index.php?controller=pjFront&action=pjActionRegister"].join(""), params).done(function (data) {
						self.$container.html(data);
					});
				}
			}
		},
		loadWelcome: function(){
			var self = this;
			self.time_to_complete = self.opts.time_to_complete;
			if (self.opts.survey_started == 1) {				
				hashBang("#!/loadQuestions/" + self.page);
			} else {
				self.disableButtons.call(self);
				pjQ.$.post([this.opts.server, "index.php?controller=pjFront&action=pjActionLoadWelcome", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join("")).done(function (data) {
					self.$container.html(data);
					self.enableButtons.call(self);
				});
			}
		},
		loadExpire: function(){
			var self = this;
			self.disableButtons.call(self);
			pjQ.$.post([this.opts.server, "index.php?controller=pjFront&action=pjActionExpire", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid].join("")).done(function (data) {
				self.$container.html(data);
				window.setTimeout(function(){
					self.opts.survey_started = 0;
					self.time_to_complete = self.opts.time_to_complete;
					hashBang("#!/loadWelcome");
			    }, 3000);
				self.enableButtons.call(self);
			});
		},
		loadQuestions: function(callback){
			var self = this,
				interval_id = window.setInterval("", 9999);
			
			for (var i = 1; i < interval_id; i++) {
				window.clearInterval(i);
			}
			self.disableButtons.call(self);
			pjQ.$.get([this.opts.server, "index.php?controller=pjFront&action=pjActionQuestions", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid, "&page=", self.page].join("")).done(function (data) {
				if (data.code != undefined && data.code == 100) {
					hashBang("#!/loadLogin");
				}
				if (data.code != undefined && data.code == 101) {
					hashBang("#!/loadQuestions/" + data.page);
				}
				self.$container.html(data);
				self.enableButtons.call(self);
				
				if (pjQ.$('.pjSsListQuestions').length > 0) {
					if (self.opts.time_to_complete != 'unlimited') {
						if(self.time_to_complete == null)
						{
							self.time_to_complete = self.opts.time_to_complete;
						}
						var timer = '',
							ts = self.time_to_complete, 
							myInterval = setInterval(function(){
								ts = ts - 1;
								self.time_to_complete = ts;
								timer = self.formatTimeStampToHHMMSS(ts);	
								if (ts <= 0) {
									
									clearInterval(myInterval);
									
									if (self.opts.is_client_loggedin == 1 || (self.opts.available_to == 'everyone' && self.opts.registration_required == 'anonymous')) {
										hashBang("#!/loadExpire");
									} else {
										hashBang("#!/loadRegister/Complete");
									}
								} else {
									pjQ.$(".ss-timer-" + self.opts.index).html(timer);
								}
							}, 1000);
					}
				
					var $elementsCounter = pjQ.$('.pjSsListQuestions li').length;
					var $elementsWidth = 100 / $elementsCounter;
					pjQ.$('.pjSsListQuestions li').css('width', $elementsWidth + '%');
				};

				if (pjQ.$('.pjSsCustomCheckbox, .pjSsCustomRadio').length > 0) {
					var checkedClass = 'pjSsCustomInputChecked';
					var disabledClass = 'pjSsCustomInputDisabled';
					var inputSelector = '.pjSsCustomCheckbox input[type="checkbox"], .pjSsCustomRadio input[type="radio"]';
	
					pjQ.$(inputSelector).each(function() {
						var input = this;
	
						pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
					}).on('change', function() {
						var input = this;
	
						if(input.type === 'radio') {
							var name = input.name;
							pjQ.$(input.ownerDocument).find('[name=' + name + ']').each(function() {
								var radioInput = this;
								pjQ.$(radioInput).parent().toggleClass(checkedClass, radioInput.checked);
							});
						} else {
							pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
						};
					}).on('disable', function() {
						var input = this;
	
						input.disabled = true;
						pjQ.$(input).parent().addClass(disabledClass);
					}).on('enable', function() {
						var input = this;
	
						input.disabled = false;
						pjQ.$(input).parent().removeClass(disabledClass);
					}).on('click', function() {
						var $parent = pjQ.$(this).parent();
						if (this.checked) {
							$parent.find("input.additional-open-answer").addClass("required");
						} else {
							$parent.find("input.additional-open-answer").removeClass("required");
						}
					});
				}
			});
		},
		loadReviewSurvey: function(callback){
			var self = this;
			
			self.disableButtons.call(self);
			pjQ.$.post([this.opts.server, "index.php?controller=pjFront&action=pjActionReviewSurvey", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid, "&page=", self.page, "&view_user_survey_id=", self.opts.view_user_survey_id].join("")).done(function (data) {
				self.$container.html(data);
				self.enableButtons.call(self);
				
				if (pjQ.$('.pjSsListQuestions').length > 0) {
					var $elementsCounter = pjQ.$('.pjSsListQuestions li').length;
					var $elementsWidth = 100 / $elementsCounter;
					pjQ.$('.pjSsListQuestions li').css('width', $elementsWidth + '%')
				};

				if (pjQ.$('.pjSsCustomCheckbox, .pjSsCustomRadio').length > 0) {
					var checkedClass = 'pjSsCustomInputChecked';
					var disabledClass = 'pjSsCustomInputDisabled';
					var inputSelector = '.pjSsCustomCheckbox input[type="checkbox"], .pjSsCustomRadio input[type="radio"]';
	
					pjQ.$(inputSelector).each(function() {
						var input = this;
	
						pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
					}).on('change', function() {
						var input = this;
	
						if(input.type === 'radio') {
							var name = input.name;
							pjQ.$(input.ownerDocument).find('[name=' + name + ']').each(function() {
								var radioInput = this;
								pjQ.$(radioInput).parent().toggleClass(checkedClass, radioInput.checked);
							});
						} else {
							pjQ.$(input).parent().toggleClass(checkedClass, input.checked);
						};
					}).on('disable', function() {
						var input = this;
	
						input.disabled = true;
						pjQ.$(input).parent().addClass(disabledClass);
					}).on('enable', function() {
						var input = this;
	
						input.disabled = false;
						pjQ.$(input).parent().removeClass(disabledClass);
					});
				}
			});
		},
		loadComplete: function(status){
			var self = this;
			self.disableButtons.call(self);
			pjQ.$.post([this.opts.server, "index.php?controller=pjFront&action=pjActionComplete", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid, "&status=", status].join("")).done(function (data) {
				if(typeof data =='object')
				{
					if(data.code == '100')
					{
						hashBang("#!/loadWelcome/");
					}else if(data.code == '101'){
						hashBang("#!/loadQuestions/" + data.page);
					}
				}else{
					self.$container.html(data);
					self.enableButtons.call(self);
				}
			});
		},
		processSurvey: function() {
			var self = this;
			pjQ.$.post([self.opts.server, "index.php?controller=pjFront&action=pjActionProcessSurvey", "&locale=", self.opts.locale, "&hide=", self.opts.hide, "&index=", self.opts.index, "&theme=", self.opts.theme, "&sid=", self.opts.sid, "&complete_survey=", 1].join("")).done(function (data) {
				self.opts.survey_started = 0;
				hashBang("#!/loadComplete/" + data.status);
			});
		},
		validateLogin: function () {
			var validator,
				self = this,
				$form = pjQ.$('#ssLoginForm_' + self.opts.index);
			validator = $form.validate({
				ignore: "",
				errorElement: 'li',
				errorPlacement: function (error, element) {
					element.parent().parent().addClass('has-error');
					error.appendTo(element.next().find('ul'));
				},
				success: function(li, element) {
					li.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
	            }
			});
			var $_email = $form.find("input[name='login_email']"),
				$_password = $form.find("input[name='login_password']");
			if ($_email.length > 0) {
				$_email.rules("add", {
					required: true,
					email: true,
					messages: {
						required: $_email.attr("data-required"),
						email: $_email.attr("data-email")
					}
				});
			}
			if ($_password.length > 0) {
				$_password.rules("add", {
					required: true,
					messages: {
						required: $_password.attr("data-required")
					}
				});
			}
			if (!validator.form()) {
				validator.showErrors();
				return false;
			}
			return true;
		},
		validateForgot: function () {
			var validator,
				self = this,
				$form = pjQ.$('#ssForgotPasswordForm_' + self.opts.index);
			validator = $form.validate({
				ignore: "",
				errorElement: 'li',
				errorPlacement: function (error, element) {
					element.parent().parent().addClass('has-error');
					error.appendTo(element.next().find('ul'));
				},
				success: function(li, element) {
					li.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
	            }
			});
			var $_email = $form.find("input[name='email']");
			if ($_email.length > 0) {
				$_email.rules("add", {
					required: true,
					email: true,
					messages: {
						required: $_email.attr("data-required"),
						email: $_email.attr("data-email")
					}
				});
			}
			if (!validator.form()) {
				validator.showErrors();
				return false;
			}
			return true;
		},
		validateRegister: function (type) {
			var validator,
				self = this,
				$form = pjQ.$('#ssRegisterForm_' + self.opts.index);
			validator = $form.validate({
				ignore: "",
				errorElement: 'li',
				errorPlacement: function (error, element) {
					element.parent().parent().addClass('has-error');
					error.appendTo(element.next().find('ul'));
				},
				success: function(li, element) {
					li.parent().parent().parent().parent().removeClass('has-error').addClass('has-success');
	            }
			});
			var $_name = $form.find("input[name='name']"),
				$_email = $form.find("input[name='email']"),
				$_password = $form.find("input[name='password']"),
				$_phone = $form.find("input[name='phone']"),
				$_address = $form.find("input[name='address']"),
				$_city = $form.find("input[name='city']"),
				$_state = $form.find("input[name='state']"),
				$_country_id = $form.find("select[name='country_id']"),
				$_zip = $form.find("input[name='zip']"),
				$_company = $form.find("input[name='company']"),
				$_age = $form.find("input[name='age']"),
				$_birthday = $form.find("input[name='birthday']"),
				$_gender = $form.find("select[name='gender']"),
				$_education = $form.find("input[name='education']"),
				$_job_title = $form.find("input[name='job_title']"),
				$_day = $form.find("select[name='day']"),
				$_month = $form.find("select[name='month']"),
				$_year = $form.find("select[name='year']"),
				remote_msg = self.opts.email_exiting_message;
			remote_msg = remote_msg.replace("{STAG}", '<a href="javascript:void(0)" data-type="'+type+'" class="ssForogtPassword pjSsBtnLink">');
			remote_msg = remote_msg.replace("{ETAG}", '</a>');;
	
			if ($_name.length > 0) {
				$_name.rules("add", {
					messages: {
						required: $_name.attr("data-required")
					}
				});
			}
			if ($_email.length > 0) {
				$_email.rules("add", {
					required: true,
					email: true,
					remote: self.opts.server + "index.php?controller=pjFront&action=pjActionCheckEmail&sid=" + self.opts.sid,
					messages: {
						required: $_email.attr("data-required"),
						email: $_email.attr("data-email"),
						remote: remote_msg
					}
				});
			}
			if ($_password.length > 0) {
				$_password.rules("add", {
					required: true,
					messages: {
						required: $_password.attr("data-required")
					}
				});
			}
			if ($_phone.length > 0) {
				$_phone.rules("add", {
					messages: {
						required: $_phone.attr("data-required")
					}
				});
			}
			if ($_address.length > 0) {
				$_address.rules("add", {
					messages: {
						required: $_address.attr("data-required")
					}
				});
			}
			if ($_city.length > 0) {
				$_city.rules("add", {
					messages: {
						required: $_city.attr("data-required")
					}
				});
			}
			if ($_state.length > 0) {
				$_state.rules("add", {
					messages: {
						required: $_state.attr("data-required")
					}
				});
			}
			if ($_country_id.length > 0) {
				$_country_id.rules("add", {
					messages: {
						required: $_country_id.attr("data-required")
					}
				});
			}
			if ($_zip.length > 0) {
				$_zip.rules("add", {
					messages: {
						required: $_zip.attr("data-required")
					}
				});
			}
			if ($_company.length > 0) {
				$_company.rules("add", {
					messages: {
						required: $_company.attr("data-required")
					}
				});
			}
			if ($_age.length > 0) {
				$_age.rules("add", {
					messages: {
						required: $_age.attr("data-required")
					}
				});
			}
			if ($_birthday.length > 0) {
				$_birthday.rules("add", {
					messages: {
						required: $_birthday.attr("data-required")
					}
				});
			}
			if ($_gender.length > 0) {
				$_gender.rules("add", {
					messages: {
						required: $_gender.attr("data-required")
					}
				});
			}
			if ($_education.length > 0) {
				$_education.rules("add", {
					messages: {
						required: $_education.attr("data-required")
					}
				});
			}
			if ($_job_title.length > 0) {
				$_job_title.rules("add", {
					messages: {
						required: $_job_title.attr("data-required")
					}
				});
			}
			
			if (!validator.form()) {
				validator.showErrors();
				return false;
			}
			return true;
		},
		validateQuestion: function () {
			var validator,
				self = this,
				$form = pjQ.$('#ssQuestionForm_' + self.opts.index);
			
			pjQ.$.extend(pjQ.$.validator.messages, {
			    required: self.opts.validate_answer_msg
			});
			validator = $form.validate({
				ignore: "",
				errorPlacement: function (error, element) {
					if (!element.hasClass("additional-open-answer")) {
						error.appendTo(element.parents(".pjSsQuestionBody").find('.ssError'));
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			if (!validator.form()) {
				validator.showErrors();
				return false;
			}
			return true;
		},
		formatTimeStampToHHMMSS: function (ts) {
		    var sec_num = parseInt(ts, 10); // don't forget the second param
		    var hours   = Math.floor(sec_num / 3600);
		    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
		    var seconds = sec_num - (hours * 3600) - (minutes * 60);

		    var time = hours = '';
		    if (time > 0 && hours   < 10) {
		    	hours   = "0"+hours + ":";
		    }
		    if (minutes < 10) {minutes = "0"+minutes;}
		    if (seconds < 10) {seconds = "0"+seconds;}
		    if (sec_num == 0) {
		    	var time    = '00:00';
		    } else {
		    	var time    = hours + minutes + ':' + seconds;
		    }
		    return time;
		}
	};
	window.StivaSurvey = StivaSurvey;	
})(window);