/*!
 * Star Rating Script v4.0
 * 
 * http://www.phpjabbers.com/star-rating-script/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined);
   
	function StarRating(opts) {
		if (!(this instanceof StarRating)) {
			return new StarRating(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	StarRating.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;			
			this.opts = {};
			
			return this;
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjWrapper_" + opts.index);
			this.$container = pjQ.$(this.container);
			
			if (pjQ.$('#pjSrRate_' + self.opts.index).length)
			{
				var activeClass = 'active';
				pjQ.$('#pjSrRate_'+self.opts.index+' .pjSrListRates a').on('click', function(e) {
					e.preventDefault();
					
					var $result = pjQ.$(this);
					if($result.hasClass('pjSrRatable'))
					{
						var $resultParent = $result.parent();
						var $resultNumber = $resultParent.index() + 1;
						var $currentRail = $result.parents('.pjSrRate').find('.pjSrRateRail');
						var $resultText = $result.text();
						var $title = $result.parents('.pjSrRate').find('.pjSrRateTitle');
						var choice_id = $result.attr('data-id');
						var rate = $result.attr('data-rate');
						var params = {
								id: self.opts.item_id,
								choice_id: choice_id,
								rate: rate,
								instance_id: self.opts.instance_id
							};
						
						$result.parents('.pjSrRate').find('.pjSrFoot p').text('');
						$resultParent.addClass(activeClass);
						pjQ.$('#pjSrRate_'+self.opts.index+' .pjSrListRates a').removeClass('pjSrRatable').removeClass('pjSrHoverable');
						pjQ.$.post([self.opts.folder, "index.php?controller=pjFront&action=pjActionRate"].join(""), params).done(function (data) {
							if(data.code == '200')
							{
								$resultParent.addClass(activeClass);
								$currentRail.slider({'value': $resultNumber});
							}else{
								$resultParent.removeClass(activeClass);
							}
							$title.text(data.message);
						}).fail(function () {
							
						});
					}
				});
				pjQ.$('#pjSrRate_'+self.opts.index+' .pjSrRateRail').slider({
					min: 0,
					max: 5,
					range: 'min',
					disabled: true,
					slide: function(event, ui) {
						var $currentValue = ui.value;
						var $currentRrates = pjQ.$(this).parents('.pjSrRate').find('.pjSrListRates');
						if ($currentValue === 0) {
							$currentRrates.find('.active').removeClass(activeClass);
						} else {
							$currentRrates.find('li').filter(function() {
								return (pjQ.$(this).index() + 1) === $currentValue;
							}).addClass(activeClass).siblings().removeClass(activeClass);
						};
					}
				});
				pjQ.$('#pjSrRate_'+self.opts.index+' .pjSrListRates li').each(function() {
					pjQ.$(this).find('a').hover(function(){
						var $this = pjQ.$(this);
						if($this.hasClass('pjSrHoverable'))
						{
							var text = $this.attr('data-choice');
							var $title = $this.parents('.pjSrRate').find('.pjSrFoot p');
							$title.text(text);
						}
				 	}, function(){
				 		var $this = pjQ.$(this);
				 		if($this.hasClass('pjSrHoverable'))
						{
							var text = $this.attr('data-title');
							var $title = $this.parents('.pjSrRate').find('.pjSrFoot p');
							$title.text('');
						}
					});
				});
			};
		}
	};
	
	window.StarRating = StarRating;	
})(window);