<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminRaters extends pjAdmin
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjRaterModel = pjRaterModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjRaterModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjRaterModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}

	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['rater_create']))
			{
				$data = array();
				$data['password'] = pjToolkit::getRandomPassword();
				$id = pjRaterModel::factory()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AM03';
				} else {
					$err = 'AM04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminRaters&action=pjActionIndex&err=$err");
			} else {
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminRaters.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteRater()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjRaterModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$pjRatingModel = pjRatingModel::factory();
				$rating_id_arr = $pjRatingModel->where('rater_id', $_GET['id'])->findAll()->getDataPair(NULL, 'id');
				$pjRatingModel->reset()->where('rater_id', $_GET['id'])->eraseAll();
				if(!empty($rating_id_arr))
				{
					pjVoteModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
					pjRatingRatingTypeModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
					pjRatingUserTypeModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
				}
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteRaterBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjRaterModel::factory()->reset()->whereIn('id', $_POST['record'])->eraseAll();
				$pjRatingModel = pjRatingModel::factory();
				$rating_id_arr = $pjRatingModel->whereIn('rater_id', $_POST['record'])->findAll()->getDataPair(NULL, 'id');
				$pjRatingModel->reset()->whereIn('rater_id', $_POST['record'])->eraseAll();
				if(!empty($rating_id_arr))
				{
					pjVoteModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
					pjRatingRatingTypeModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
					pjRatingUserTypeModel::factory()->whereIn('rating_id', $rating_id_arr)->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportRater()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjRaterModel::factory()->select('t1.id, t1.name, t1.email, t1.status')->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Raters-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetRater()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRaterModel = pjRaterModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjRaterModel->where('t1.email LIKE', "%$q%");
				$pjRaterModel->orWhere('t1.name LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjRaterModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjRaterModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$data = $pjRaterModel
				->select("t1.*, 
						(SELECT COUNT(*) FROM `".pjRatingModel::factory()->getTable()."` AS t2 WHERE t2.rater_id = t1.id) as cnt_ratings,
						(SELECT t2. created FROM `".pjRatingModel::factory()->getTable()."` AS t2 WHERE t2.rater_id = t1.id ORDER BY t2.created ASC LIMIT 1) as first_rating")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()->getData();
			
			foreach($data as $k => $v)
			{
				$v['first_rating'] = !empty($v['first_rating']) ? date($this->option_arr['o_date_format'], strtotime($v['first_rating'])) : '';
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminRaters.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveRater()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRaterModel = pjRaterModel::factory();
	
			$pjRaterModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
				
			if (isset($_POST['rater_update']))
			{
				pjRaterModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminRaters&action=pjActionIndex&err=AM01");
				
			} else {
				$pjRaterModel = pjRaterModel::factory();
				$arr = $pjRaterModel
					->select("t1.*, 
						(SELECT COUNT(*) FROM `".pjRatingModel::factory()->getTable()."` AS t2 WHERE t2.rater_id = t1.id) as cnt_ratings,
						(SELECT t2. created FROM `".pjRatingModel::factory()->getTable()."` AS t2 WHERE t2.rater_id = t1.id ORDER BY t2.created ASC LIMIT 1) as first_rating")
					->find($_GET['id'])
					->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminRaters&action=pjActionIndex&err=AM08");
				}
				$this->set('arr', $arr);
								
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminRaters.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>