<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminThreads extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['thread_create']))
			{
				$id = pjThreadModel::factory()->setAttributes($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AT03';
				} else {
					$err = 'AT04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminThreads&action=pjActionIndex&err=$err");
			} else {
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminThreads.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteThread()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			if ($this->isAdmin())
			{
				if (pjThreadModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjRatingModel::factory()->where('thread_id', $_GET['id'])->eraseAll();
									
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteThreadBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ($this->isAdmin())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					pjThreadModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
					pjRatingModel::factory()->whereIn('thread_id' , $_POST['record'])->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportThread()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjThreadModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Threads-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionExportRatings()
	{
		$this->checkLogin();
		
		if (isset($_GET['thread_id']))
		{
			$arr = pjRatingModel::factory()->where('thread_id', $_GET['thread_id'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Ratings-of-thread-". $_GET['thread_id'] . '-' .time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	
	public function pjActionGetThread()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjThreadModel = pjThreadModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjThreadModel->where('t1.thread LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjThreadModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'thread';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjThreadModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjThreadModel
				->select('t1.*, (SELECT COUNT(*) FROM `'.pjRatingModel::factory()->getTable().'` AS t2 WHERE t2.thread_id = t1.id) as cnt_ratings')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();

			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminThreads.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveThread()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['column'] == 'thread')
			{
				if($_POST['value'] != '')
				{
					pjThreadModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
				}
			}else{
				pjThreadModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$pjThreadModel = pjThreadModel::factory();
			if (isset($_POST['thread_update']))
			{
				$pjThreadModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminThreads&action=pjActionIndex&err=AT01");
				
			} else {
				$pjRatingModel = pjRatingModel::factory();
				
				$arr = $pjThreadModel
					->select('t1.*, (SELECT COUNT(*) FROM `'.$pjRatingModel->getTable().'` AS t2 WHERE t2.thread_id = t1.id) as cnt_ratings,
									(SELECT t3.id FROM `'.$pjRatingModel->getTable().'` AS t3 WHERE t3.thread_id = t1.id ORDER BY t3.created DESC LIMIT 1 ) as last_id')
					->find($_GET['id'])
					->getData();
					
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminThreads&action=pjActionIndex&err=AT08");
				}
				if(!empty($arr['last_id']))
				{
					$last_arr = $pjRatingModel
						->reset()
						->select('t1.*, t2.name')
						->join("pjRater", "t1.rater_id=t2.id", 'left')
						->find($arr['last_id'])
						->getData();
					$this->set('last_arr', $last_arr);
				}
				
				$user_type_arr = pjUserTypeModel::factory()
					->select("t1.*, (SELECT COUNT(rating_id) FROM `".pjRatingUserTypeModel::factory()->getTable()."` AS t2 WHERE t2.user_type_id=t1.id) AS cnt_ratings")
					->where('t1.status', 'T')
					->orderBy("title ASC")
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('user_type_arr', $user_type_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminThreads.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPreview()
	{
		$this->setAjax(true);
		$this->setLayout('pjAdminEmpty');
	}
}
?>