<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminUserTypes extends pjAdmin
{
	public function pjActionCheckUserType()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['title']) || empty($_GET['title']))
			{
				echo 'false';
				exit;
			}
			$pjUserTypeModel = pjUserTypeModel::factory()->where('t1.title', $_GET['title']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjUserTypeModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjUserTypeModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['user_type_create']))
			{
				$id = pjUserTypeModel::factory($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ATP03';
				} else {
					$err = 'ATP04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminUserTypes&action=pjActionIndex&err=$err");
			} else {
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUserTypes.js');
			}
		} else {
			$this->set('status', 2);
		}
	}

	public function pjActionDeleteUserType()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjUserTypeModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjRatingUserTypeModel::factory()->where('user_type_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteUserTypeBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjUserTypeModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjRatingUserTypeModel::factory()->whereIn('type_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetUserType()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserTypeModel = pjUserTypeModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjUserTypeModel->where('t1.title LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjUserTypeModel->where('t1.status', $_GET['status']);
			}
			
			$column = 'title';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjUserTypeModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjUserTypeModel
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminUserTypes.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveUserType()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserTypeModel = pjUserTypeModel::factory();
			$pjUserTypeModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['user_type_update']))
			{
				pjUserTypeModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUserTypes&action=pjActionIndex&err=ATP01");
				
			} else {
				$arr = pjUserTypeModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminUserTypes&action=pjActionIndex&err=ATP08");
				}
				$this->set('arr', $arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUserTypes.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>