<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat threads">
				<div class="info">
					<abbr><?php echo $tpl['num_of_threads'];?></abbr>
					<?php echo $tpl['num_of_threads'] != 1 ? mb_strtolower(__('lblThreads', true), 'UTF-8') : mb_strtolower(__('lblThread', true), 'UTF-8');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat ratings">
				<div class="info">
					<abbr><?php echo $tpl['num_of_ratings'];?></abbr>
					<?php echo $tpl['num_of_ratings'] != 1 ? mb_strtolower(__('lblRatings', true), 'UTF-8') : mb_strtolower(__('lblRating', true), 'UTF-8');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat raters">
				<div class="info">
					<abbr><?php echo $tpl['num_of_raters'];?></abbr>
					<?php echo $tpl['num_of_raters'] != 1 ? mb_strtolower(__('menuRaters', true), 'UTF-8') : mb_strtolower(__('lblRater', true), 'UTF-8');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblMostPopularThreads')?></div>
			<div class="dashboard_column_top"><?php __('lblLatestRatings')?></div>
			<div class="dashboard_column_top"><?php __('lblTopRaters')?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row">
						<?php
						if(count($tpl['popular_threads']) > 0)
						{
							foreach($tpl['popular_threads'] as $v)
							{
								?>
								<div class="dashboard_row">							
									<div class="left">
										<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminThreads&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['thread']);?></a></label>
										<?php
										if(!empty($v['last_time']))
										{ 
											?>
											<label><?php __('lblLastRating');?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['last_time']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['last_time']));?></label>
											<?php
										} 
										?>
									</div>
									<div class="right">
										<abbr><?php echo $v['cnt_ratings'];?></abbr>
										<label><?php echo $v['cnt_ratings'] != 1 ? mb_strtolower(__('lblRatings', true), 'UTF-8') : mb_strtolower(__('lblRating', true), 'UTF-8');?></label>
									</div>
								</div>
								<?php
							}
						}else{
							?>
							<div class="dashboard_row"><label><?php __('lblDashNoThreadsFound');?></label></div>
							<?php
						} 
						?>	
					</div>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row">
						<?php
						if(count($tpl['latest_ratings']) > 0)
						{
							foreach($tpl['latest_ratings'] as $v)
							{
								?>
								<div class="dashboard_row">							
									<label class="rater"><?php __('lblBy');?> <?php echo pjSanitize::html($v['rater']);?></label>
									<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRatings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></a></label>
									<label><?php echo pjSanitize::html($v['thread']);?></label>
								</div>
								<?php
							}
						}else{
							?>
							<div class="dashboard_row"><label><?php __('lblDashNoRatingsFound');?></label></div>
							<?php
						} 
						?>	
					</div>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row">	
						<?php
						if(count($tpl['top_raters']) > 0)
						{
							foreach($tpl['top_raters'] as $v)
							{
								?>
								<div class="dashboard_row">							
									<label class="rater"><?php __('lblBy');?> <?php echo pjSanitize::html($v['name']);?></label>
									<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRaters&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['email']);?></a></label>
									<?php
									if(!empty($v['last_time']))
									{ 
										?>
										<label><?php __('lblLastRating');?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['last_time']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['last_time']));?></label>
										<?php
									} 
									?>
									<label><?php echo $v['cnt_ratings'];?> <?php echo $v['cnt_ratings'] != 1 ? mb_strtolower(__('lblRatings', true), 'UTF-8') : mb_strtolower(__('lblRating', true), 'UTF-8');?></label>
								</div>
								<?php
							}
						}else{
							?>
							<div class="dashboard_row"><label><?php __('lblDashNoRatersFound');?></label></div>
							<?php
						} 
						?>
					</div>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>