<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$is_exiting = __('existing_arr', true);

	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/ratingmenu.php';
	
	pjUtil::printNotice(__('infoAddRatingTitle', true), __('infoAddRatingDesc', true));
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRatings&amp;action=pjActionCreate" method="post" id="frmCreateRating" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="rating_create" value="1" />
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblRater'); ?></label>
				<span class="inline_block">
					<select name="is_existing" id="is_existing" class="pj-form-field w250 required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="T"><?php echo $is_exiting['T']; ?></option>
						<option value="F"><?php echo $is_exiting['F']; ?></option>
					</select>
				</span>
			</p>
			<div id="new_container" style="display:none;">
				<p>
					<label class="title"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" name="name" id="name" class="pj-form-field w250" data-msg-required="<?php __('lblFieldRequired');?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('email'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="email" id="email" class="pj-form-field w200" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-email="<?php __('lblEmailInvalid');?>"/>
					</span>
				</p>
			</div>
			<div id="existing_container" style="display:block;">
				<p>
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<?php
						if(!empty($tpl['rater_arr']))
						{ 
							?>
							<select name="rater_id" id="rater_id" class="pj-form-field required w250" data-msg-required="<?php __('lblFieldRequired');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['rater_arr'] as $k => $v)
								{
									?><option value="<?php echo $v['id']; ?>"><?php echo $v['name']; ?></option><?php
								}
								?>
							</select>
							<a id="pjPcEditRater" href="#" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRaters&amp;action=pjActionUpdate&amp;id={ID}" class="pjPcEdit"></a>
							<?php
						}else{
							$message = __('lblNoReviewersAvailable', true);
							$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminRaters&amp;action=pjActionCreate">', $message);
							$message = str_replace("{ETAG}", '</a>', $message)
							?><label><?php echo $message;?></label><?php
						} 
						?>
					</span>
				</p>
			</div>
			<p>
				<label class="title"><?php __('lblThread'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['thread_arr']))
					{ 
						?>
						<select name="thread_id" id="thread_id" class="pj-form-field required w250" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['thread_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>" data-url="<?php echo $v['page_url'];?>"><?php echo $v['thread']; ?></option><?php
							}
							?>
						</select>
						<a id="pjPcEditThread" href="#" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminThreads&amp;action=pjActionUpdate&amp;id={ID}" class="pjPcEdit"></a>
						<a id="pjPcPreviewThread" href="#" class="pjPcPreview pjPcTopPreview" target="_blank"></a>
						<?php
					}else{
						$message = __('lblNoTheadsMessage', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminThreads&amp;action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", '</a>', $message);
						?>
						<label class="block float_left t5"><?php echo $message;?></label>
						<input type="hidden" name="thread_id" value="" class="required"/>
						<?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblOverall'); ?></label>
				<span class="inline_block">
					<input type="text" name="overall" class="pj-form-field required w400" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPros'); ?></label>
				<span class="inline_block">
					<textarea name="pros" class="pj-form-field w568 h100"></textarea>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCons'); ?></label>
				<span class="inline_block">
					<textarea name="cons" class="pj-form-field w568 h100"></textarea>
				</span>
			</p>
			<?php
			if(!empty($tpl['rating_type_arr']))
			{
				foreach($tpl['rating_type_arr'] as $k => $v)
				{
					?>
					<p>
						<label class="title"><?php echo $v['title']; ?></label>
						<input type="hidden" id="rating_value_<?php echo $v['id'];?>" name="rating[<?php echo $v['id'];?>]" value="0" />
						<span class="rating" data-id="<?php echo $v['id'];?>">
							<span id="star_<?php echo $v['id'];?>_1" class="star" lang="1"></span>
							<span id="star_<?php echo $v['id'];?>_2" class="star" lang="2"></span>
							<span id="star_<?php echo $v['id'];?>_3" class="star" lang="3"></span>
							<span id="star_<?php echo $v['id'];?>_4" class="star" lang="4"></span>
							<span id="star_<?php echo $v['id'];?>_5" class="star" lang="5"></span>
						</span>
					</p>
					<?php
				}
			} 
			
			if(!empty($tpl['user_type_arr']))
			{
				?>
				<p>
					<label class="title"><?php __('lblUserType'); ?></label>
					<span class="inline_block">
						<?php
						foreach ($tpl['user_type_arr'] as $k => $v)
						{
							?><span class="block t6"><input type="checkbox" name="user_type[<?php echo $v['id']?>]" id="user_type_<?php echo $v['id'];?>" value="<?php echo $v['id'];?>" class="block float_left r5"/><label for="user_type_<?php echo $v['id'];?>"><?php echo $v['title'];?></label></span><?php
						}
						?>
					</span>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('rating_statuses', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == 'T' ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminRatings&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<?php
}
?>