<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/ratingmenu.php';
	
	pjUtil::printNotice(__('infoExportFeedTitle', true), __('infoExportFeedDesc', true));
	
	$export_formats = __('export_formats', true, false);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRatings&amp;action=pjActionFeed" method="post" id="frmXMLFeed" class="form pj-form">
		<input type="hidden" name="rating_feed" value="1" />
		<p>
			<label class="title"><?php __('lblThread'); ?></label>
			<span class="inline_block">
				<select name="thread_id" id="thread_id" class="pj-form-field w150">
					<option value="">-- <?php __('lblAllThreads');?> --</option>
					<?php
					foreach($tpl['thread_arr'] as $v)
					{
						?><option value="<?php echo $v['id']?>"<?php echo (isset($_POST['thread_id']) && $_POST['thread_id'] == $v['id']) || (isset($_GET['thread_id']) && $_GET['thread_id'] == $v['id']) ? ' selected="selected"' : null; ?>><?php echo pjSanitize::html($v['thread']);?></option><?php
					} 
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblFormat'); ?></label>
			<span class="inline_block">
				<select name="format" id="format" class="pj-form-field w100">
					<?php
					foreach ($export_formats as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo isset($_POST['format']) && $_POST['format'] == $k ? ' selected="selected"' : null; ?>><?php echo pjSanitize::html($v); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblEnterPassword');?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
				<input type="text" id="feed_password" name="password" class="pj-form-field w200 required" value="<?php echo isset($_POST['password']) ? $_POST['password'] : null; ?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPeriod'); ?></label>
			<span class="inline_block">
				<select name="period" id="period" class="pj-form-field w150">
					<?php
					foreach(__('peirod_arr', true) as $k => $v)
					{
						?><option value="<?php echo $k;?>"<?php echo isset($_POST['period']) ? ($_POST['period'] == $k ? ' selected="selected"' : null) : null; ?>><?php echo $v;?></option><?php 
					} 
					?>
				</select>
			</span>
		</p>
		
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" id="tsSubmitButton" value="<?php __('btnGetFeedURL'); ?>" class="pj-button" />
		</p>
		<?php
		if(isset($_POST['rating_feed'])) 
		{
			?>
			<div class="tsFeedContainer">
				<br/>
				<?php pjUtil::printNotice(__('infoRatingsFeedTitle', true), __('infoRatingsFeedDesc', true)); ?>
				<span class="inline_block">
					<textarea name="ratings_feed" class="pj-form-field h80" style="width: 726px;"><?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminRatings&amp;action=pjActionExportFeed<?php echo !empty($_POST['thread_id']) ? '&thread_id=' . $_POST['thread_id'] : null;?>&amp;format=<?php echo$_POST['format']; ?>&amp;period=<?php echo $_POST['period']; ?>&amp;p=<?php echo isset($tpl['password']) ? $tpl['password'] : null;?></textarea>
				</span>
			</div>
			<?php
		} 
		?>
	</form>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.btn_export = "<?php __('btnExport'); ?>";
	myLabel.btn_get_url = "<?php __('btnGetFeedURL'); ?>";
	</script>
	<?php
}
?>