var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateThread = $("#frmCreateThread"),
			$frmUpdateThread = $("#frmUpdateThread"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateThread.length > 0 && validate) {
			$frmCreateThread.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateThread.length > 0 && validate) {
			$frmUpdateThread.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'page_url')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmCreateThread.length > 0 || $frmUpdateThread.length > 0) 
		{
			$.validator.addMethod("refid", function(value, element) {
		        return this.optional(element) || /^[a-z0-9]+$/i.test(value);
		    });
			$.validator.addMethod("pageurl", function(val, elem) {
			    if (val.length == 0) { return true; }
			    
			    return /^http:\/\/|(www\.)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/i.test(val);
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function onBeforeShow (obj) {
				if (pjGrid.roleId === 2) {
					return false;
				}
				return true;
			}
			function formatDefault (str, obj) {
				if (obj.role_id == 3) {
					return '<a href="#" class="pj-status-icon pj-status-' + (str == 'F' ? '0' : '1') + '" style="cursor: ' +  (str == 'F' ? 'pointer' : 'default') + '"></a>';
				} else {
					return '<a href="#" class="pj-status-icon pj-status-1" style="cursor: default"></a>';
				}
			}
			function formatPageUrl(str, obj){
				if(str == '')
				{
					return '';
				}else{
					return '<a href="'+str+'" target="_blank">'+str+'</a>';
				}
			}
			function formatRatings(str, obj){
				if(str == '0')
				{
					return 0;
				}else{
					return '<a href="index.php?controller=pjAdminRatings&action=pjActionIndex&thread_id='+obj.id+'">'+str+'</a>';
				}
			}
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminThreads&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminThreads&action=pjActionDeleteThread&id={:id}", beforeShow: onBeforeShow},
						  {type: "menu", url: "#", text: myLabel.more, items:[
    				              {text: myLabel.preview, url: "preview.php?thread_id={:id}", ajax: false, render: true, target: "_blank"},
    				              {text: myLabel.install, url: "index.php?controller=pjAdminOptions&action=pjActionInstall&id={:id}", ajax: false, render: true},
    				              {text: myLabel.exportratings, url: "index.php?controller=pjAdminRatings&action=pjActionFeed&thread_id={:id}", ajax: false, render:true}
    				      ]}],
				columns: [{text: myLabel.id, type: "text", sortable: true, editable: false, width: 110},
				          {text: myLabel.thread, type: "text", sortable: false, editable: false, width: 260, renderer: formatPageUrl},
				          {text: myLabel.ratings, type: "text", sortable: false, editable: false, width: 80, align: 'center', renderer: formatRatings},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 110, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminThreads&action=pjActionGetThread",
				dataType: "json",
				fields: ['thread', 'page_url', 'cnt_ratings', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminThreads&action=pjActionDeleteThreadBulk", render: false, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminThreads&action=pjActionExportThread", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminThreads&action=pjActionSaveThread&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminThreads&action=pjActionGetThread", "thread", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminThreads&action=pjActionGetThread", "thread", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminThreads&action=pjActionGetThread", "id", "ASC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);